/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.audit;

import io.confluent.security.authorizer.RequestContext;
import java.net.InetAddress;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;

class MockRequestContext
implements RequestContext {
    public final RequestHeader header;
    public final String connectionId;
    public final InetAddress clientAddress;
    public final KafkaPrincipal principal;
    public final ListenerName listenerName;
    public final SecurityProtocol securityProtocol;
    public final String requestSource;

    public MockRequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, String requestSource) {
        this.header = header;
        this.connectionId = connectionId;
        this.clientAddress = clientAddress;
        this.principal = principal;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.requestSource = requestSource;
    }

    public String listenerName() {
        return this.listenerName.value();
    }

    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public KafkaPrincipal principal() {
        return this.principal;
    }

    public InetAddress clientAddress() {
        return this.clientAddress;
    }

    public int requestType() {
        return this.header.apiKey().id;
    }

    public int requestVersion() {
        return this.header.apiVersion();
    }

    public String clientId() {
        return this.header.clientId();
    }

    public int correlationId() {
        return this.header.correlationId();
    }

    public String requestSource() {
        return this.requestSource;
    }
}

