/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.audit;

import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnPatternMatcher;
import io.confluent.crn.CrnSyntaxException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class CrnPatternMatcherBenchmark {
    private static final int DISTINCT_KEYS = 10000;
    private static final int PATTERNS = 1000;
    private static final int CLUSTERS = 10;
    private static final String KEY = "the_key_to_use";
    private static final String VALUE = "the quick brown fox jumped over the lazy dog the olympics are about to start";
    private final ConfluentResourceName[] keys = new ConfluentResourceName[10000];
    private final String[] values = new String[10000];
    private CrnPatternMatcher<String> matcher;
    private long counter = 0L;

    @Setup(value=Level.Trial)
    public void setUp() throws CrnSyntaxException {
        int i;
        CrnPatternMatcher.Builder builder = CrnPatternMatcher.builder();
        for (i = 0; i < 1000; ++i) {
            String patternString = String.format("crn://%s/kafka=%d*/topic=clicks%d*", i % 2 == 0 ? "confluent.cloud" : "", i % 10, i / 10);
            this.values[i] = VALUE + i;
            builder.setPattern(ConfluentResourceName.fromString((String)patternString), (Object)this.values[i]);
        }
        this.matcher = builder.build();
        for (i = 0; i < 10000; ++i) {
            this.keys[i] = ConfluentResourceName.fromString((String)String.format("crn://%s/kafka=%d/topic=clicks%d", i % 3 == 0 ? "confluent.cloud" : "", i % 10, i / 10));
        }
    }

    @Benchmark
    public String testMatcherPerformance() {
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        ConfluentResourceName key = this.keys[index];
        return (String)this.matcher.match(key);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(CrnPatternMatcherBenchmark.class.getSimpleName()).forks(2).build();
        new Runner(opt).run();
    }
}

