/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.audit;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.kafka.KafkaMessageFactory;
import io.confluent.telemetry.events.Event;
import io.confluent.telemetry.events.EventUtils;
import io.confluent.telemetry.events.exporter.Exporter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.config.ConfigException;

public class CountExporter
implements Exporter<Event> {
    public RuntimeException configureException;
    public boolean routeReady = true;
    public ConcurrentHashMap<String, Integer> counts = new ConcurrentHashMap();
    private final EventFormat structuredEventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    public void configure(Map<String, ?> configs) {
        if (this.configureException != null) {
            throw this.configureException;
        }
    }

    private String route(Event event) {
        if (event.extensionNames().contains("route")) {
            return event.extension("route");
        }
        return "default";
    }

    public void emit(Event event) throws RuntimeException {
        String topicName = this.route(event);
        this.counts.compute(topicName, (k, v) -> v == null ? 1 : v + 1);
        ProducerRecord<String, byte[]> result = this.createProducerRecord(event, topicName);
    }

    private ProducerRecord<String, byte[]> createProducerRecord(Event event, String topic) {
        CloudEvent data = EventUtils.toCloudEvent((Event)event);
        MessageWriter messageWriter = KafkaMessageFactory.createWriter((String)topic, null);
        return (ProducerRecord)messageWriter.writeStructured(data, this.structuredEventFormat);
    }

    public boolean routeReady(Event event) {
        return this.routeReady;
    }

    public Set<String> reconfigurableConfigs() {
        return Collections.emptySet();
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    public void close() throws Exception {
    }
}

