/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.acl;

import io.confluent.kafka.security.authorizer.acl.AclMapper;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.collection.JavaConverters;
import scala.collection.mutable.HashSet;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class AclAuthorizerBenchmark {
    @Param(value={"10000", "50000", "200000"})
    private int resourceCount;
    @Param(value={"10", "50"})
    private int aclCount;
    @Param(value={"0", "20", "50", "90", "99", "99.9", "99.99", "100"})
    private double denyPercentage;
    private final int hostPreCount = 1000;
    private final String resourceNamePrefix = "foo-bar35_resource-";
    private final AclAuthorizer aclAuthorizer = new AclAuthorizer();
    private final KafkaPrincipal principal = new KafkaPrincipal("User", "test-user");
    private List<Action> actions = new ArrayList<Action>();
    private RequestContext authorizeContext;
    private RequestContext authorizeByResourceTypeContext;
    private String authorizeByResourceTypeHostName = "127.0.0.2";
    private HashMap<ResourcePattern, AclAuthorizer.VersionedAcls> aclToUpdate = new HashMap();
    Random rand = new Random(System.currentTimeMillis());
    double eps = 1.0E-9;

    @Setup(value=Level.Trial)
    public void setup() throws Exception {
        this.prepareAclCache();
        this.prepareAclToUpdate();
        this.actions = Collections.singletonList(new Action(AclOperation.WRITE, new ResourcePattern(ResourceType.TOPIC, "foo-bar35_resource-95", PatternType.LITERAL), 1, true, true));
        this.authorizeContext = new RequestContext(new RequestHeader(ApiKeys.PRODUCE, Integer.valueOf(1).shortValue(), "someclient", 1), "1", InetAddress.getByName("127.0.0.1"), this.principal, ListenerName.normalised((String)"listener"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        this.authorizeByResourceTypeContext = new RequestContext(new RequestHeader(ApiKeys.PRODUCE, Integer.valueOf(1).shortValue(), "someclient", 1), "1", InetAddress.getByName(this.authorizeByResourceTypeHostName), this.principal, ListenerName.normalised((String)"listener"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
    }

    private void prepareAclCache() {
        HashMap<ResourcePattern, Set> aclEntries = new HashMap<ResourcePattern, Set>();
        for (int resourceId = 0; resourceId < this.resourceCount; ++resourceId) {
            ResourcePattern resource = new ResourcePattern(resourceId % 10 == 0 ? ResourceType.GROUP : ResourceType.TOPIC, "foo-bar35_resource-" + resourceId, resourceId % 5 == 0 ? PatternType.PREFIXED : PatternType.LITERAL);
            Set entries = aclEntries.computeIfAbsent(resource, k -> new java.util.HashSet());
            for (int aclId = 0; aclId < this.aclCount; ++aclId) {
                String principalName = this.principal.toString() + (aclId == 0 ? "" : Integer.valueOf(aclId));
                AccessControlEntry allowAce = new AccessControlEntry(principalName, "*", AclOperation.READ, AclPermissionType.ALLOW);
                entries.add(new AclEntry(allowAce, resource));
                if (!this.shouldDeny().booleanValue()) continue;
                AccessControlEntry denyAce = new AccessControlEntry(principalName, "*", AclOperation.READ, AclPermissionType.DENY);
                entries.add(new AclEntry(denyAce, resource));
            }
        }
        ResourcePattern resourcePrefix = new ResourcePattern(ResourceType.TOPIC, "foo-bar35_resource-", PatternType.PREFIXED);
        Set entriesPrefix = aclEntries.computeIfAbsent(resourcePrefix, k -> new java.util.HashSet());
        for (int hostId = 0; hostId < 1000; ++hostId) {
            AccessControlEntry allowAce = new AccessControlEntry(this.principal.toString(), "127.0.0." + hostId, AclOperation.READ, AclPermissionType.ALLOW);
            entriesPrefix.add(new AclEntry(allowAce, resourcePrefix));
            if (!this.shouldDeny().booleanValue()) continue;
            AccessControlEntry denyAce = new AccessControlEntry(this.principal.toString(), "127.0.0." + hostId, AclOperation.READ, AclPermissionType.DENY);
            entriesPrefix.add(new AclEntry(denyAce, resourcePrefix));
        }
        ResourcePattern resourceWildcard = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        Set entriesWildcard = aclEntries.computeIfAbsent(resourceWildcard, k -> new java.util.HashSet());
        for (int hostId = 0; hostId < this.resourceCount / 10; ++hostId) {
            String hostName = "127.0.0" + hostId;
            if (hostName.equals(this.authorizeByResourceTypeHostName)) continue;
            AccessControlEntry allowAce = new AccessControlEntry(this.principal.toString(), hostName, AclOperation.READ, AclPermissionType.ALLOW);
            entriesWildcard.add(new AclEntry(allowAce, resourceWildcard));
            if (!this.shouldDeny().booleanValue()) continue;
            AccessControlEntry denyAce = new AccessControlEntry(this.principal.toString(), hostName, AclOperation.READ, AclPermissionType.DENY);
            entriesWildcard.add(new AclEntry(denyAce, resourceWildcard));
        }
        for (Map.Entry entryMap : aclEntries.entrySet()) {
            this.aclAuthorizer.updateCache((ResourcePattern)entryMap.getKey(), new AclAuthorizer.VersionedAcls(((scala.collection.mutable.Set)JavaConverters.asScalaSetConverter((Set)((Set)entryMap.getValue())).asScala()).toSet(), 1));
        }
    }

    private void prepareAclToUpdate() {
        HashSet entries = new HashSet();
        for (int i = 0; i < this.resourceCount; ++i) {
            scala.collection.immutable.HashSet immutable = new scala.collection.immutable.HashSet();
            ResourcePattern resourcePattern = new ResourcePattern(ResourceType.TOPIC, this.randomResourceName("foo-bar35_resource-"), PatternType.LITERAL);
            for (int j = 0; j < this.aclCount; ++j) {
                entries.add((Object)new AclEntry(new AccessControlEntry(this.principal.toString(), "127.0.0" + j, AclOperation.WRITE, AclPermissionType.ALLOW), resourcePattern));
                immutable = entries.toSet();
            }
            this.aclToUpdate.put(resourcePattern, new AclAuthorizer.VersionedAcls((scala.collection.immutable.Set)immutable, i));
        }
    }

    private String randomResourceName(String prefix) {
        return prefix + UUID.randomUUID().toString().substring(0, 5);
    }

    private Boolean shouldDeny() {
        return this.rand.nextDouble() * 100.0 - this.eps < this.denyPercentage;
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.aclAuthorizer.close();
    }

    @Benchmark
    public void testAclsIterator() {
        this.aclAuthorizer.acls(AclBindingFilter.ANY);
    }

    @Benchmark
    public void testAuthorizer() {
        this.aclAuthorizer.authorize((AuthorizableRequestContext)this.authorizeContext, this.actions);
    }

    @Benchmark
    public void testAuthorizeByResourceType() {
        this.aclAuthorizer.authorizeByResourceType((AuthorizableRequestContext)this.authorizeByResourceTypeContext, AclOperation.READ, ResourceType.TOPIC);
    }

    @Benchmark
    public void testUpdateCache() {
        AclAuthorizer aclAuthorizer = new AclAuthorizer();
        for (Map.Entry<ResourcePattern, AclAuthorizer.VersionedAcls> e : this.aclToUpdate.entrySet()) {
            aclAuthorizer.updateCache(e.getKey(), e.getValue());
        }
    }

    @Benchmark
    public void testFindAndTransform() {
        AtomicInteger filterOneHundredth = new AtomicInteger(0);
        this.aclAuthorizer.matchingAcls(ResourceType.TOPIC, "foo-bar35_resource-9").find(p -> filterOneHundredth.incrementAndGet() % 100 == 0).map(acl -> AclMapper.accessRule((AclEntry)acl));
    }
}

