/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.record;

import java.nio.ByteBuffer;
import kafka.common.LongRef;
import kafka.log.AppendOrigin;
import kafka.log.LogValidator;
import kafka.server.BrokerTopicStats;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.jmh.record.BaseRecordBatchBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
public class UncompressedRecordBatchValidationBenchmark
extends BaseRecordBatchBenchmark {
    @Override
    CompressionType compressionType() {
        return CompressionType.NONE;
    }

    @Benchmark
    public void measureAssignOffsetsNonCompressed(Blackhole bh) {
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.singleBatchBuffer.duplicate());
        LogValidator.assignOffsetsNonCompressed((MemoryRecords)records, (TopicPartition)new TopicPartition("a", 0), (LongRef)new LongRef((long)this.startingOffset), (long)System.currentTimeMillis(), (boolean)false, (TimestampType)TimestampType.CREATE_TIME, (long)Long.MAX_VALUE, (int)0, (AppendOrigin)new AppendOrigin.Client$(), (byte)this.messageVersion, (BrokerTopicStats)this.brokerTopicStats);
    }
}

