/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.metadata;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.AdminManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.FetchManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MetadataRequestBenchmark {
    @Param(value={"500", "1000", "5000"})
    private int topicCount;
    @Param(value={"10", "20", "50"})
    private int partitionCount;
    private RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class, (MockSettings)Mockito.withSettings().stubOnly());
    private RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private AdminManager adminManager = (AdminManager)Mockito.mock(AdminManager.class);
    private TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private KafkaController kafkaController = (KafkaController)Mockito.mock(KafkaController.class);
    private KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private Metrics metrics = new Metrics();
    private int brokerId = 1;
    private MetadataCache metadataCache = new MetadataCache(this.brokerId);
    private ClientQuotaManager clientQuotaManager = (ClientQuotaManager)Mockito.mock(ClientQuotaManager.class);
    private ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)Mockito.mock(ClientRequestQuotaManager.class);
    private ControllerMutationQuotaManager controllerMutationQuotaManager = (ControllerMutationQuotaManager)Mockito.mock(ControllerMutationQuotaManager.class);
    private ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
    private QuotaFactory.QuotaManagers quotaManagers = new QuotaFactory.QuotaManagers(this.clientQuotaManager, this.clientQuotaManager, this.clientRequestQuotaManager, this.controllerMutationQuotaManager, this.replicaQuotaManager, this.replicaQuotaManager, this.replicaQuotaManager, Option.empty());
    private FetchManager fetchManager = (FetchManager)Mockito.mock(FetchManager.class);
    private BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private KafkaPrincipal principal = new KafkaPrincipal("User", "test-user");
    private KafkaApis kafkaApis;
    private RequestChannel.Request allTopicMetadataRequest;

    @Setup(value=Level.Trial)
    public void setup() {
        this.initializeMetadataCache();
        this.kafkaApis = this.createKafkaApis();
        this.allTopicMetadataRequest = this.buildAllTopicMetadataRequest();
    }

    private void initializeMetadataCache() {
        LinkedList liveBrokers = new LinkedList();
        LinkedList partitionStates = new LinkedList();
        IntStream.range(0, 5).forEach(brokerId -> liveBrokers.add(new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(this.endpoints(brokerId)).setRack("rack1")));
        IntStream.range(0, this.topicCount).forEach(topicId -> {
            String topicName = "topic-" + topicId;
            IntStream.range(0, this.partitionCount).forEach(partitionId -> partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(1).setLeader(this.partitionCount % 5).setLeaderEpoch(0).setIsr(Arrays.asList(0, 1, 3)).setZkVersion(1).setReplicas(Arrays.asList(0, 1, 3))));
        });
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 1, 1, 1L, partitionStates, liveBrokers).build();
        this.metadataCache.updateMetadata(100, updateMetadataRequest);
    }

    private List<UpdateMetadataRequestData.UpdateMetadataEndpoint> endpoints(int brokerId) {
        return Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host_" + brokerId).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()));
    }

    private KafkaApis createKafkaApis() {
        Properties kafkaProps = new Properties();
        kafkaProps.put(KafkaConfig$.MODULE$.ZkConnectProp(), "zk");
        kafkaProps.put(KafkaConfig$.MODULE$.BrokerIdProp(), this.brokerId + "");
        BrokerFeatures brokerFeatures = BrokerFeatures.createDefault();
        return new KafkaApis(this.requestChannel, this.replicaManager, this.adminManager, this.groupCoordinator, this.transactionCoordinator, this.kafkaController, this.kafkaZkClient, this.brokerId, new KafkaConfig((Map)kafkaProps), this.metadataCache, this.metrics, Option.empty(), this.quotaManagers, this.fetchManager, this.brokerTopicStats, "clusterId", (Time)new SystemTime(), null, brokerFeatures, new FinalizedFeatureCache(brokerFeatures));
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.kafkaApis.close();
        this.metrics.close();
    }

    private RequestChannel.Request buildAllTopicMetadataRequest() {
        MetadataRequest metadataRequest = (MetadataRequest)MetadataRequest.Builder.allTopics().build();
        ByteBuffer buffer = metadataRequest.serialize(new RequestHeader(metadataRequest.api, metadataRequest.version(), "", 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", null, this.principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics);
    }

    @Benchmark
    public void testMetadataRequestForAllTopics() {
        this.kafkaApis.handleTopicMetadataRequest(this.allTopicMetadataRequest);
    }
}

