/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.consumer;

import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class SubscriptionStateBenchmark {
    @Param(value={"5000"})
    int topicCount;
    @Param(value={"50"})
    int partitionCount;
    SubscriptionState subscriptionState;

    @Setup(value=Level.Trial)
    public void setup() {
        HashSet assignment = new HashSet(this.topicCount * this.partitionCount);
        IntStream.range(0, this.topicCount).forEach(topicId -> IntStream.range(0, this.partitionCount).forEach(partitionId -> assignment.add(new TopicPartition(String.format("topic-%04d", topicId), partitionId))));
        this.subscriptionState = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        this.subscriptionState.assignFromUser(assignment);
        SubscriptionState.FetchPosition position = new SubscriptionState.FetchPosition(0L, Optional.of(0), new Metadata.LeaderAndEpoch(Optional.of(new Node(0, "host", 9092)), Optional.of(10)));
        assignment.forEach(topicPartition -> {
            this.subscriptionState.seekUnvalidated(topicPartition, position);
            this.subscriptionState.completeValidation(topicPartition);
        });
    }

    @Benchmark
    public boolean testHasAllFetchPositions() {
        return this.subscriptionState.hasAllFetchPositions();
    }

    @Benchmark
    public int testFetchablePartitions() {
        return this.subscriptionState.fetchablePartitions(tp -> true).size();
    }

    @Benchmark
    public int testPartitionsNeedingValidation() {
        return this.subscriptionState.partitionsNeedingValidation(0L).size();
    }
}

