/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.cache;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.cache.LRUCache;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class LRUCacheBenchmark {
    private static final int DISTINCT_KEYS = 10000;
    private static final String KEY = "the_key_to_use";
    private static final String VALUE = "the quick brown fox jumped over the lazy dog the olympics are about to start";
    private final String[] keys = new String[10000];
    private final String[] values = new String[10000];
    private LRUCache<String, String> lruCache;
    private long counter = 0L;

    @Setup(value=Level.Trial)
    public void setUp() {
        for (int i = 0; i < 10000; ++i) {
            this.keys[i] = KEY + i;
            this.values[i] = VALUE + i;
        }
        this.lruCache = new LRUCache(100);
    }

    @Benchmark
    public String testCachePerformance() {
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        String hashkey = this.keys[index];
        this.lruCache.put((Object)hashkey, (Object)this.values[index]);
        return (String)this.lruCache.get((Object)hashkey);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(LRUCacheBenchmark.class.getSimpleName()).forks(2).build();
        new Runner(opt).run();
    }
}

