/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.acl;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.collection.JavaConverters;
import scala.collection.immutable.TreeMap;
import scala.math.Ordering;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class AclAuthorizerBenchmark {
    @Param(value={"10000", "50000", "200000"})
    private int resourceCount;
    @Param(value={"10", "50"})
    private int aclCount;
    private final int hostPreCount = 1000;
    private final String resourceNamePrefix = "foo-bar35_resource-";
    private final AclAuthorizer aclAuthorizer = new AclAuthorizer();
    private final KafkaPrincipal principal = new KafkaPrincipal("User", "test-user");
    private List<Action> actions = new ArrayList<Action>();
    private RequestContext context;

    @Setup(value=Level.Trial)
    public void setup() throws Exception {
        this.setFieldValue(this.aclAuthorizer, AclAuthorizer.class.getDeclaredField("aclCache").getName(), this.prepareAclCache());
        this.actions = Collections.singletonList(new Action(AclOperation.WRITE, new ResourcePattern(ResourceType.TOPIC, "foo-bar35_resource-95", PatternType.LITERAL), 1, true, true));
        this.context = new RequestContext(new RequestHeader(ApiKeys.PRODUCE, Integer.valueOf(1).shortValue(), "someclient", 1), "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.normalised((String)"listener"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY);
    }

    private void setFieldValue(Object obj, String fieldName, Object value) throws Exception {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(obj, value);
    }

    private TreeMap<ResourcePattern, AclAuthorizer.VersionedAcls> prepareAclCache() {
        HashMap<ResourcePattern, Set> aclEntries = new HashMap<ResourcePattern, Set>();
        for (int resourceId = 0; resourceId < this.resourceCount; ++resourceId) {
            ResourcePattern resource = new ResourcePattern(resourceId % 10 == 0 ? ResourceType.GROUP : ResourceType.TOPIC, "foo-bar35_resource-" + resourceId, resourceId % 5 == 0 ? PatternType.PREFIXED : PatternType.LITERAL);
            Set entries = aclEntries.computeIfAbsent(resource, k -> new HashSet());
            for (int aclId = 0; aclId < this.aclCount; ++aclId) {
                AccessControlEntry ace = new AccessControlEntry(this.principal.toString() + aclId, "*", AclOperation.READ, AclPermissionType.ALLOW);
                entries.add(new AclEntry(ace));
            }
        }
        ResourcePattern resourcePrefix = new ResourcePattern(ResourceType.TOPIC, "foo-bar35_resource-", PatternType.PREFIXED);
        Set entriesPrefix = aclEntries.computeIfAbsent(resourcePrefix, k -> new HashSet());
        for (int hostId = 0; hostId < 1000; ++hostId) {
            AccessControlEntry ace = new AccessControlEntry(this.principal.toString(), "127.0.0." + hostId, AclOperation.READ, AclPermissionType.ALLOW);
            entriesPrefix.add(new AclEntry(ace));
        }
        ResourcePattern resourceWildcard = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        Set entriesWildcard = aclEntries.computeIfAbsent(resourceWildcard, k -> new HashSet());
        for (int hostId = 0; hostId < this.resourceCount / 10; ++hostId) {
            AccessControlEntry ace = new AccessControlEntry(this.principal.toString(), "127.0.0." + hostId, AclOperation.READ, AclPermissionType.ALLOW);
            entriesWildcard.add(new AclEntry(ace));
        }
        TreeMap aclCache = new TreeMap((Ordering)new AclAuthorizer.ResourceOrdering());
        for (Map.Entry entry : aclEntries.entrySet()) {
            aclCache = aclCache.updated(entry.getKey(), (Object)new AclAuthorizer.VersionedAcls(((scala.collection.mutable.Set)JavaConverters.asScalaSetConverter((Set)((Set)entry.getValue())).asScala()).toSet(), 1));
        }
        return aclCache;
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.aclAuthorizer.close();
    }

    @Benchmark
    public void testAclsIterator() {
        this.aclAuthorizer.acls(AclBindingFilter.ANY);
    }

    @Benchmark
    public void testAuthorizer() {
        this.aclAuthorizer.authorize((AuthorizableRequestContext)this.context, this.actions);
    }
}

