/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.rest.datapreview.extension.util;

import io.confluent.connect.rest.datapreview.extension.util.PreviewRecordTransformer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.runtime.tracing.TraceRecord;
import org.apache.kafka.connect.runtime.tracing.TraceRecordBuilderImpl;
import org.junit.Assert;
import org.junit.Test;

public class PreviewRecordTransformerTest {
    public static PreviewRecordTransformer<TraceRecord> previewRecordTransformer = new PreviewRecordTransformer();

    private TraceRecord createTestRecord(Integer currentStep, Integer totalSteps) {
        Struct metadata = new Struct(TraceRecordBuilderImpl.METADATA_SCHEMA);
        metadata.put("connector", (Object)"test_connector");
        metadata.put("current_step", (Object)currentStep);
        metadata.put("total_step", (Object)totalSteps);
        Schema valueSchema = SchemaBuilder.struct().field("metadata", TraceRecordBuilderImpl.METADATA_SCHEMA).build();
        Struct value = new Struct(valueSchema);
        value.put("metadata", (Object)metadata);
        return new TraceRecord(null, null, null, null, valueSchema, (Object)value, null, null);
    }

    private Map<String, String> transformConfigs(Integer expectedTotalSteps) {
        HashMap<String, String> transformConfig = new HashMap<String, String>();
        transformConfig.put("expected.total.steps", Integer.valueOf(4).toString());
        return transformConfig;
    }

    @Test
    public void testRemoveTraceRecord() {
        TraceRecord traceRecord = this.createTestRecord(4, 4);
        Map<String, String> transformConfig = this.transformConfigs(4);
        previewRecordTransformer.configure(transformConfig);
        Assert.assertNull((Object)previewRecordTransformer.apply((ConnectRecord)traceRecord));
    }

    @Test
    public void testDecreaseTotalSteps() {
        TraceRecord traceRecord = this.createTestRecord(1, 4);
        Map<String, String> transformConfig = this.transformConfigs(4);
        previewRecordTransformer.configure(transformConfig);
        TraceRecord transformedRecord = (TraceRecord)previewRecordTransformer.apply((ConnectRecord)traceRecord);
        Struct metadata = (Struct)((Struct)transformedRecord.value()).get("metadata");
        Assert.assertEquals((long)3L, (long)metadata.getInt32("total_step").intValue());
    }

    @Test
    public void testNoOpTransform() {
        TraceRecord traceRecord = this.createTestRecord(2, 2);
        Map<String, String> transformConfig = this.transformConfigs(4);
        previewRecordTransformer.configure(transformConfig);
        TraceRecord transformedRecord = (TraceRecord)previewRecordTransformer.apply((ConnectRecord)traceRecord);
        Assert.assertNotNull((Object)transformedRecord);
        Struct metadata = (Struct)((Struct)transformedRecord.value()).get("metadata");
        Assert.assertEquals((long)2L, (long)metadata.getInt32("total_step").intValue());
    }
}

