/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.rest.datapreview.extension.service;

import io.confluent.connect.rest.datapreview.extension.entities.ConnectorDataPreviewRequest;
import io.confluent.connect.rest.datapreview.extension.service.ConnectorDataPreviewService;
import io.confluent.connect.rest.datapreview.extension.util.CreateConnectorRequestTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;
import org.apache.kafka.connect.runtime.rest.entities.PluginInfo;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorPluginsResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;
import org.apache.kafka.connect.runtime.tracing.TracerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectorDataPreviewServiceTest {
    private static final String MAX_TASKS = "1";
    private static final int TOPIC_PARTITIONS = 10;
    private static final short TOPIC_REPLICATION_FACTOR = 3;
    private static final String TRACE_TIMEOUT = "60000";
    private static final boolean TRACE_ENABLE = true;
    private static final String TRACE_TOPIC_NAME = "test-trace-1";
    private static final String PREVIEW_ID = "test";
    private static final String CONNECTOR_NAME = "lcc-123";
    private static final Class KEY_CONVERTER = JsonConverter.class;
    private static final Class VALUE_CONVERTER = JsonConverter.class;
    private static final Class HEADER_CONVERTER = JsonConverter.class;
    private static final String CONNECTOR_CLASS_NAME = "io.confluent.kafka.connect.datagen.DatagenConnector";
    private ConnectorDataPreviewService dataPreviewService;
    @Mock
    private ConnectorsResource connectorsResource;
    @Mock
    private ConnectorPluginsResource connectorPluginsResource;
    @Mock
    private TracerConfig tracerConfig;
    @Mock
    private ConnectorConfig connectorConfig;
    @Mock
    private HttpHeaders headers;
    @Mock
    private CreateConnectorRequestTranslator createConnectorRequestTranslator;
    private ConnectorDataPreviewRequest request;
    private CreateConnectorRequest createConnectorRequest;
    private final Map<String, String> workerConfigs = new HashMap<String, String>();
    private final Map<String, String> connectorConfigs = new HashMap<String, String>();

    @Before
    public void setUp() {
        this.dataPreviewService = (ConnectorDataPreviewService)Mockito.spy((Object)new ConnectorDataPreviewService(this.connectorsResource, this.connectorPluginsResource, this.workerConfigs, this.createConnectorRequestTranslator));
        this.mockTraceConfigs();
        this.connectorConfigs.put("trace.records.topic", TRACE_TOPIC_NAME);
        this.connectorConfigs.put("datapreview.id", PREVIEW_ID);
        this.connectorConfigs.put("name", CONNECTOR_NAME);
        this.connectorConfigs.put("connector.class", CONNECTOR_CLASS_NAME);
        this.request = new ConnectorDataPreviewRequest(CONNECTOR_NAME, this.connectorConfigs);
        this.createConnectorRequest = new CreateConnectorRequest(CONNECTOR_NAME, this.connectorConfigs);
        Mockito.when((Object)this.createConnectorRequestTranslator.apply(this.request)).thenReturn((Object)this.createConnectorRequest);
        this.workerConfigs.put("datapreview.max.duration.ms", TRACE_TIMEOUT);
        this.workerConfigs.put("datapreview.tasks.max", MAX_TASKS);
    }

    @Test
    public void testCreateDataPreview() throws Throwable {
        ConnectorInfo dataPreviewConnectorResponse = new ConnectorInfo(CONNECTOR_NAME, this.createConnectorRequest.config(), Collections.emptyList(), ConnectorType.SOURCE);
        ((ConnectorDataPreviewService)Mockito.doNothing().when((Object)this.dataPreviewService)).applyFilterTransforms(this.request);
        ((ConnectorDataPreviewService)Mockito.doReturn((Object)"source").when((Object)this.dataPreviewService)).getConnectorType(CONNECTOR_CLASS_NAME);
        Response mockCreateConnectorResponse = Response.ok((Object)new ConnectorInfo(CONNECTOR_NAME, this.createConnectorRequest.config(), Collections.emptyList(), ConnectorType.SOURCE)).build();
        Mockito.when((Object)this.connectorsResource.putConnectorConfig(this.request.name(), this.headers, null, this.request.config())).thenReturn((Object)mockCreateConnectorResponse);
        Response result = this.dataPreviewService.createDataPreview(this.request, this.headers);
        ((ConnectorsResource)Mockito.verify((Object)this.connectorsResource)).putConnectorConfig(this.request.name(), this.headers, null, this.request.config());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)result.getStatus());
        Assert.assertEquals((Object)dataPreviewConnectorResponse, (Object)result.getEntity());
    }

    @Test
    public void testAugmentWithTraceConfigs() {
        this.mockTraceConfigs();
        this.request = new ConnectorDataPreviewRequest(CONNECTOR_NAME, this.connectorConfigs);
        ((ConnectorDataPreviewService)Mockito.doReturn((Object)"source").when((Object)this.dataPreviewService)).getConnectorType(CONNECTOR_CLASS_NAME);
        this.dataPreviewService.addTraceConfigs(this.request, TRACE_TOPIC_NAME);
        Assert.assertEquals((long)12L, (long)this.request.config().size());
    }

    @Test
    public void testAugmentWithTraceConfigsSchemaDefault() {
        this.mockTraceConfigs();
        this.request = new ConnectorDataPreviewRequest(CONNECTOR_NAME, this.connectorConfigs);
        ((ConnectorDataPreviewService)Mockito.doReturn((Object)"source").when((Object)this.dataPreviewService)).getConnectorType(CONNECTOR_CLASS_NAME);
        this.dataPreviewService.addTraceConfigs(this.request, TRACE_TOPIC_NAME);
        Assert.assertEquals((long)12L, (long)this.request.config().size());
        Assert.assertEquals((Object)"false", this.request.config().get("trace.records.key.converter.schemas.enable"));
        Assert.assertEquals((Object)"false", this.request.config().get("trace.records.value.converter.schemas.enable"));
    }

    @Test
    public void testAugmentWithTraceConfigsSchemaEnable() {
        this.mockTraceConfigs();
        this.connectorConfigs.put("datapreview.schemas.enable", "true");
        this.request = new ConnectorDataPreviewRequest(CONNECTOR_NAME, this.connectorConfigs);
        ((ConnectorDataPreviewService)Mockito.doReturn((Object)"source").when((Object)this.dataPreviewService)).getConnectorType(CONNECTOR_CLASS_NAME);
        this.dataPreviewService.addTraceConfigs(this.request, TRACE_TOPIC_NAME);
        Assert.assertEquals((long)13L, (long)this.request.config().size());
        Assert.assertEquals((Object)"true", this.request.config().get("trace.records.key.converter.schemas.enable"));
        Assert.assertEquals((Object)"true", this.request.config().get("trace.records.value.converter.schemas.enable"));
    }

    @Test
    public void testAugmentWithTraceConfigsSchemaDisabled() {
        this.mockTraceConfigs();
        this.connectorConfigs.put("datapreview.schemas.enable", "false");
        this.request = new ConnectorDataPreviewRequest(CONNECTOR_NAME, this.connectorConfigs);
        ((ConnectorDataPreviewService)Mockito.doReturn((Object)"source").when((Object)this.dataPreviewService)).getConnectorType(CONNECTOR_CLASS_NAME);
        this.dataPreviewService.addTraceConfigs(this.request, TRACE_TOPIC_NAME);
        Assert.assertEquals((long)13L, (long)this.request.config().size());
        Assert.assertEquals((Object)"false", this.request.config().get("trace.records.key.converter.schemas.enable"));
        Assert.assertEquals((Object)"false", this.request.config().get("trace.records.value.converter.schemas.enable"));
    }

    @Test
    public void testGeneratePreviewId() {
        String previewId = this.dataPreviewService.generatePreviewId(this.request);
        Assert.assertEquals((Object)PREVIEW_ID, (Object)previewId);
    }

    @Test
    public void testSuccessApplyFilterTransforms() {
        this.request = new ConnectorDataPreviewRequest(CONNECTOR_NAME, new HashMap());
        this.request.config().putIfAbsent("connector.class", CONNECTOR_CLASS_NAME);
        ((ConnectorDataPreviewService)Mockito.doReturn((Object)"source").when((Object)this.dataPreviewService)).getConnectorType(CONNECTOR_CLASS_NAME);
        this.dataPreviewService.applyFilterTransforms(this.request);
        Assert.assertEquals((long)7L, (long)this.request.config().size());
    }

    @Test
    public void testFailureApplyFilterTransforms() {
        this.request = new ConnectorDataPreviewRequest(CONNECTOR_NAME, new HashMap());
        this.request.config().putIfAbsent("connector.class", CONNECTOR_CLASS_NAME);
        ((ConnectorDataPreviewService)Mockito.doReturn((Object)"sink").when((Object)this.dataPreviewService)).getConnectorType(CONNECTOR_CLASS_NAME);
        this.dataPreviewService.applyFilterTransforms(this.request);
        Assert.assertEquals((long)1L, (long)this.request.config().size());
    }

    @Test(expected=BadRequestException.class)
    public void testValidateMaxTasks() {
        this.request = new ConnectorDataPreviewRequest(CONNECTOR_NAME, new HashMap());
        this.request.config().putIfAbsent("tasks.max", "12");
        this.dataPreviewService.validateTaskLimits(this.request.config());
    }

    @Test
    public void testConnectorClassAlias() {
        String alias = ConnectorDataPreviewService.alias((String)CONNECTOR_CLASS_NAME);
        Assert.assertEquals((Object)"Datagen", (Object)alias);
    }

    @Test
    public void testConnectorType() {
        PluginInfo pluginInfo = new PluginInfo(CONNECTOR_CLASS_NAME, PluginType.SOURCE, "1.0.0");
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>();
        pluginInfos.add(pluginInfo);
        Mockito.when((Object)this.connectorPluginsResource.listConnectorPlugins(true)).thenReturn(pluginInfos);
        Assert.assertEquals((Object)"source", (Object)this.dataPreviewService.getConnectorType(CONNECTOR_CLASS_NAME));
        Assert.assertEquals((Object)"source", (Object)this.dataPreviewService.getConnectorType("Datagen"));
    }

    @Test(expected=ConnectException.class)
    public void testConnectorTypeNotFound() {
        PluginInfo pluginInfo = new PluginInfo(CONNECTOR_CLASS_NAME, PluginType.SOURCE, "1.0.0");
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>();
        pluginInfos.add(pluginInfo);
        Mockito.when((Object)this.connectorPluginsResource.listConnectorPlugins(true)).thenReturn(pluginInfos);
        this.dataPreviewService.getConnectorType("SomeRandomSourceConnector");
    }

    void mockTraceConfigs() {
        Mockito.when((Object)this.tracerConfig.traceTopic()).thenReturn((Object)TRACE_TOPIC_NAME);
        Mockito.when((Object)this.tracerConfig.isTracingEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.tracerConfig.getClass("trace.records.key.converter")).thenReturn((Object)KEY_CONVERTER);
        Mockito.when((Object)this.tracerConfig.getClass("trace.records.value.converter")).thenReturn((Object)VALUE_CONVERTER);
        Mockito.when((Object)this.tracerConfig.getClass("trace.records.header.converter")).thenReturn((Object)HEADER_CONVERTER);
        Mockito.when((Object)this.tracerConfig.connectorConfig()).thenReturn((Object)this.connectorConfig);
        Mockito.when((Object)this.tracerConfig.getInt("trace.records.topic.partition")).thenReturn((Object)10);
        Mockito.when((Object)this.tracerConfig.getShort("trace.records.topic.replication.factor")).thenReturn((Object)3);
        Mockito.when((Object)this.tracerConfig.originalsWithPrefix("trace.records.trace.topic.config.")).thenReturn(null);
        Mockito.when((Object)this.connectorConfig.getString("name")).thenReturn((Object)CONNECTOR_NAME);
    }
}

