/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.rest.datapreview.extension;

import io.confluent.connect.rest.datapreview.extension.ConnectorDataPreviewRestExtension;
import io.confluent.connect.rest.datapreview.extension.resources.ConnectorDataPreviewsResource;
import io.confluent.connect.rest.datapreview.extension.service.ConnectorDataPreviewService;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Configurable;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.apache.kafka.connect.rest.ConnectRestExtensionContext;
import org.apache.kafka.connect.runtime.rest.ConnectRestExtensionContextImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectorDataPreviewRestExtensionTest {
    private ConnectorDataPreviewRestExtension restExtension;
    @Mock
    private Configurable<Configurable> configurable;
    @Mock
    private ConnectClusterState connectClusterState;
    @Mock
    private ConnectorDataPreviewService dataPreviewService;

    @Before
    public void setup() {
        this.restExtension = (ConnectorDataPreviewRestExtension)Mockito.spy((Object)new ConnectorDataPreviewRestExtension());
    }

    @Test
    public void testRegister() {
        ConnectRestExtensionContextImpl restPluginContext = new ConnectRestExtensionContextImpl(this.configurable, this.connectClusterState);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("key1", "val1");
        configs.put("key2", "val2");
        this.restExtension.configure(configs);
        ((ConnectorDataPreviewRestExtension)Mockito.doReturn((Object)this.dataPreviewService).when((Object)this.restExtension)).buildConnectorDataPreviewService((ConnectRestExtensionContext)restPluginContext, configs);
        this.restExtension.register((ConnectRestExtensionContext)restPluginContext);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Object.class);
        ((Configurable)Mockito.verify(this.configurable)).register(argumentCaptor.capture());
        List allValues = argumentCaptor.getAllValues();
        Assert.assertTrue((boolean)(allValues.get(0) instanceof ConnectorDataPreviewsResource));
    }

    @Test
    public void testNoExceptionWhenFailedToRegister() {
        ConnectRestExtensionContextImpl restPluginContext = new ConnectRestExtensionContextImpl(this.configurable, this.connectClusterState);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("key1", "val1");
        configs.put("key2", "val2");
        this.restExtension.configure(configs);
        ((ConnectorDataPreviewRestExtension)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Failed to register the rest extension")}).when((Object)this.restExtension)).buildConnectorDataPreviewService((ConnectRestExtensionContext)restPluginContext, configs);
        this.restExtension.register((ConnectRestExtensionContext)restPluginContext);
    }

    @Test
    public void testVersion() {
        Assert.assertNotNull((Object)this.restExtension.version());
    }
}

