/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms.predicates;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.predicates.HasHeaderKey;
import org.apache.kafka.connect.transforms.util.SimpleConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HasHeaderKeyTest {
    @Test
    public void testNameRequiredInConfig() {
        HashMap props = new HashMap();
        ConfigException e = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.config(props));
        Assertions.assertTrue((boolean)e.getMessage().contains("Missing required configuration \"name\""));
    }

    @Test
    public void testNameMayNotBeEmptyInConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "");
        ConfigException e = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.config(props));
        Assertions.assertTrue((boolean)e.getMessage().contains("String must be non-empty"));
    }

    @Test
    public void testConfig() {
        HasHeaderKey predicate = new HasHeaderKey();
        predicate.config().validate(Collections.singletonMap("name", "foo"));
        List configs = predicate.config().validate(Collections.singletonMap("name", ""));
        Assertions.assertEquals(Collections.singletonList("Invalid value  for configuration name: String must be non-empty"), (Object)((ConfigValue)configs.get(0)).errorMessages());
    }

    @Test
    public void testTest() {
        HasHeaderKey predicate = new HasHeaderKey();
        predicate.configure(Collections.singletonMap("name", "foo"));
        Assertions.assertTrue((boolean)predicate.test((ConnectRecord)this.recordWithHeaders("foo")));
        Assertions.assertTrue((boolean)predicate.test((ConnectRecord)this.recordWithHeaders("foo", "bar")));
        Assertions.assertTrue((boolean)predicate.test((ConnectRecord)this.recordWithHeaders("bar", "foo", "bar", "foo")));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)this.recordWithHeaders("bar")));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)this.recordWithHeaders("bar", "bar")));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)this.recordWithHeaders(new String[0])));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)new SourceRecord(null, null, null, null, null)));
    }

    private SimpleConfig config(Map<String, String> props) {
        return new SimpleConfig(new HasHeaderKey().config(), props);
    }

    private SourceRecord recordWithHeaders(String ... headers) {
        return new SourceRecord(null, null, null, null, null, null, null, null, null, (Iterable)Arrays.stream(headers).map(TestHeader::new).collect(Collectors.toList()));
    }

    private static class TestHeader
    implements Header {
        private final String key;

        public TestHeader(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public Schema schema() {
            return null;
        }

        public Object value() {
            return null;
        }

        public Header with(Schema schema, Object value) {
            return null;
        }

        public Header rename(String key) {
            return null;
        }
    }
}

