/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.HeaderFrom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class HeaderFromTest {
    public static List<Arguments> data() {
        ArrayList<Arguments> result = new ArrayList<Arguments>();
        for (Boolean testKeyTransform : Arrays.asList(true, false)) {
            result.add(Arguments.of((Object[])new Object[]{"basic copy", testKeyTransform, new RecordBuilder().withField("field1", Schema.STRING_SCHEMA, "field1-value").withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value"), Collections.singletonList("field1"), Collections.singletonList("inserted1"), HeaderFrom.Operation.COPY, new RecordBuilder().withField("field1", Schema.STRING_SCHEMA, "field1-value").withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value").addHeader("inserted1", Schema.STRING_SCHEMA, "field1-value")}));
            result.add(Arguments.of((Object[])new Object[]{"basic move", testKeyTransform, new RecordBuilder().withField("field1", Schema.STRING_SCHEMA, "field1-value").withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value"), Collections.singletonList("field1"), Collections.singletonList("inserted1"), HeaderFrom.Operation.MOVE, new RecordBuilder().withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value").addHeader("inserted1", Schema.STRING_SCHEMA, "field1-value")}));
            result.add(Arguments.of((Object[])new Object[]{"copy with preexisting header", testKeyTransform, new RecordBuilder().withField("field1", Schema.STRING_SCHEMA, "field1-value").withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("inserted1", Schema.STRING_SCHEMA, "existing-value"), Collections.singletonList("field1"), Collections.singletonList("inserted1"), HeaderFrom.Operation.COPY, new RecordBuilder().withField("field1", Schema.STRING_SCHEMA, "field1-value").withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("inserted1", Schema.STRING_SCHEMA, "existing-value").addHeader("inserted1", Schema.STRING_SCHEMA, "field1-value")}));
            result.add(Arguments.of((Object[])new Object[]{"move with preexisting header", testKeyTransform, new RecordBuilder().withField("field1", Schema.STRING_SCHEMA, "field1-value").withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("inserted1", Schema.STRING_SCHEMA, "existing-value"), Collections.singletonList("field1"), Collections.singletonList("inserted1"), HeaderFrom.Operation.MOVE, new RecordBuilder().withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("inserted1", Schema.STRING_SCHEMA, "existing-value").addHeader("inserted1", Schema.STRING_SCHEMA, "field1-value")}));
            Schema schema = new SchemaBuilder(Schema.Type.STRUCT).field("foo", Schema.STRING_SCHEMA).build();
            Struct struct = new Struct(schema).put("foo", (Object)"foo-value");
            result.add(Arguments.of((Object[])new Object[]{"copy with struct value", testKeyTransform, new RecordBuilder().withField("field1", schema, struct).withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value"), Collections.singletonList("field1"), Collections.singletonList("inserted1"), HeaderFrom.Operation.COPY, new RecordBuilder().withField("field1", schema, struct).withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value").addHeader("inserted1", schema, struct)}));
            result.add(Arguments.of((Object[])new Object[]{"move with struct value", testKeyTransform, new RecordBuilder().withField("field1", schema, struct).withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value"), Collections.singletonList("field1"), Collections.singletonList("inserted1"), HeaderFrom.Operation.MOVE, new RecordBuilder().withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value").addHeader("inserted1", schema, struct)}));
            result.add(Arguments.of((Object[])new Object[]{"two headers from same field", testKeyTransform, new RecordBuilder().withField("field1", Schema.STRING_SCHEMA, "field1-value").withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value"), Arrays.asList("field1", "field1"), Arrays.asList("inserted1", "inserted2"), HeaderFrom.Operation.MOVE, new RecordBuilder().withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value").addHeader("inserted1", Schema.STRING_SCHEMA, "field1-value").addHeader("inserted2", Schema.STRING_SCHEMA, "field1-value")}));
            result.add(Arguments.of((Object[])new Object[]{"two fields to same header", testKeyTransform, new RecordBuilder().withField("field1", Schema.STRING_SCHEMA, "field1-value").withField("field2", Schema.STRING_SCHEMA, "field2-value").addHeader("header1", Schema.STRING_SCHEMA, "existing-value"), Arrays.asList("field1", "field2"), Arrays.asList("inserted1", "inserted1"), HeaderFrom.Operation.MOVE, new RecordBuilder().addHeader("header1", Schema.STRING_SCHEMA, "existing-value").addHeader("inserted1", Schema.STRING_SCHEMA, "field1-value").addHeader("inserted1", Schema.STRING_SCHEMA, "field2-value")}));
        }
        return result;
    }

    private Map<String, Object> config(List<String> headers, List<String> transformFields, HeaderFrom.Operation operation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("headers", headers);
        result.put("fields", transformFields);
        result.put("operation", operation.toString());
        return result;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void schemaless(String description, boolean keyTransform, RecordBuilder originalBuilder, List<String> transformFields, List<String> headers1, HeaderFrom.Operation operation, RecordBuilder expectedBuilder) {
        HeaderFrom.Key xform = keyTransform ? new HeaderFrom.Key() : new HeaderFrom.Value();
        xform.configure(this.config(headers1, transformFields, operation));
        ConnectHeaders headers = new ConnectHeaders();
        headers.addString("existing", "existing-value");
        SourceRecord originalRecord = originalBuilder.schemaless(keyTransform);
        SourceRecord expectedRecord = expectedBuilder.schemaless(keyTransform);
        SourceRecord xformed = (SourceRecord)xform.apply((ConnectRecord)originalRecord);
        HeaderFromTest.assertSameRecord(expectedRecord, xformed);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void withSchema(String description, boolean keyTransform, RecordBuilder originalBuilder, List<String> transformFields, List<String> headers1, HeaderFrom.Operation operation, RecordBuilder expectedBuilder) {
        HeaderFrom.Key xform = keyTransform ? new HeaderFrom.Key() : new HeaderFrom.Value();
        xform.configure(this.config(headers1, transformFields, operation));
        ConnectHeaders headers = new ConnectHeaders();
        headers.addString("existing", "existing-value");
        ConnectHeaders expect = headers.duplicate();
        for (int i = 0; i < headers1.size(); ++i) {
            expect.add(headers1.get(i), originalBuilder.fieldValues.get(i), (Schema)originalBuilder.fieldSchemas.get(i));
        }
        SourceRecord originalRecord = originalBuilder.withSchema(keyTransform);
        SourceRecord expectedRecord = expectedBuilder.withSchema(keyTransform);
        SourceRecord xformed = (SourceRecord)xform.apply((ConnectRecord)originalRecord);
        HeaderFromTest.assertSameRecord(expectedRecord, xformed);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void invalidConfigExtraHeaderConfig(boolean keyTransform) {
        Map<String, Object> config = this.config(Collections.singletonList("foo"), Arrays.asList("foo", "bar"), HeaderFrom.Operation.COPY);
        HeaderFrom.Key xform = keyTransform ? new HeaderFrom.Key() : new HeaderFrom.Value();
        Assertions.assertThrows(ConfigException.class, () -> HeaderFromTest.lambda$invalidConfigExtraHeaderConfig$0((HeaderFrom)xform, config));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void invalidConfigExtraFieldConfig(boolean keyTransform) {
        Map<String, Object> config = this.config(Arrays.asList("foo", "bar"), Collections.singletonList("foo"), HeaderFrom.Operation.COPY);
        HeaderFrom.Key xform = keyTransform ? new HeaderFrom.Key() : new HeaderFrom.Value();
        Assertions.assertThrows(ConfigException.class, () -> HeaderFromTest.lambda$invalidConfigExtraFieldConfig$1((HeaderFrom)xform, config));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void invalidConfigEmptyHeadersAndFieldsConfig(boolean keyTransform) {
        Map<String, Object> config = this.config(Collections.emptyList(), Collections.emptyList(), HeaderFrom.Operation.COPY);
        HeaderFrom.Key xform = keyTransform ? new HeaderFrom.Key() : new HeaderFrom.Value();
        Assertions.assertThrows(ConfigException.class, () -> HeaderFromTest.lambda$invalidConfigEmptyHeadersAndFieldsConfig$2((HeaderFrom)xform, config));
    }

    private static void assertSameRecord(SourceRecord expected, SourceRecord xformed) {
        Assertions.assertEquals((Object)expected.sourcePartition(), (Object)xformed.sourcePartition());
        Assertions.assertEquals((Object)expected.sourceOffset(), (Object)xformed.sourceOffset());
        Assertions.assertEquals((Object)expected.topic(), (Object)xformed.topic());
        Assertions.assertEquals((Integer)expected.kafkaPartition(), (Integer)xformed.kafkaPartition());
        Assertions.assertEquals((Object)expected.keySchema(), (Object)xformed.keySchema());
        Assertions.assertEquals((Object)expected.key(), (Object)xformed.key());
        Assertions.assertEquals((Object)expected.valueSchema(), (Object)xformed.valueSchema());
        Assertions.assertEquals((Object)expected.value(), (Object)xformed.value());
        Assertions.assertEquals((Long)expected.timestamp(), (Long)xformed.timestamp());
        Assertions.assertEquals((Object)expected.headers(), (Object)xformed.headers());
    }

    private static /* synthetic */ void lambda$invalidConfigEmptyHeadersAndFieldsConfig$2(HeaderFrom xform, Map config) throws Throwable {
        xform.configure(config);
    }

    private static /* synthetic */ void lambda$invalidConfigExtraFieldConfig$1(HeaderFrom xform, Map config) throws Throwable {
        xform.configure(config);
    }

    private static /* synthetic */ void lambda$invalidConfigExtraHeaderConfig$0(HeaderFrom xform, Map config) throws Throwable {
        xform.configure(config);
    }

    static class RecordBuilder {
        private final List<String> fields = new ArrayList<String>(2);
        private final List<Schema> fieldSchemas = new ArrayList<Schema>(2);
        private final List<Object> fieldValues = new ArrayList<Object>(2);
        private final ConnectHeaders headers = new ConnectHeaders();

        public RecordBuilder withField(String name, Schema schema, Object value) {
            this.fields.add(name);
            this.fieldSchemas.add(schema);
            this.fieldValues.add(value);
            return this;
        }

        public RecordBuilder addHeader(String name, Schema schema, Object value) {
            this.headers.add(name, new SchemaAndValue(schema, value));
            return this;
        }

        public SourceRecord schemaless(boolean keyTransform) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < this.fields.size(); ++i) {
                String fieldName = this.fields.get(i);
                map.put(fieldName, this.fieldValues.get(i));
            }
            return this.sourceRecord(keyTransform, null, map);
        }

        private Schema schema() {
            SchemaBuilder schemaBuilder = new SchemaBuilder(Schema.Type.STRUCT);
            for (int i = 0; i < this.fields.size(); ++i) {
                String fieldName = this.fields.get(i);
                schemaBuilder.field(fieldName, this.fieldSchemas.get(i));
            }
            return schemaBuilder.build();
        }

        private Struct struct(Schema schema) {
            Struct struct = new Struct(schema);
            for (int i = 0; i < this.fields.size(); ++i) {
                String fieldName = this.fields.get(i);
                struct.put(fieldName, this.fieldValues.get(i));
            }
            return struct;
        }

        public SourceRecord withSchema(boolean keyTransform) {
            Schema schema = this.schema();
            Struct struct = this.struct(schema);
            return this.sourceRecord(keyTransform, schema, struct);
        }

        private SourceRecord sourceRecord(boolean keyTransform, Schema keyOrValueSchema, Object keyOrValue) {
            Map<String, String> sourcePartition = Collections.singletonMap("foo", "bar");
            Map<String, String> sourceOffset = Collections.singletonMap("baz", "quxx");
            String topic = "topic";
            Integer partition = 0;
            Long timestamp = 0L;
            ConnectHeaders headers = this.headers;
            if (keyOrValueSchema == null) {
                headers = new ConnectHeaders();
                for (Header header : this.headers) {
                    headers.add(header.key(), new SchemaAndValue(null, header.value()));
                }
            }
            return new SourceRecord(sourcePartition, sourceOffset, topic, partition, (Schema)(keyTransform ? keyOrValueSchema : null), keyTransform ? keyOrValue : "key", (Schema)(!keyTransform ? keyOrValueSchema : null), !keyTransform ? keyOrValue : "value", timestamp, (Iterable)headers);
        }

        public String toString() {
            return "RecordBuilder(fields=" + this.fields + ", fieldSchemas=" + this.fieldSchemas + ", fieldValues=" + this.fieldValues + ", headers=" + this.headers + ')';
        }
    }
}

