/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.HoistField;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HoistFieldTest {
    private final HoistField<SinkRecord> xform = new HoistField.Key();

    @AfterEach
    public void teardown() {
        this.xform.close();
    }

    @Test
    public void schemaless() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        SinkRecord record = new SinkRecord("test", 0, null, (Object)42, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertNull((Object)transformedRecord.keySchema());
        Assertions.assertEquals(Collections.singletonMap("magic", 42), (Object)transformedRecord.key());
    }

    @Test
    public void withSchema() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        SinkRecord record = new SinkRecord("test", 0, Schema.INT32_SCHEMA, (Object)42, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)transformedRecord.keySchema().type());
        Assertions.assertEquals((Object)record.keySchema(), (Object)transformedRecord.keySchema().field("magic").schema());
        Assertions.assertEquals((Object)42, (Object)((Struct)transformedRecord.key()).get("magic"));
    }

    @Test
    public void testSchemalessMapIsMutable() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        SinkRecord record = new SinkRecord("test", 0, null, (Object)420, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertNull((Object)transformedRecord.keySchema());
        Map actualKey = (Map)transformedRecord.key();
        actualKey.put("k", "v");
        HashMap<String, Object> expectedKey = new HashMap<String, Object>();
        expectedKey.put("k", "v");
        expectedKey.put("magic", 420);
        Assertions.assertEquals(expectedKey, (Object)actualKey);
    }
}

