/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.Cast;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CastTest {
    private final Cast<SourceRecord> xformKey = new Cast.Key();
    private final Cast<SourceRecord> xformValue = new Cast.Value();
    private static final long MILLIS_PER_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final long MILLIS_PER_DAY = TimeUnit.DAYS.toMillis(1L);

    @AfterEach
    public void teardown() {
        this.xformKey.close();
        this.xformValue.close();
    }

    @Test
    public void testConfigEmpty() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformKey.configure(Collections.singletonMap("spec", "")));
    }

    @Test
    public void testConfigInvalidSchemaType() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformKey.configure(Collections.singletonMap("spec", "foo:faketype")));
    }

    @Test
    public void testConfigInvalidTargetType() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformKey.configure(Collections.singletonMap("spec", "foo:array")));
    }

    @Test
    public void testUnsupportedTargetType() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformKey.configure(Collections.singletonMap("spec", "foo:bytes")));
    }

    @Test
    public void testConfigInvalidMap() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformKey.configure(Collections.singletonMap("spec", "foo:int8:extra")));
    }

    @Test
    public void testConfigMixWholeAndFieldTransformation() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformKey.configure(Collections.singletonMap("spec", "foo:int8,int32")));
    }

    @Test
    public void castNullValueRecordWithSchema() {
        this.xformValue.configure(Collections.singletonMap("spec", "foo:int64"));
        SourceRecord original = new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.STRING_SCHEMA, (Object)"key", Schema.STRING_SCHEMA, null);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)original);
        Assertions.assertEquals((Object)original, (Object)transformed);
    }

    @Test
    public void castNullValueRecordSchemaless() {
        this.xformValue.configure(Collections.singletonMap("spec", "foo:int64"));
        SourceRecord original = new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.STRING_SCHEMA, (Object)"key", null, null);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)original);
        Assertions.assertEquals((Object)original, (Object)transformed);
    }

    @Test
    public void castNullKeyRecordWithSchema() {
        this.xformKey.configure(Collections.singletonMap("spec", "foo:int64"));
        SourceRecord original = new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.STRING_SCHEMA, null, Schema.STRING_SCHEMA, (Object)"value");
        SourceRecord transformed = (SourceRecord)this.xformKey.apply((ConnectRecord)original);
        Assertions.assertEquals((Object)original, (Object)transformed);
    }

    @Test
    public void castNullKeyRecordSchemaless() {
        this.xformKey.configure(Collections.singletonMap("spec", "foo:int64"));
        SourceRecord original = new SourceRecord(null, null, "topic", Integer.valueOf(0), null, null, Schema.STRING_SCHEMA, (Object)"value");
        SourceRecord transformed = (SourceRecord)this.xformKey.apply((ConnectRecord)original);
        Assertions.assertEquals((Object)original, (Object)transformed);
    }

    @Test
    public void castWholeRecordKeyWithSchema() {
        this.xformKey.configure(Collections.singletonMap("spec", "int8"));
        SourceRecord transformed = (SourceRecord)this.xformKey.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42, Schema.STRING_SCHEMA, (Object)"bogus"));
        Assertions.assertEquals((Object)Schema.Type.INT8, (Object)transformed.keySchema().type());
        Assertions.assertEquals((Object)42, (Object)transformed.key());
    }

    @Test
    public void castWholeRecordValueWithSchemaInt8() {
        this.xformValue.configure(Collections.singletonMap("spec", "int8"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assertions.assertEquals((Object)Schema.Type.INT8, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaInt16() {
        this.xformValue.configure(Collections.singletonMap("spec", "int16"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assertions.assertEquals((Object)Schema.Type.INT16, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaInt32() {
        this.xformValue.configure(Collections.singletonMap("spec", "int32"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaInt64() {
        this.xformValue.configure(Collections.singletonMap("spec", "int64"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assertions.assertEquals((Object)Schema.Type.INT64, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)42L, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaFloat32() {
        this.xformValue.configure(Collections.singletonMap("spec", "float32"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assertions.assertEquals((Object)Schema.Type.FLOAT32, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)Float.valueOf(42.0f), (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaFloat64() {
        this.xformValue.configure(Collections.singletonMap("spec", "float64"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assertions.assertEquals((Object)Schema.Type.FLOAT64, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)42.0, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaBooleanTrue() {
        this.xformValue.configure(Collections.singletonMap("spec", "boolean"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assertions.assertEquals((Object)Schema.Type.BOOLEAN, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)true, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaBooleanFalse() {
        this.xformValue.configure(Collections.singletonMap("spec", "boolean"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)0));
        Assertions.assertEquals((Object)Schema.Type.BOOLEAN, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)false, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaString() {
        this.xformValue.configure(Collections.singletonMap("spec", "string"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)"42", (Object)transformed.value());
    }

    @Test
    public void castWholeBigDecimalRecordValueWithSchemaString() {
        BigDecimal bigDecimal = new BigDecimal(42);
        this.xformValue.configure(Collections.singletonMap("spec", "string"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Decimal.schema((int)bigDecimal.scale()), (Object)bigDecimal));
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)"42", (Object)transformed.value());
    }

    @Test
    public void castWholeDateRecordValueWithSchemaString() {
        Date timestamp = new Date(MILLIS_PER_DAY + 1L);
        this.xformValue.configure(Collections.singletonMap("spec", "string"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Timestamp.SCHEMA, (Object)timestamp));
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)Values.dateFormatFor((Date)timestamp).format(timestamp), (Object)transformed.value());
    }

    @Test
    public void castWholeRecordDefaultValue() {
        this.xformValue.configure(Collections.singletonMap("spec", "int32"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), SchemaBuilder.float32().defaultValue((Object)Float.valueOf(-42.125f)).build(), (Object)Float.valueOf(42.125f)));
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)transformed.valueSchema().type());
        Assertions.assertEquals((Object)42, (Object)transformed.value());
        Assertions.assertEquals((Object)-42, (Object)transformed.valueSchema().defaultValue());
    }

    @Test
    public void castWholeRecordKeySchemaless() {
        this.xformKey.configure(Collections.singletonMap("spec", "int8"));
        SourceRecord transformed = (SourceRecord)this.xformKey.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42, Schema.STRING_SCHEMA, (Object)"bogus"));
        Assertions.assertNull((Object)transformed.keySchema());
        Assertions.assertEquals((Object)42, (Object)transformed.key());
    }

    @Test
    public void castWholeRecordValueSchemalessInt8() {
        this.xformValue.configure(Collections.singletonMap("spec", "int8"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessInt16() {
        this.xformValue.configure(Collections.singletonMap("spec", "int16"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessInt32() {
        this.xformValue.configure(Collections.singletonMap("spec", "int32"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessInt64() {
        this.xformValue.configure(Collections.singletonMap("spec", "int64"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)42L, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessFloat32() {
        this.xformValue.configure(Collections.singletonMap("spec", "float32"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)Float.valueOf(42.0f), (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessFloat64() {
        this.xformValue.configure(Collections.singletonMap("spec", "float64"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)42.0, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessBooleanTrue() {
        this.xformValue.configure(Collections.singletonMap("spec", "boolean"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)true, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessBooleanFalse() {
        this.xformValue.configure(Collections.singletonMap("spec", "boolean"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)0));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)false, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessString() {
        this.xformValue.configure(Collections.singletonMap("spec", "string"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)"42", (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessUnsupportedType() {
        this.xformValue.configure(Collections.singletonMap("spec", "int8"));
        Assertions.assertThrows(DataException.class, () -> {
            SourceRecord cfr_ignored_0 = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, Collections.singletonList("foo")));
        });
    }

    @Test
    public void castLogicalToPrimitive() {
        List<String> specParts = Arrays.asList("date_to_int32:int32", "timestamp_to_int64:int64", "time_to_int64:int64", "decimal_to_int32:int32", "timestamp_to_float64:float64", "null_timestamp_to_int32:int32");
        Date day = new Date(MILLIS_PER_DAY);
        this.xformValue.configure(Collections.singletonMap("spec", String.join((CharSequence)",", specParts)));
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.field("date_to_int32", org.apache.kafka.connect.data.Date.SCHEMA);
        builder.field("timestamp_to_int64", Timestamp.SCHEMA);
        builder.field("time_to_int64", Time.SCHEMA);
        builder.field("decimal_to_int32", Decimal.schema((int)new BigDecimal(0x80000000L).scale()));
        builder.field("timestamp_to_float64", Timestamp.SCHEMA);
        builder.field("null_timestamp_to_int32", Timestamp.builder().optional().build());
        Schema supportedTypesSchema = builder.build();
        Struct recordValue = new Struct(supportedTypesSchema);
        recordValue.put("date_to_int32", (Object)day);
        recordValue.put("timestamp_to_int64", (Object)new Date(0L));
        recordValue.put("time_to_int64", (Object)new Date(1L));
        recordValue.put("decimal_to_int32", (Object)new BigDecimal(0x80000000L));
        recordValue.put("timestamp_to_float64", (Object)new Date(Long.MAX_VALUE));
        recordValue.put("null_timestamp_to_int32", null);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), supportedTypesSchema, (Object)recordValue));
        Assertions.assertEquals((Object)1, (Object)((Struct)transformed.value()).get("date_to_int32"));
        Assertions.assertEquals((Object)0L, (Object)((Struct)transformed.value()).get("timestamp_to_int64"));
        Assertions.assertEquals((Object)1L, (Object)((Struct)transformed.value()).get("time_to_int64"));
        Assertions.assertEquals((Object)Integer.MIN_VALUE, (Object)((Struct)transformed.value()).get("decimal_to_int32"));
        Assertions.assertEquals((Object)9.223372036854776E18, (Object)((Struct)transformed.value()).get("timestamp_to_float64"));
        Assertions.assertNull((Object)((Struct)transformed.value()).get("null_timestamp_to_int32"));
        Schema transformedSchema = ((Struct)transformed.value()).schema();
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)transformedSchema.field("date_to_int32").schema().type());
        Assertions.assertEquals((Object)Schema.Type.INT64, (Object)transformedSchema.field("timestamp_to_int64").schema().type());
        Assertions.assertEquals((Object)Schema.Type.INT64, (Object)transformedSchema.field("time_to_int64").schema().type());
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)transformedSchema.field("decimal_to_int32").schema().type());
        Assertions.assertEquals((Object)Schema.Type.FLOAT64, (Object)transformedSchema.field("timestamp_to_float64").schema().type());
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)transformedSchema.field("null_timestamp_to_int32").schema().type());
    }

    @Test
    public void castLogicalToString() {
        Date date = new Date(MILLIS_PER_DAY);
        Date time = new Date(MILLIS_PER_HOUR);
        Date timestamp = new Date();
        this.xformValue.configure(Collections.singletonMap("spec", "date:string,decimal:string,time:string,timestamp:string"));
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.field("date", org.apache.kafka.connect.data.Date.SCHEMA);
        builder.field("decimal", Decimal.schema((int)new BigDecimal(1982).scale()));
        builder.field("time", Time.SCHEMA);
        builder.field("timestamp", Timestamp.SCHEMA);
        Schema supportedTypesSchema = builder.build();
        Struct recordValue = new Struct(supportedTypesSchema);
        recordValue.put("date", (Object)date);
        recordValue.put("decimal", (Object)new BigDecimal(1982));
        recordValue.put("time", (Object)time);
        recordValue.put("timestamp", (Object)timestamp);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), supportedTypesSchema, (Object)recordValue));
        Assertions.assertEquals((Object)Values.dateFormatFor((Date)date).format(date), (Object)((Struct)transformed.value()).get("date"));
        Assertions.assertEquals((Object)"1982", (Object)((Struct)transformed.value()).get("decimal"));
        Assertions.assertEquals((Object)Values.dateFormatFor((Date)time).format(time), (Object)((Struct)transformed.value()).get("time"));
        Assertions.assertEquals((Object)Values.dateFormatFor((Date)timestamp).format(timestamp), (Object)((Struct)transformed.value()).get("timestamp"));
        Schema transformedSchema = ((Struct)transformed.value()).schema();
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)transformedSchema.field("date").schema().type());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)transformedSchema.field("decimal").schema().type());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)transformedSchema.field("time").schema().type());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)transformedSchema.field("timestamp").schema().type());
    }

    @Test
    public void castFieldsWithSchema() {
        Date day = new Date(MILLIS_PER_DAY);
        byte[] byteArray = new byte[]{-2, -36, -70, -104, 118, 84, 50, 16};
        ByteBuffer byteBuffer = ByteBuffer.wrap(Arrays.copyOf(byteArray, byteArray.length));
        this.xformValue.configure(Collections.singletonMap("spec", "int8:int16,int16:int32,int32:int64,int64:boolean,float32:float64,float64:boolean,boolean:int8,string:int32,bigdecimal:string,date:string,optional:int32,bytes:string,byteArray:string"));
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.field("int8", Schema.INT8_SCHEMA);
        builder.field("int16", Schema.OPTIONAL_INT16_SCHEMA);
        builder.field("int32", SchemaBuilder.int32().defaultValue((Object)2).build());
        builder.field("int64", Schema.INT64_SCHEMA);
        builder.field("float32", Schema.FLOAT32_SCHEMA);
        builder.field("float64", SchemaBuilder.float64().defaultValue((Object)-1.125).build());
        builder.field("boolean", Schema.BOOLEAN_SCHEMA);
        builder.field("string", Schema.STRING_SCHEMA);
        builder.field("bigdecimal", Decimal.schema((int)new BigDecimal(42).scale()));
        builder.field("date", org.apache.kafka.connect.data.Date.SCHEMA);
        builder.field("optional", Schema.OPTIONAL_FLOAT32_SCHEMA);
        builder.field("timestamp", Timestamp.SCHEMA);
        builder.field("bytes", Schema.BYTES_SCHEMA);
        builder.field("byteArray", Schema.BYTES_SCHEMA);
        Schema supportedTypesSchema = builder.build();
        Struct recordValue = new Struct(supportedTypesSchema);
        recordValue.put("int8", (Object)8);
        recordValue.put("int16", (Object)16);
        recordValue.put("int32", (Object)32);
        recordValue.put("int64", (Object)64L);
        recordValue.put("float32", (Object)Float.valueOf(32.0f));
        recordValue.put("float64", (Object)-64.0);
        recordValue.put("boolean", (Object)true);
        recordValue.put("bigdecimal", (Object)new BigDecimal(42));
        recordValue.put("date", (Object)day);
        recordValue.put("string", (Object)"42");
        recordValue.put("timestamp", (Object)new Date(0L));
        recordValue.put("bytes", (Object)byteBuffer);
        recordValue.put("byteArray", (Object)byteArray);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), supportedTypesSchema, (Object)recordValue));
        Assertions.assertEquals((Object)8, (Object)((Struct)transformed.value()).get("int8"));
        Assertions.assertTrue((boolean)((Struct)transformed.value()).schema().field("int16").schema().isOptional());
        Assertions.assertEquals((Object)16, (Object)((Struct)transformed.value()).get("int16"));
        Assertions.assertEquals((Object)32L, (Object)((Struct)transformed.value()).get("int32"));
        Assertions.assertEquals((Object)2L, (Object)((Struct)transformed.value()).schema().field("int32").schema().defaultValue());
        Assertions.assertEquals((Object)true, (Object)((Struct)transformed.value()).get("int64"));
        Assertions.assertEquals((Object)32.0, (Object)((Struct)transformed.value()).get("float32"));
        Assertions.assertEquals((Object)true, (Object)((Struct)transformed.value()).get("float64"));
        Assertions.assertEquals((Object)true, (Object)((Struct)transformed.value()).schema().field("float64").schema().defaultValue());
        Assertions.assertEquals((Object)1, (Object)((Struct)transformed.value()).get("boolean"));
        Assertions.assertEquals((Object)42, (Object)((Struct)transformed.value()).get("string"));
        Assertions.assertEquals((Object)"42", (Object)((Struct)transformed.value()).get("bigdecimal"));
        Assertions.assertEquals((Object)Values.dateFormatFor((Date)day).format(day), (Object)((Struct)transformed.value()).get("date"));
        Assertions.assertEquals((Object)new Date(0L), (Object)((Struct)transformed.value()).get("timestamp"));
        Assertions.assertEquals((Object)"/ty6mHZUMhA=", (Object)((Struct)transformed.value()).get("bytes"));
        Assertions.assertEquals((Object)"/ty6mHZUMhA=", (Object)((Struct)transformed.value()).get("byteArray"));
        Assertions.assertNull((Object)((Struct)transformed.value()).get("optional"));
        Schema transformedSchema = ((Struct)transformed.value()).schema();
        Assertions.assertEquals((Object)Schema.INT16_SCHEMA.type(), (Object)transformedSchema.field("int8").schema().type());
        Assertions.assertEquals((Object)Schema.OPTIONAL_INT32_SCHEMA.type(), (Object)transformedSchema.field("int16").schema().type());
        Assertions.assertEquals((Object)Schema.INT64_SCHEMA.type(), (Object)transformedSchema.field("int32").schema().type());
        Assertions.assertEquals((Object)Schema.BOOLEAN_SCHEMA.type(), (Object)transformedSchema.field("int64").schema().type());
        Assertions.assertEquals((Object)Schema.FLOAT64_SCHEMA.type(), (Object)transformedSchema.field("float32").schema().type());
        Assertions.assertEquals((Object)Schema.BOOLEAN_SCHEMA.type(), (Object)transformedSchema.field("float64").schema().type());
        Assertions.assertEquals((Object)Schema.INT8_SCHEMA.type(), (Object)transformedSchema.field("boolean").schema().type());
        Assertions.assertEquals((Object)Schema.INT32_SCHEMA.type(), (Object)transformedSchema.field("string").schema().type());
        Assertions.assertEquals((Object)Schema.STRING_SCHEMA.type(), (Object)transformedSchema.field("bigdecimal").schema().type());
        Assertions.assertEquals((Object)Schema.STRING_SCHEMA.type(), (Object)transformedSchema.field("date").schema().type());
        Assertions.assertEquals((Object)Schema.OPTIONAL_INT32_SCHEMA.type(), (Object)transformedSchema.field("optional").schema().type());
        Assertions.assertEquals((Object)Schema.STRING_SCHEMA.type(), (Object)transformedSchema.field("bytes").schema().type());
        Assertions.assertEquals((Object)Schema.STRING_SCHEMA.type(), (Object)transformedSchema.field("byteArray").schema().type());
        Assertions.assertEquals((Object)Timestamp.SCHEMA.type(), (Object)transformedSchema.field("timestamp").schema().type());
    }

    @Test
    public void castFieldsSchemaless() {
        this.xformValue.configure(Collections.singletonMap("spec", "int8:int16,int16:int32,int32:int64,int64:boolean,float32:float64,float64:boolean,boolean:int8,string:int32"));
        HashMap<String, Object> recordValue = new HashMap<String, Object>();
        recordValue.put("int8", (byte)8);
        recordValue.put("int16", (short)16);
        recordValue.put("int32", 32);
        recordValue.put("int64", 64L);
        recordValue.put("float32", Float.valueOf(32.0f));
        recordValue.put("float64", -64.0);
        recordValue.put("boolean", true);
        recordValue.put("string", "42");
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, recordValue));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)8, ((Map)transformed.value()).get("int8"));
        Assertions.assertEquals((Object)16, ((Map)transformed.value()).get("int16"));
        Assertions.assertEquals((Object)32L, ((Map)transformed.value()).get("int32"));
        Assertions.assertEquals((Object)true, ((Map)transformed.value()).get("int64"));
        Assertions.assertEquals((Object)32.0, ((Map)transformed.value()).get("float32"));
        Assertions.assertEquals((Object)true, ((Map)transformed.value()).get("float64"));
        Assertions.assertEquals((Object)1, ((Map)transformed.value()).get("boolean"));
        Assertions.assertEquals((Object)42, ((Map)transformed.value()).get("string"));
    }
}

