/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.TimestampConverter;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimestampConverterTest {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Calendar EPOCH = GregorianCalendar.getInstance(UTC);
    private static final Calendar TIME;
    private static final Calendar DATE;
    private static final Calendar DATE_PLUS_TIME;
    private static final long DATE_PLUS_TIME_UNIX;
    private static final long DATE_PLUS_TIME_UNIX_MICROS;
    private static final long DATE_PLUS_TIME_UNIX_NANOS;
    private static final long DATE_PLUS_TIME_UNIX_SECONDS;
    private static final String STRING_DATE_FMT = "yyyy MM dd HH mm ss SSS z";
    private static final String DATE_PLUS_TIME_STRING;
    private final TimestampConverter<SourceRecord> xformKey = new TimestampConverter.Key();
    private final TimestampConverter<SourceRecord> xformValue = new TimestampConverter.Value();

    @AfterEach
    public void teardown() {
        this.xformKey.close();
        this.xformValue.close();
    }

    @Test
    public void testConfigNoTargetType() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformValue.configure(Collections.emptyMap()));
    }

    @Test
    public void testConfigInvalidTargetType() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformValue.configure(Collections.singletonMap("target.type", "invalid")));
    }

    @Test
    public void testConfigInvalidUnixPrecision() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "unix");
        config.put("unix.precision", "invalid");
        Assertions.assertThrows(ConfigException.class, () -> this.xformValue.configure(config));
    }

    @Test
    public void testConfigValidUnixPrecision() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "unix");
        config.put("unix.precision", "seconds");
        Assertions.assertDoesNotThrow(() -> this.xformValue.configure(config));
    }

    @Test
    public void testConfigMissingFormat() {
        Assertions.assertThrows(ConfigException.class, () -> this.xformValue.configure(Collections.singletonMap("target.type", "string")));
    }

    @Test
    public void testConfigInvalidFormat() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "string");
        config.put("format", "bad-format");
        Assertions.assertThrows(ConfigException.class, () -> this.xformValue.configure(config));
    }

    @Test
    public void testSchemalessIdentity() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME.getTime()));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimestampToDate() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Date"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME.getTime()));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimestampToTime() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Time"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME.getTime()));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimestampToUnix() {
        this.xformValue.configure(Collections.singletonMap("target.type", "unix"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME.getTime()));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME_UNIX, (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimestampToString() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "string");
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME.getTime()));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME_STRING, (Object)transformed.value());
    }

    @Test
    public void testSchemalessDateToTimestamp() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE.getTime()));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimeToTimestamp() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(TIME.getTime()));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessUnixToTimestamp() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME_UNIX));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessStringToTimestamp() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME_STRING));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaIdentity() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(Timestamp.SCHEMA, DATE_PLUS_TIME.getTime()));
        Assertions.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimestampToDate() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Date"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(Timestamp.SCHEMA, DATE_PLUS_TIME.getTime()));
        Assertions.assertEquals((Object)org.apache.kafka.connect.data.Date.SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimestampToTime() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Time"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(Timestamp.SCHEMA, DATE_PLUS_TIME.getTime()));
        Assertions.assertEquals((Object)Time.SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimestampToUnix() {
        this.xformValue.configure(Collections.singletonMap("target.type", "unix"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(Timestamp.SCHEMA, DATE_PLUS_TIME.getTime()));
        Assertions.assertEquals((Object)Schema.INT64_SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME_UNIX, (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimestampToString() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "string");
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(Timestamp.SCHEMA, DATE_PLUS_TIME.getTime()));
        Assertions.assertEquals((Object)Schema.STRING_SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME_STRING, (Object)transformed.value());
    }

    @Test
    public void testSchemalessNullValueToString() {
        this.testSchemalessNullValueConversion("string");
        this.testSchemalessNullFieldConversion("string");
    }

    @Test
    public void testSchemalessNullValueToDate() {
        this.testSchemalessNullValueConversion("Date");
        this.testSchemalessNullFieldConversion("Date");
    }

    @Test
    public void testSchemalessNullValueToTimestamp() {
        this.testSchemalessNullValueConversion("Timestamp");
        this.testSchemalessNullFieldConversion("Timestamp");
    }

    @Test
    public void testSchemalessNullValueToUnix() {
        this.testSchemalessNullValueConversion("unix");
        this.testSchemalessNullFieldConversion("unix");
    }

    @Test
    public void testSchemalessNullValueToTime() {
        this.testSchemalessNullValueConversion("Time");
        this.testSchemalessNullFieldConversion("Time");
    }

    private void testSchemalessNullValueConversion(String targetType) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", targetType);
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(null));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertNull((Object)transformed.value());
    }

    private void testSchemalessNullFieldConversion(String targetType) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", targetType);
        config.put("format", STRING_DATE_FMT);
        config.put("field", "ts");
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(null));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertNull((Object)transformed.value());
    }

    @Test
    public void testWithSchemaDateToTimestamp() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(org.apache.kafka.connect.data.Date.SCHEMA, DATE.getTime()));
        Assertions.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimeToTimestamp() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(Time.SCHEMA, TIME.getTime()));
        Assertions.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaUnixToTimestamp() {
        this.xformValue.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(Schema.INT64_SCHEMA, DATE_PLUS_TIME_UNIX));
        Assertions.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaStringToTimestamp() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(Schema.STRING_SCHEMA, DATE_PLUS_TIME_STRING));
        Assertions.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaNullValueToTimestamp() {
        this.testWithSchemaNullValueConversion("Timestamp", Schema.OPTIONAL_INT64_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
        this.testWithSchemaNullValueConversion("Timestamp", TimestampConverter.OPTIONAL_TIME_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
        this.testWithSchemaNullValueConversion("Timestamp", TimestampConverter.OPTIONAL_DATE_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
        this.testWithSchemaNullValueConversion("Timestamp", Schema.OPTIONAL_STRING_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
        this.testWithSchemaNullValueConversion("Timestamp", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
    }

    @Test
    public void testWithSchemaNullFieldToTimestamp() {
        this.testWithSchemaNullFieldConversion("Timestamp", Schema.OPTIONAL_INT64_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
        this.testWithSchemaNullFieldConversion("Timestamp", TimestampConverter.OPTIONAL_TIME_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
        this.testWithSchemaNullFieldConversion("Timestamp", TimestampConverter.OPTIONAL_DATE_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
        this.testWithSchemaNullFieldConversion("Timestamp", Schema.OPTIONAL_STRING_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
        this.testWithSchemaNullFieldConversion("Timestamp", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA);
    }

    @Test
    public void testWithSchemaNullValueToUnix() {
        this.testWithSchemaNullValueConversion("unix", Schema.OPTIONAL_INT64_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
        this.testWithSchemaNullValueConversion("unix", TimestampConverter.OPTIONAL_TIME_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
        this.testWithSchemaNullValueConversion("unix", TimestampConverter.OPTIONAL_DATE_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
        this.testWithSchemaNullValueConversion("unix", Schema.OPTIONAL_STRING_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
        this.testWithSchemaNullValueConversion("unix", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
    }

    @Test
    public void testWithSchemaNullFieldToUnix() {
        this.testWithSchemaNullFieldConversion("unix", Schema.OPTIONAL_INT64_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
        this.testWithSchemaNullFieldConversion("unix", TimestampConverter.OPTIONAL_TIME_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
        this.testWithSchemaNullFieldConversion("unix", TimestampConverter.OPTIONAL_DATE_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
        this.testWithSchemaNullFieldConversion("unix", Schema.OPTIONAL_STRING_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
        this.testWithSchemaNullFieldConversion("unix", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA);
    }

    @Test
    public void testWithSchemaNullValueToTime() {
        this.testWithSchemaNullValueConversion("Time", Schema.OPTIONAL_INT64_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
        this.testWithSchemaNullValueConversion("Time", TimestampConverter.OPTIONAL_TIME_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
        this.testWithSchemaNullValueConversion("Time", TimestampConverter.OPTIONAL_DATE_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
        this.testWithSchemaNullValueConversion("Time", Schema.OPTIONAL_STRING_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
        this.testWithSchemaNullValueConversion("Time", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
    }

    @Test
    public void testWithSchemaNullFieldToTime() {
        this.testWithSchemaNullFieldConversion("Time", Schema.OPTIONAL_INT64_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
        this.testWithSchemaNullFieldConversion("Time", TimestampConverter.OPTIONAL_TIME_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
        this.testWithSchemaNullFieldConversion("Time", TimestampConverter.OPTIONAL_DATE_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
        this.testWithSchemaNullFieldConversion("Time", Schema.OPTIONAL_STRING_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
        this.testWithSchemaNullFieldConversion("Time", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, TimestampConverter.OPTIONAL_TIME_SCHEMA);
    }

    @Test
    public void testWithSchemaNullValueToDate() {
        this.testWithSchemaNullValueConversion("Date", Schema.OPTIONAL_INT64_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
        this.testWithSchemaNullValueConversion("Date", TimestampConverter.OPTIONAL_TIME_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
        this.testWithSchemaNullValueConversion("Date", TimestampConverter.OPTIONAL_DATE_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
        this.testWithSchemaNullValueConversion("Date", Schema.OPTIONAL_STRING_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
        this.testWithSchemaNullValueConversion("Date", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
    }

    @Test
    public void testWithSchemaNullFieldToDate() {
        this.testWithSchemaNullFieldConversion("Date", Schema.OPTIONAL_INT64_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
        this.testWithSchemaNullFieldConversion("Date", TimestampConverter.OPTIONAL_TIME_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
        this.testWithSchemaNullFieldConversion("Date", TimestampConverter.OPTIONAL_DATE_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
        this.testWithSchemaNullFieldConversion("Date", Schema.OPTIONAL_STRING_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
        this.testWithSchemaNullFieldConversion("Date", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, TimestampConverter.OPTIONAL_DATE_SCHEMA);
    }

    @Test
    public void testWithSchemaNullValueToString() {
        this.testWithSchemaNullValueConversion("string", Schema.OPTIONAL_INT64_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
        this.testWithSchemaNullValueConversion("string", TimestampConverter.OPTIONAL_TIME_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
        this.testWithSchemaNullValueConversion("string", TimestampConverter.OPTIONAL_DATE_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
        this.testWithSchemaNullValueConversion("string", Schema.OPTIONAL_STRING_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
        this.testWithSchemaNullValueConversion("string", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
    }

    @Test
    public void testWithSchemaNullFieldToString() {
        this.testWithSchemaNullFieldConversion("string", Schema.OPTIONAL_INT64_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
        this.testWithSchemaNullFieldConversion("string", TimestampConverter.OPTIONAL_TIME_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
        this.testWithSchemaNullFieldConversion("string", TimestampConverter.OPTIONAL_DATE_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
        this.testWithSchemaNullFieldConversion("string", Schema.OPTIONAL_STRING_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
        this.testWithSchemaNullFieldConversion("string", TimestampConverter.OPTIONAL_TIMESTAMP_SCHEMA, Schema.OPTIONAL_STRING_SCHEMA);
    }

    private void testWithSchemaNullValueConversion(String targetType, Schema originalSchema, Schema expectedSchema) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", targetType);
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(originalSchema, null));
        Assertions.assertEquals((Object)expectedSchema, (Object)transformed.valueSchema());
        Assertions.assertNull((Object)transformed.value());
    }

    private void testWithSchemaNullFieldConversion(String targetType, Schema originalSchema, Schema expectedSchema) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", targetType);
        config.put("format", STRING_DATE_FMT);
        config.put("field", "ts");
        this.xformValue.configure(config);
        SchemaBuilder structSchema = SchemaBuilder.struct().field("ts", originalSchema).field("other", Schema.STRING_SCHEMA);
        SchemaBuilder expectedStructSchema = SchemaBuilder.struct().field("ts", expectedSchema).field("other", Schema.STRING_SCHEMA);
        Struct original = new Struct((Schema)structSchema);
        original.put("ts", null);
        original.put("other", (Object)"test");
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(structSchema.build(), original));
        Assertions.assertEquals((Object)expectedStructSchema.build(), (Object)transformed.valueSchema());
        Assertions.assertNull((Object)Requirements.requireStruct((Object)transformed.value(), (String)"").get("ts"));
        transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(structSchema.optional().build(), null));
        Assertions.assertEquals((Object)expectedStructSchema.optional().build(), (Object)transformed.valueSchema());
        Assertions.assertNull((Object)transformed.value());
    }

    @Test
    public void testSchemalessFieldConversion() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Date");
        config.put("field", "ts");
        this.xformValue.configure(config);
        Map<String, Date> value = Collections.singletonMap("ts", DATE_PLUS_TIME.getTime());
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(value));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals(Collections.singletonMap("ts", DATE.getTime()), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaFieldConversion() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("field", "ts");
        this.xformValue.configure(config);
        Schema structWithTimestampFieldSchema = SchemaBuilder.struct().field("ts", Schema.INT64_SCHEMA).field("other", Schema.STRING_SCHEMA).build();
        Struct original = new Struct(structWithTimestampFieldSchema);
        original.put("ts", (Object)DATE_PLUS_TIME_UNIX);
        original.put("other", (Object)"test");
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(structWithTimestampFieldSchema, original));
        Schema expectedSchema = SchemaBuilder.struct().field("ts", Timestamp.SCHEMA).field("other", Schema.STRING_SCHEMA).build();
        Assertions.assertEquals((Object)expectedSchema, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)((Struct)transformed.value()).get("ts"));
        Assertions.assertEquals((Object)"test", (Object)((Struct)transformed.value()).get("other"));
    }

    @Test
    public void testWithSchemaFieldConversion_Micros() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("field", "ts");
        config.put("unix.precision", "microseconds");
        this.xformValue.configure(config);
        Schema structWithTimestampFieldSchema = SchemaBuilder.struct().field("ts", Schema.INT64_SCHEMA).build();
        Struct original = new Struct(structWithTimestampFieldSchema);
        original.put("ts", (Object)DATE_PLUS_TIME_UNIX_MICROS);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(structWithTimestampFieldSchema, original));
        Schema expectedSchema = SchemaBuilder.struct().field("ts", Timestamp.SCHEMA).build();
        Assertions.assertEquals((Object)expectedSchema, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)((Struct)transformed.value()).get("ts"));
    }

    @Test
    public void testWithSchemaFieldConversion_Nanos() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("field", "ts");
        config.put("unix.precision", "nanoseconds");
        this.xformValue.configure(config);
        Schema structWithTimestampFieldSchema = SchemaBuilder.struct().field("ts", Schema.INT64_SCHEMA).build();
        Struct original = new Struct(structWithTimestampFieldSchema);
        original.put("ts", (Object)DATE_PLUS_TIME_UNIX_NANOS);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(structWithTimestampFieldSchema, original));
        Schema expectedSchema = SchemaBuilder.struct().field("ts", Timestamp.SCHEMA).build();
        Assertions.assertEquals((Object)expectedSchema, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)((Struct)transformed.value()).get("ts"));
    }

    @Test
    public void testWithSchemaFieldConversion_Seconds() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("field", "ts");
        config.put("unix.precision", "seconds");
        this.xformValue.configure(config);
        Schema structWithTimestampFieldSchema = SchemaBuilder.struct().field("ts", Schema.INT64_SCHEMA).build();
        Struct original = new Struct(structWithTimestampFieldSchema);
        original.put("ts", (Object)DATE_PLUS_TIME_UNIX_SECONDS);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordWithSchema(structWithTimestampFieldSchema, original));
        Calendar expectedDate = GregorianCalendar.getInstance(UTC);
        expectedDate.setTimeInMillis(0L);
        expectedDate.add(5, 1);
        expectedDate.add(13, 1);
        Schema expectedSchema = SchemaBuilder.struct().field("ts", Timestamp.SCHEMA).build();
        Assertions.assertEquals((Object)expectedSchema, (Object)transformed.valueSchema());
        Assertions.assertEquals((Object)expectedDate.getTime(), (Object)((Struct)transformed.value()).get("ts"));
    }

    @Test
    public void testSchemalessStringToUnix_Micros() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "unix");
        config.put("unix.precision", "microseconds");
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME_STRING));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)86401234000L, (Object)transformed.value());
    }

    @Test
    public void testSchemalessStringToUnix_Nanos() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "unix");
        config.put("unix.precision", "nanoseconds");
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME_STRING));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)86401234000000L, (Object)transformed.value());
    }

    @Test
    public void testSchemalessStringToUnix_Seconds() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "unix");
        config.put("unix.precision", "seconds");
        config.put("format", STRING_DATE_FMT);
        this.xformValue.configure(config);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)this.createRecordSchemaless(DATE_PLUS_TIME_STRING));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME_UNIX_SECONDS, (Object)transformed.value());
    }

    @Test
    public void testKey() {
        this.xformKey.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)this.xformKey.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME.getTime(), null, null));
        Assertions.assertNull((Object)transformed.keySchema());
        Assertions.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.key());
    }

    private SourceRecord createRecordWithSchema(Schema schema, Object value) {
        return new SourceRecord(null, null, "topic", Integer.valueOf(0), schema, value);
    }

    private SourceRecord createRecordSchemaless(Object value) {
        return this.createRecordWithSchema(null, value);
    }

    static {
        EPOCH.setTimeInMillis(0L);
        TIME = GregorianCalendar.getInstance(UTC);
        TIME.setTimeInMillis(0L);
        TIME.add(14, 1234);
        DATE = GregorianCalendar.getInstance(UTC);
        DATE.setTimeInMillis(0L);
        DATE.set(1970, 0, 1, 0, 0, 0);
        DATE.add(5, 1);
        DATE_PLUS_TIME = GregorianCalendar.getInstance(UTC);
        DATE_PLUS_TIME.setTimeInMillis(0L);
        DATE_PLUS_TIME.add(5, 1);
        DATE_PLUS_TIME.add(14, 1234);
        DATE_PLUS_TIME_UNIX = DATE_PLUS_TIME.getTime().getTime();
        DATE_PLUS_TIME_UNIX_MICROS = DATE_PLUS_TIME_UNIX * 1000L + 123L;
        DATE_PLUS_TIME_UNIX_NANOS = DATE_PLUS_TIME_UNIX_MICROS * 1000L + 456L;
        DATE_PLUS_TIME_UNIX_SECONDS = DATE_PLUS_TIME.getTimeInMillis() / 1000L;
        DATE_PLUS_TIME_STRING = "1970 01 02 00 00 01 234 UTC";
    }
}

