/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.Flatten;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlattenTest {
    private final Flatten<SourceRecord> xformKey = new Flatten.Key();
    private final Flatten<SourceRecord> xformValue = new Flatten.Value();

    @AfterEach
    public void teardown() {
        this.xformKey.close();
        this.xformValue.close();
    }

    @Test
    public void topLevelStructRequired() {
        this.xformValue.configure(Collections.emptyMap());
        Assertions.assertThrows(DataException.class, () -> {
            SourceRecord cfr_ignored_0 = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        });
    }

    @Test
    public void topLevelMapRequired() {
        this.xformValue.configure(Collections.emptyMap());
        Assertions.assertThrows(DataException.class, () -> {
            SourceRecord cfr_ignored_0 = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        });
    }

    @Test
    public void testNestedStruct() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.field("int8", Schema.INT8_SCHEMA);
        builder.field("int16", Schema.INT16_SCHEMA);
        builder.field("int32", Schema.INT32_SCHEMA);
        builder.field("int64", Schema.INT64_SCHEMA);
        builder.field("float32", Schema.FLOAT32_SCHEMA);
        builder.field("float64", Schema.FLOAT64_SCHEMA);
        builder.field("boolean", Schema.BOOLEAN_SCHEMA);
        builder.field("string", Schema.STRING_SCHEMA);
        builder.field("bytes", Schema.BYTES_SCHEMA);
        Schema supportedTypesSchema = builder.build();
        builder = SchemaBuilder.struct();
        builder.field("B", supportedTypesSchema);
        Schema oneLevelNestedSchema = builder.build();
        builder = SchemaBuilder.struct();
        builder.field("A", oneLevelNestedSchema);
        Schema twoLevelNestedSchema = builder.build();
        Struct supportedTypes = new Struct(supportedTypesSchema);
        supportedTypes.put("int8", (Object)8);
        supportedTypes.put("int16", (Object)16);
        supportedTypes.put("int32", (Object)32);
        supportedTypes.put("int64", (Object)64L);
        supportedTypes.put("float32", (Object)Float.valueOf(32.0f));
        supportedTypes.put("float64", (Object)64.0);
        supportedTypes.put("boolean", (Object)true);
        supportedTypes.put("string", (Object)"stringy");
        supportedTypes.put("bytes", (Object)"bytes".getBytes());
        Struct oneLevelNestedStruct = new Struct(oneLevelNestedSchema);
        oneLevelNestedStruct.put("B", (Object)supportedTypes);
        Struct twoLevelNestedStruct = new Struct(twoLevelNestedSchema);
        twoLevelNestedStruct.put("A", (Object)oneLevelNestedStruct);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), twoLevelNestedSchema, (Object)twoLevelNestedStruct));
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)transformed.valueSchema().type());
        Struct transformedStruct = (Struct)transformed.value();
        Assertions.assertEquals((int)9, (int)transformedStruct.schema().fields().size());
        Assertions.assertEquals((int)8, (int)transformedStruct.getInt8("A.B.int8").byteValue());
        Assertions.assertEquals((int)16, (int)transformedStruct.getInt16("A.B.int16").shortValue());
        Assertions.assertEquals((int)32, (int)transformedStruct.getInt32("A.B.int32"));
        Assertions.assertEquals((long)64L, (long)transformedStruct.getInt64("A.B.int64"));
        Assertions.assertEquals((float)32.0f, (float)transformedStruct.getFloat32("A.B.float32").floatValue(), (float)0.0f);
        Assertions.assertEquals((double)64.0, (double)transformedStruct.getFloat64("A.B.float64"), (double)0.0);
        Assertions.assertEquals((Object)true, (Object)transformedStruct.getBoolean("A.B.boolean"));
        Assertions.assertEquals((Object)"stringy", (Object)transformedStruct.getString("A.B.string"));
        Assertions.assertArrayEquals((byte[])"bytes".getBytes(), (byte[])transformedStruct.getBytes("A.B.bytes"));
    }

    @Test
    public void testNestedMapWithDelimiter() {
        this.xformValue.configure(Collections.singletonMap("delimiter", "#"));
        HashMap<String, Object> supportedTypes = new HashMap<String, Object>();
        supportedTypes.put("int8", (byte)8);
        supportedTypes.put("int16", (short)16);
        supportedTypes.put("int32", 32);
        supportedTypes.put("int64", 64L);
        supportedTypes.put("float32", Float.valueOf(32.0f));
        supportedTypes.put("float64", 64.0);
        supportedTypes.put("boolean", true);
        supportedTypes.put("string", "stringy");
        supportedTypes.put("bytes", "bytes".getBytes());
        Map oneLevelNestedMap = Collections.singletonMap("B", supportedTypes);
        Map twoLevelNestedMap = Collections.singletonMap("A", oneLevelNestedMap);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, twoLevelNestedMap));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertTrue((boolean)(transformed.value() instanceof Map));
        Map transformedMap = (Map)transformed.value();
        Assertions.assertEquals((int)9, (int)transformedMap.size());
        Assertions.assertEquals((Object)8, transformedMap.get("A#B#int8"));
        Assertions.assertEquals((Object)16, transformedMap.get("A#B#int16"));
        Assertions.assertEquals((Object)32, transformedMap.get("A#B#int32"));
        Assertions.assertEquals((Object)64L, transformedMap.get("A#B#int64"));
        Assertions.assertEquals((float)32.0f, (float)((Float)transformedMap.get("A#B#float32")).floatValue(), (float)0.0f);
        Assertions.assertEquals((double)64.0, (double)((Double)transformedMap.get("A#B#float64")), (double)0.0);
        Assertions.assertEquals((Object)true, transformedMap.get("A#B#boolean"));
        Assertions.assertEquals((Object)"stringy", transformedMap.get("A#B#string"));
        Assertions.assertArrayEquals((byte[])"bytes".getBytes(), (byte[])((byte[])transformedMap.get("A#B#bytes")));
    }

    @Test
    public void testOptionalFieldStruct() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.field("opt_int32", Schema.OPTIONAL_INT32_SCHEMA);
        Schema supportedTypesSchema = builder.build();
        builder = SchemaBuilder.struct();
        builder.field("B", supportedTypesSchema);
        Schema oneLevelNestedSchema = builder.build();
        Struct supportedTypes = new Struct(supportedTypesSchema);
        supportedTypes.put("opt_int32", null);
        Struct oneLevelNestedStruct = new Struct(oneLevelNestedSchema);
        oneLevelNestedStruct.put("B", (Object)supportedTypes);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), oneLevelNestedSchema, (Object)oneLevelNestedStruct));
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)transformed.valueSchema().type());
        Struct transformedStruct = (Struct)transformed.value();
        Assertions.assertNull((Object)transformedStruct.get("B.opt_int32"));
    }

    @Test
    public void testOptionalStruct() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct().optional();
        builder.field("opt_int32", Schema.OPTIONAL_INT32_SCHEMA);
        Schema schema = builder.build();
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), schema, null));
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)transformed.valueSchema().type());
        Assertions.assertNull((Object)transformed.value());
    }

    @Test
    public void testOptionalNestedStruct() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct().optional();
        builder.field("opt_int32", Schema.OPTIONAL_INT32_SCHEMA);
        Schema supportedTypesSchema = builder.build();
        builder = SchemaBuilder.struct();
        builder.field("B", supportedTypesSchema);
        Schema oneLevelNestedSchema = builder.build();
        Struct oneLevelNestedStruct = new Struct(oneLevelNestedSchema);
        oneLevelNestedStruct.put("B", null);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), oneLevelNestedSchema, (Object)oneLevelNestedStruct));
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)transformed.valueSchema().type());
        Struct transformedStruct = (Struct)transformed.value();
        Assertions.assertNull((Object)transformedStruct.get("B.opt_int32"));
    }

    @Test
    public void testOptionalFieldMap() {
        this.xformValue.configure(Collections.emptyMap());
        HashMap<String, Object> supportedTypes = new HashMap<String, Object>();
        supportedTypes.put("opt_int32", null);
        Map oneLevelNestedMap = Collections.singletonMap("B", supportedTypes);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, oneLevelNestedMap));
        Assertions.assertNull((Object)transformed.valueSchema());
        Assertions.assertTrue((boolean)(transformed.value() instanceof Map));
        Map transformedMap = (Map)transformed.value();
        Assertions.assertNull(transformedMap.get("B.opt_int32"));
    }

    @Test
    public void testKey() {
        this.xformKey.configure(Collections.emptyMap());
        Map<String, Map<String, Integer>> key = Collections.singletonMap("A", Collections.singletonMap("B", 12));
        SourceRecord src = new SourceRecord(null, null, "topic", null, key, null, null);
        SourceRecord transformed = (SourceRecord)this.xformKey.apply((ConnectRecord)src);
        Assertions.assertNull((Object)transformed.keySchema());
        Assertions.assertTrue((boolean)(transformed.key() instanceof Map));
        Map transformedMap = (Map)transformed.key();
        Assertions.assertEquals((Object)12, transformedMap.get("A.B"));
    }

    @Test
    public void testSchemalessArray() {
        this.xformValue.configure(Collections.emptyMap());
        Map<String, List<Object>> value = Collections.singletonMap("foo", Arrays.asList("bar", Collections.singletonMap("baz", Collections.singletonMap("lfg", "lfg"))));
        Assertions.assertEquals(value, (Object)((SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", null, null, null, value))).value());
    }

    @Test
    public void testArrayWithSchema() {
        this.xformValue.configure(Collections.emptyMap());
        Schema nestedStructSchema = SchemaBuilder.struct().field("lfg", Schema.STRING_SCHEMA).build();
        Schema innerStructSchema = SchemaBuilder.struct().field("baz", nestedStructSchema).build();
        Schema structSchema = SchemaBuilder.struct().field("foo", SchemaBuilder.array((Schema)innerStructSchema).doc("durk").build()).build();
        Struct nestedValue = new Struct(nestedStructSchema);
        nestedValue.put("lfg", (Object)"lfg");
        Struct innerValue = new Struct(innerStructSchema);
        innerValue.put("baz", (Object)nestedValue);
        Struct value = new Struct(structSchema);
        value.put("foo", Collections.singletonList(innerValue));
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", null, null, structSchema, (Object)value));
        Assertions.assertEquals((Object)value, (Object)transformed.value());
        Assertions.assertEquals((Object)structSchema, (Object)transformed.valueSchema());
    }

    @Test
    public void testOptionalAndDefaultValuesNested() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct().optional();
        builder.field("req_field", Schema.STRING_SCHEMA);
        builder.field("opt_field", SchemaBuilder.string().optional().defaultValue((Object)"child_default").build());
        Struct childDefaultValue = new Struct((Schema)builder);
        childDefaultValue.put("req_field", (Object)"req_default");
        builder.defaultValue((Object)childDefaultValue);
        Schema schema = builder.build();
        Struct value = new Struct(schema);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), schema, (Object)value));
        Assertions.assertNotNull((Object)transformed);
        Schema transformedSchema = transformed.valueSchema();
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)transformedSchema.type());
        Assertions.assertEquals((int)2, (int)transformedSchema.fields().size());
        Schema transformedReqFieldSchema = SchemaBuilder.string().optional().defaultValue((Object)"req_default").build();
        Assertions.assertEquals((Object)transformedReqFieldSchema, (Object)transformedSchema.field("req_field").schema());
        Schema transformedOptFieldSchema = SchemaBuilder.string().optional().defaultValue((Object)"child_default").build();
        Assertions.assertEquals((Object)transformedOptFieldSchema, (Object)transformedSchema.field("opt_field").schema());
    }

    @Test
    public void tombstoneEventWithoutSchemaShouldPassThrough() {
        this.xformValue.configure(Collections.emptyMap());
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), null, null);
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assertions.assertNull((Object)transformedRecord.value());
        Assertions.assertNull((Object)transformedRecord.valueSchema());
    }

    @Test
    public void tombstoneEventWithSchemaShouldPassThrough() {
        this.xformValue.configure(Collections.emptyMap());
        Schema simpleStructSchema = SchemaBuilder.struct().name("name").version(Integer.valueOf(1)).doc("doc").field("magic", Schema.OPTIONAL_INT64_SCHEMA).build();
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), simpleStructSchema, null);
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assertions.assertNull((Object)transformedRecord.value());
        Assertions.assertEquals((Object)simpleStructSchema, (Object)transformedRecord.valueSchema());
    }

    @Test
    public void testMapWithNullFields() {
        this.xformValue.configure(Collections.emptyMap());
        LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
        value.put("firstNull", null);
        value.put("firstNonNull", "nonNull");
        value.put("secondNull", null);
        value.put("secondNonNull", "alsoNonNull");
        value.put("thirdNonNull", null);
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), null, value);
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assertions.assertEquals(value, (Object)transformedRecord.value());
    }

    @Test
    public void testStructWithNullFields() {
        this.xformValue.configure(Collections.emptyMap());
        Schema structSchema = SchemaBuilder.struct().field("firstNull", Schema.OPTIONAL_STRING_SCHEMA).field("firstNonNull", Schema.OPTIONAL_STRING_SCHEMA).field("secondNull", Schema.OPTIONAL_STRING_SCHEMA).field("secondNonNull", Schema.OPTIONAL_STRING_SCHEMA).field("thirdNonNull", Schema.OPTIONAL_STRING_SCHEMA).build();
        Struct value = new Struct(structSchema);
        value.put("firstNull", null);
        value.put("firstNonNull", (Object)"nonNull");
        value.put("secondNull", null);
        value.put("secondNonNull", (Object)"alsoNonNull");
        value.put("thirdNonNull", null);
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), structSchema, (Object)value);
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assertions.assertEquals((Object)value, (Object)transformedRecord.value());
    }
}

