/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.ExtractField;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtractFieldTest {
    private final ExtractField<SinkRecord> xform = new ExtractField.Key();

    @AfterEach
    public void teardown() {
        this.xform.close();
    }

    @Test
    public void schemaless() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        SinkRecord record = new SinkRecord("test", 0, null, Collections.singletonMap("magic", 42), null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertNull((Object)transformedRecord.keySchema());
        Assertions.assertEquals((Object)42, (Object)transformedRecord.key());
    }

    @Test
    public void testNullSchemaless() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        Object key = null;
        SinkRecord record = new SinkRecord("test", 0, null, key, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertNull((Object)transformedRecord.keySchema());
        Assertions.assertNull((Object)transformedRecord.key());
    }

    @Test
    public void withSchema() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        Schema keySchema = SchemaBuilder.struct().field("magic", Schema.INT32_SCHEMA).build();
        Struct key = new Struct(keySchema).put("magic", (Object)42);
        SinkRecord record = new SinkRecord("test", 0, keySchema, (Object)key, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertEquals((Object)Schema.INT32_SCHEMA, (Object)transformedRecord.keySchema());
        Assertions.assertEquals((Object)42, (Object)transformedRecord.key());
    }

    @Test
    public void testNullWithSchema() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        Schema keySchema = SchemaBuilder.struct().field("magic", Schema.INT32_SCHEMA).optional().build();
        Object key = null;
        SinkRecord record = new SinkRecord("test", 0, keySchema, key, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertEquals((Object)Schema.INT32_SCHEMA, (Object)transformedRecord.keySchema());
        Assertions.assertNull((Object)transformedRecord.key());
    }

    @Test
    public void nonExistentFieldSchemalessShouldReturnNull() {
        this.xform.configure(Collections.singletonMap("field", "nonexistent"));
        SinkRecord record = new SinkRecord("test", 0, null, Collections.singletonMap("magic", 42), null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assertions.assertNull((Object)transformedRecord.keySchema());
        Assertions.assertNull((Object)transformedRecord.key());
    }

    @Test
    public void nonExistentFieldWithSchemaShouldFail() {
        this.xform.configure(Collections.singletonMap("field", "nonexistent"));
        Schema keySchema = SchemaBuilder.struct().field("magic", Schema.INT32_SCHEMA).build();
        Struct key = new Struct(keySchema).put("magic", (Object)42);
        SinkRecord record = new SinkRecord("test", 0, keySchema, (Object)key, null, null, 0L);
        try {
            this.xform.apply((ConnectRecord)record);
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (IllegalArgumentException iae) {
            Assertions.assertEquals((Object)"Unknown field: nonexistent", (Object)iae.getMessage());
        }
    }
}

