/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.RegexRouter;
import org.junit.Assert;
import org.junit.Test;

public class RegexRouterTest {
    private static String apply(String regex, String replacement, String topic) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("regex", regex);
        props.put("replacement", replacement);
        RegexRouter router = new RegexRouter();
        router.configure(props);
        String sinkTopic = ((SinkRecord)router.apply((ConnectRecord)new SinkRecord(topic, 0, null, null, null, null, 0L))).topic();
        router.close();
        return sinkTopic;
    }

    @Test
    public void staticReplacement() {
        Assert.assertEquals((Object)"bar", (Object)RegexRouterTest.apply("foo", "bar", "foo"));
    }

    @Test
    public void doesntMatch() {
        Assert.assertEquals((Object)"orig", (Object)RegexRouterTest.apply("foo", "bar", "orig"));
    }

    @Test
    public void identity() {
        Assert.assertEquals((Object)"orig", (Object)RegexRouterTest.apply("(.*)", "$1", "orig"));
    }

    @Test
    public void addPrefix() {
        Assert.assertEquals((Object)"prefix-orig", (Object)RegexRouterTest.apply("(.*)", "prefix-$1", "orig"));
    }

    @Test
    public void addSuffix() {
        Assert.assertEquals((Object)"orig-suffix", (Object)RegexRouterTest.apply("(.*)", "$1-suffix", "orig"));
    }

    @Test
    public void slice() {
        Assert.assertEquals((Object)"index", (Object)RegexRouterTest.apply("(.*)-(\\d\\d\\d\\d\\d\\d\\d\\d)", "$1", "index-20160117"));
    }
}

