/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.MaskField;
import org.junit.Assert;
import org.junit.Test;

public class MaskFieldTest {
    private static final Schema SCHEMA = SchemaBuilder.struct().field("magic", Schema.INT32_SCHEMA).field("bool", Schema.BOOLEAN_SCHEMA).field("byte", Schema.INT8_SCHEMA).field("short", Schema.INT16_SCHEMA).field("int", Schema.INT32_SCHEMA).field("long", Schema.INT64_SCHEMA).field("float", Schema.FLOAT32_SCHEMA).field("double", Schema.FLOAT64_SCHEMA).field("string", Schema.STRING_SCHEMA).field("date", org.apache.kafka.connect.data.Date.SCHEMA).field("time", Time.SCHEMA).field("timestamp", Timestamp.SCHEMA).field("decimal", Decimal.schema((int)0)).field("array", (Schema)SchemaBuilder.array((Schema)Schema.INT32_SCHEMA)).field("map", (Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA)).build();
    private static final Map<String, Object> VALUES = new HashMap<String, Object>();
    private static final Struct VALUES_WITH_SCHEMA = new Struct(SCHEMA);

    private static MaskField<SinkRecord> transform(List<String> fields, String replacement) {
        MaskField.Value xform = new MaskField.Value();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("fields", fields);
        props.put("replacement", replacement);
        xform.configure(props);
        return xform;
    }

    private static SinkRecord record(Schema schema, Object value) {
        return new SinkRecord("", 0, null, null, schema, value, 0L);
    }

    private static void checkReplacementWithSchema(String maskField, Object replacement) {
        SinkRecord record = MaskFieldTest.record(SCHEMA, VALUES_WITH_SCHEMA);
        Struct updatedValue = (Struct)((SinkRecord)MaskFieldTest.transform(Collections.singletonList(maskField), String.valueOf(replacement)).apply((ConnectRecord)record)).value();
        Assert.assertEquals((String)("Invalid replacement for " + maskField + " value"), (Object)replacement, (Object)updatedValue.get(maskField));
    }

    private static void checkReplacementSchemaless(String maskField, Object replacement) {
        MaskFieldTest.checkReplacementSchemaless(Collections.singletonList(maskField), replacement);
    }

    private static void checkReplacementSchemaless(List<String> maskFields, Object replacement) {
        SinkRecord record = MaskFieldTest.record(null, VALUES);
        Map updatedValue = (Map)((SinkRecord)MaskFieldTest.transform(maskFields, String.valueOf(replacement)).apply((ConnectRecord)record)).value();
        for (String maskField : maskFields) {
            Assert.assertEquals((String)("Invalid replacement for " + maskField + " value"), (Object)replacement, updatedValue.get(maskField));
        }
    }

    @Test
    public void testSchemaless() {
        ArrayList<String> maskFields = new ArrayList<String>(VALUES.keySet());
        maskFields.remove("magic");
        Map updatedValue = (Map)((SinkRecord)MaskFieldTest.transform(maskFields, null).apply((ConnectRecord)MaskFieldTest.record(null, VALUES))).value();
        Assert.assertEquals((Object)42, updatedValue.get("magic"));
        Assert.assertEquals((Object)false, updatedValue.get("bool"));
        Assert.assertEquals((Object)0, updatedValue.get("byte"));
        Assert.assertEquals((Object)0, updatedValue.get("short"));
        Assert.assertEquals((Object)0, updatedValue.get("int"));
        Assert.assertEquals((Object)0L, updatedValue.get("long"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), updatedValue.get("float"));
        Assert.assertEquals((Object)0.0, updatedValue.get("double"));
        Assert.assertEquals((Object)"", updatedValue.get("string"));
        Assert.assertEquals((Object)new Date(0L), updatedValue.get("date"));
        Assert.assertEquals((Object)BigInteger.ZERO, updatedValue.get("bigint"));
        Assert.assertEquals((Object)BigDecimal.ZERO, updatedValue.get("bigdec"));
        Assert.assertEquals(Collections.emptyList(), updatedValue.get("list"));
        Assert.assertEquals(Collections.emptyMap(), updatedValue.get("map"));
    }

    @Test
    public void testWithSchema() {
        ArrayList<String> maskFields = new ArrayList<String>(SCHEMA.fields().size());
        for (Field field : SCHEMA.fields()) {
            if (field.name().equals("magic")) continue;
            maskFields.add(field.name());
        }
        Struct updatedValue = (Struct)((SinkRecord)MaskFieldTest.transform(maskFields, null).apply((ConnectRecord)MaskFieldTest.record(SCHEMA, VALUES_WITH_SCHEMA))).value();
        Assert.assertEquals((Object)42, (Object)updatedValue.get("magic"));
        Assert.assertEquals((Object)false, (Object)updatedValue.get("bool"));
        Assert.assertEquals((Object)0, (Object)updatedValue.get("byte"));
        Assert.assertEquals((Object)0, (Object)updatedValue.get("short"));
        Assert.assertEquals((Object)0, (Object)updatedValue.get("int"));
        Assert.assertEquals((Object)0L, (Object)updatedValue.get("long"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)updatedValue.get("float"));
        Assert.assertEquals((Object)0.0, (Object)updatedValue.get("double"));
        Assert.assertEquals((Object)"", (Object)updatedValue.get("string"));
        Assert.assertEquals((Object)new Date(0L), (Object)updatedValue.get("date"));
        Assert.assertEquals((Object)new Date(0L), (Object)updatedValue.get("time"));
        Assert.assertEquals((Object)new Date(0L), (Object)updatedValue.get("timestamp"));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)updatedValue.get("decimal"));
        Assert.assertEquals(Collections.emptyList(), (Object)updatedValue.get("array"));
        Assert.assertEquals(Collections.emptyMap(), (Object)updatedValue.get("map"));
    }

    @Test
    public void testSchemalessWithReplacement() {
        MaskFieldTest.checkReplacementSchemaless("short", (Object)123);
        MaskFieldTest.checkReplacementSchemaless("byte", (Object)123);
        MaskFieldTest.checkReplacementSchemaless("int", (Object)123);
        MaskFieldTest.checkReplacementSchemaless("long", (Object)123L);
        MaskFieldTest.checkReplacementSchemaless("float", (Object)Float.valueOf(123.0f));
        MaskFieldTest.checkReplacementSchemaless("double", (Object)123.0);
        MaskFieldTest.checkReplacementSchemaless("string", (Object)"123");
        MaskFieldTest.checkReplacementSchemaless("bigint", (Object)BigInteger.valueOf(123L));
        MaskFieldTest.checkReplacementSchemaless("bigdec", (Object)BigDecimal.valueOf(123.0));
    }

    @Test
    public void testSchemalessUnsupportedReplacementType() {
        String exMessage = "Cannot mask value of type";
        Class<DataException> exClass = DataException.class;
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("date", (Object)new Date()));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless(Arrays.asList("int", "date"), (Object)new Date()));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("bool", (Object)false));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("list", Collections.singletonList("123")));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("map", Collections.singletonMap("123", "321")));
    }

    @Test
    public void testWithSchemaAndReplacement() {
        MaskFieldTest.checkReplacementWithSchema("short", (short)123);
        MaskFieldTest.checkReplacementWithSchema("byte", (byte)123);
        MaskFieldTest.checkReplacementWithSchema("int", 123);
        MaskFieldTest.checkReplacementWithSchema("long", 123L);
        MaskFieldTest.checkReplacementWithSchema("float", Float.valueOf(123.0f));
        MaskFieldTest.checkReplacementWithSchema("double", 123.0);
        MaskFieldTest.checkReplacementWithSchema("string", "123");
        MaskFieldTest.checkReplacementWithSchema("decimal", BigDecimal.valueOf(123.0));
    }

    @Test
    public void testWithSchemaUnsupportedReplacementType() {
        String exMessage = "Cannot mask value of type";
        Class<DataException> exClass = DataException.class;
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementWithSchema("time", new Date()));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementWithSchema("timestamp", new Date()));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementWithSchema("array", Collections.singletonList(123)));
    }

    @Test
    public void testReplacementTypeMismatch() {
        String exMessage = "Invalid value  for configuration replacement";
        Class<DataException> exClass = DataException.class;
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("byte", (Object)"foo"));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("short", (Object)"foo"));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("int", (Object)"foo"));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("long", (Object)"foo"));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("float", (Object)"foo"));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("double", (Object)"foo"));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("bigint", (Object)"foo"));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("bigdec", (Object)"foo"));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("int", (Object)new Date()));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless("int", new Object()));
        Assert.assertThrows((String)exMessage, exClass, () -> MaskFieldTest.checkReplacementSchemaless(Arrays.asList("string", "int"), (Object)"foo"));
    }

    @Test
    public void testEmptyStringReplacementValue() {
        Assert.assertThrows((String)"String must be non-empty", ConfigException.class, () -> MaskFieldTest.checkReplacementSchemaless("short", (Object)""));
    }

    static {
        VALUES.put("magic", 42);
        VALUES.put("bool", true);
        VALUES.put("byte", (byte)42);
        VALUES.put("short", (short)42);
        VALUES.put("int", 42);
        VALUES.put("long", 42L);
        VALUES.put("float", Float.valueOf(42.0f));
        VALUES.put("double", 42.0);
        VALUES.put("string", "55.121.20.20");
        VALUES.put("date", new Date());
        VALUES.put("bigint", new BigInteger("42"));
        VALUES.put("bigdec", new BigDecimal("42.0"));
        VALUES.put("list", Collections.singletonList(42));
        VALUES.put("map", Collections.singletonMap("key", "value"));
        VALUES_WITH_SCHEMA.put("magic", (Object)42);
        VALUES_WITH_SCHEMA.put("bool", (Object)true);
        VALUES_WITH_SCHEMA.put("byte", (Object)42);
        VALUES_WITH_SCHEMA.put("short", (Object)42);
        VALUES_WITH_SCHEMA.put("int", (Object)42);
        VALUES_WITH_SCHEMA.put("long", (Object)42L);
        VALUES_WITH_SCHEMA.put("float", (Object)Float.valueOf(42.0f));
        VALUES_WITH_SCHEMA.put("double", (Object)42.0);
        VALUES_WITH_SCHEMA.put("string", (Object)"hmm");
        VALUES_WITH_SCHEMA.put("date", (Object)new Date());
        VALUES_WITH_SCHEMA.put("time", (Object)new Date());
        VALUES_WITH_SCHEMA.put("timestamp", (Object)new Date());
        VALUES_WITH_SCHEMA.put("decimal", (Object)new BigDecimal(42));
        VALUES_WITH_SCHEMA.put("array", Arrays.asList(1, 2, 3));
        VALUES_WITH_SCHEMA.put("map", Collections.singletonMap("what", "what"));
    }
}

