/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.InsertField;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class InsertFieldTest {
    private InsertField<SourceRecord> xformKey = new InsertField.Key();
    private InsertField<SourceRecord> xformValue = new InsertField.Value();

    @After
    public void teardown() {
        this.xformValue.close();
    }

    @Test(expected=DataException.class)
    public void topLevelStructRequired() {
        this.xformValue.configure(Collections.singletonMap("topic.field", "topic_field"));
        this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
    }

    @Test
    public void copySchemaAndInsertConfiguredFields() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.field", "topic_field!");
        props.put("partition.field", "partition_field");
        props.put("timestamp.field", "timestamp_field?");
        props.put("static.field", "instance_id");
        props.put("static.value", "my-instance-id");
        this.xformValue.configure(props);
        Schema simpleStructSchema = SchemaBuilder.struct().name("name").version(Integer.valueOf(1)).doc("doc").field("magic", Schema.OPTIONAL_INT64_SCHEMA).build();
        Struct simpleStruct = new Struct(simpleStructSchema).put("magic", (Object)42L);
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), null, null, simpleStructSchema, (Object)simpleStruct, Long.valueOf(789L));
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assert.assertEquals((Object)simpleStructSchema.name(), (Object)transformedRecord.valueSchema().name());
        Assert.assertEquals((Object)simpleStructSchema.version(), (Object)transformedRecord.valueSchema().version());
        Assert.assertEquals((Object)simpleStructSchema.doc(), (Object)transformedRecord.valueSchema().doc());
        Assert.assertEquals((Object)Schema.OPTIONAL_INT64_SCHEMA, (Object)transformedRecord.valueSchema().field("magic").schema());
        Assert.assertEquals((long)42L, (long)((Struct)transformedRecord.value()).getInt64("magic"));
        Assert.assertEquals((Object)Schema.STRING_SCHEMA, (Object)transformedRecord.valueSchema().field("topic_field").schema());
        Assert.assertEquals((Object)"test", (Object)((Struct)transformedRecord.value()).getString("topic_field"));
        Assert.assertEquals((Object)Schema.OPTIONAL_INT32_SCHEMA, (Object)transformedRecord.valueSchema().field("partition_field").schema());
        Assert.assertEquals((long)0L, (long)((Struct)transformedRecord.value()).getInt32("partition_field").intValue());
        Assert.assertEquals((Object)Timestamp.builder().optional().build(), (Object)transformedRecord.valueSchema().field("timestamp_field").schema());
        Assert.assertEquals((long)789L, (long)((Date)((Struct)transformedRecord.value()).get("timestamp_field")).getTime());
        Assert.assertEquals((Object)Schema.OPTIONAL_STRING_SCHEMA, (Object)transformedRecord.valueSchema().field("instance_id").schema());
        Assert.assertEquals((Object)"my-instance-id", (Object)((Struct)transformedRecord.value()).getString("instance_id"));
        SourceRecord transformedRecord2 = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "test", Integer.valueOf(1), simpleStructSchema, (Object)new Struct(simpleStructSchema)));
        Assert.assertSame((Object)transformedRecord.valueSchema(), (Object)transformedRecord2.valueSchema());
    }

    @Test
    public void schemalessInsertConfiguredFields() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.field", "topic_field!");
        props.put("partition.field", "partition_field");
        props.put("timestamp.field", "timestamp_field?");
        props.put("static.field", "instance_id");
        props.put("static.value", "my-instance-id");
        this.xformValue.configure(props);
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), null, null, null, Collections.singletonMap("magic", 42L), Long.valueOf(123L));
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assert.assertEquals((Object)42L, ((Map)transformedRecord.value()).get("magic"));
        Assert.assertEquals((Object)"test", ((Map)transformedRecord.value()).get("topic_field"));
        Assert.assertEquals((Object)0, ((Map)transformedRecord.value()).get("partition_field"));
        Assert.assertEquals((Object)123L, ((Map)transformedRecord.value()).get("timestamp_field"));
        Assert.assertEquals((Object)"my-instance-id", ((Map)transformedRecord.value()).get("instance_id"));
    }

    @Test
    public void insertConfiguredFieldsIntoTombstoneEventWithoutSchemaLeavesValueUnchanged() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.field", "topic_field!");
        props.put("partition.field", "partition_field");
        props.put("timestamp.field", "timestamp_field?");
        props.put("static.field", "instance_id");
        props.put("static.value", "my-instance-id");
        this.xformValue.configure(props);
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), null, null);
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assert.assertEquals(null, (Object)transformedRecord.value());
        Assert.assertEquals(null, (Object)transformedRecord.valueSchema());
    }

    @Test
    public void insertConfiguredFieldsIntoTombstoneEventWithSchemaLeavesValueUnchanged() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.field", "topic_field!");
        props.put("partition.field", "partition_field");
        props.put("timestamp.field", "timestamp_field?");
        props.put("static.field", "instance_id");
        props.put("static.value", "my-instance-id");
        this.xformValue.configure(props);
        Schema simpleStructSchema = SchemaBuilder.struct().name("name").version(Integer.valueOf(1)).doc("doc").field("magic", Schema.OPTIONAL_INT64_SCHEMA).build();
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), simpleStructSchema, null);
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assert.assertEquals(null, (Object)transformedRecord.value());
        Assert.assertEquals((Object)simpleStructSchema, (Object)transformedRecord.valueSchema());
    }

    @Test
    public void insertKeyFieldsIntoTombstoneEvent() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.field", "topic_field!");
        props.put("partition.field", "partition_field");
        props.put("timestamp.field", "timestamp_field?");
        props.put("static.field", "instance_id");
        props.put("static.value", "my-instance-id");
        this.xformKey.configure(props);
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), null, Collections.singletonMap("magic", 42L), null, null);
        SourceRecord transformedRecord = (SourceRecord)this.xformKey.apply((ConnectRecord)record);
        Assert.assertEquals((Object)42L, ((Map)transformedRecord.key()).get("magic"));
        Assert.assertEquals((Object)"test", ((Map)transformedRecord.key()).get("topic_field"));
        Assert.assertEquals((Object)0, ((Map)transformedRecord.key()).get("partition_field"));
        Assert.assertEquals(null, ((Map)transformedRecord.key()).get("timestamp_field"));
        Assert.assertEquals((Object)"my-instance-id", ((Map)transformedRecord.key()).get("instance_id"));
        Assert.assertEquals(null, (Object)transformedRecord.value());
    }

    @Test
    public void insertIntoNullKeyLeavesRecordUnchanged() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.field", "topic_field!");
        props.put("partition.field", "partition_field");
        props.put("timestamp.field", "timestamp_field?");
        props.put("static.field", "instance_id");
        props.put("static.value", "my-instance-id");
        this.xformKey.configure(props);
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), null, null, null, Collections.singletonMap("magic", 42L));
        SourceRecord transformedRecord = (SourceRecord)this.xformKey.apply((ConnectRecord)record);
        Assert.assertSame((Object)record, (Object)transformedRecord);
    }
}

