/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.Flatten;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FlattenTest {
    private final Flatten<SourceRecord> xformKey = new Flatten.Key();
    private final Flatten<SourceRecord> xformValue = new Flatten.Value();

    @After
    public void teardown() {
        this.xformKey.close();
        this.xformValue.close();
    }

    @Test(expected=DataException.class)
    public void topLevelStructRequired() {
        this.xformValue.configure(Collections.emptyMap());
        this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
    }

    @Test(expected=DataException.class)
    public void topLevelMapRequired() {
        this.xformValue.configure(Collections.emptyMap());
        this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
    }

    @Test
    public void testNestedStruct() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.field("int8", Schema.INT8_SCHEMA);
        builder.field("int16", Schema.INT16_SCHEMA);
        builder.field("int32", Schema.INT32_SCHEMA);
        builder.field("int64", Schema.INT64_SCHEMA);
        builder.field("float32", Schema.FLOAT32_SCHEMA);
        builder.field("float64", Schema.FLOAT64_SCHEMA);
        builder.field("boolean", Schema.BOOLEAN_SCHEMA);
        builder.field("string", Schema.STRING_SCHEMA);
        builder.field("bytes", Schema.BYTES_SCHEMA);
        Schema supportedTypesSchema = builder.build();
        builder = SchemaBuilder.struct();
        builder.field("B", supportedTypesSchema);
        Schema oneLevelNestedSchema = builder.build();
        builder = SchemaBuilder.struct();
        builder.field("A", oneLevelNestedSchema);
        Schema twoLevelNestedSchema = builder.build();
        Struct supportedTypes = new Struct(supportedTypesSchema);
        supportedTypes.put("int8", (Object)8);
        supportedTypes.put("int16", (Object)16);
        supportedTypes.put("int32", (Object)32);
        supportedTypes.put("int64", (Object)64L);
        supportedTypes.put("float32", (Object)Float.valueOf(32.0f));
        supportedTypes.put("float64", (Object)64.0);
        supportedTypes.put("boolean", (Object)true);
        supportedTypes.put("string", (Object)"stringy");
        supportedTypes.put("bytes", (Object)"bytes".getBytes());
        Struct oneLevelNestedStruct = new Struct(oneLevelNestedSchema);
        oneLevelNestedStruct.put("B", (Object)supportedTypes);
        Struct twoLevelNestedStruct = new Struct(twoLevelNestedSchema);
        twoLevelNestedStruct.put("A", (Object)oneLevelNestedStruct);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), twoLevelNestedSchema, (Object)twoLevelNestedStruct));
        Assert.assertEquals((Object)Schema.Type.STRUCT, (Object)transformed.valueSchema().type());
        Struct transformedStruct = (Struct)transformed.value();
        Assert.assertEquals((long)9L, (long)transformedStruct.schema().fields().size());
        Assert.assertEquals((long)8L, (long)transformedStruct.getInt8("A.B.int8").byteValue());
        Assert.assertEquals((long)16L, (long)transformedStruct.getInt16("A.B.int16").shortValue());
        Assert.assertEquals((long)32L, (long)transformedStruct.getInt32("A.B.int32").intValue());
        Assert.assertEquals((long)64L, (long)transformedStruct.getInt64("A.B.int64"));
        Assert.assertEquals((float)32.0f, (float)transformedStruct.getFloat32("A.B.float32").floatValue(), (float)0.0f);
        Assert.assertEquals((double)64.0, (double)transformedStruct.getFloat64("A.B.float64"), (double)0.0);
        Assert.assertEquals((Object)true, (Object)transformedStruct.getBoolean("A.B.boolean"));
        Assert.assertEquals((Object)"stringy", (Object)transformedStruct.getString("A.B.string"));
        Assert.assertArrayEquals((byte[])"bytes".getBytes(), (byte[])transformedStruct.getBytes("A.B.bytes"));
    }

    @Test
    public void testNestedMapWithDelimiter() {
        this.xformValue.configure(Collections.singletonMap("delimiter", "#"));
        HashMap<String, Object> supportedTypes = new HashMap<String, Object>();
        supportedTypes.put("int8", (byte)8);
        supportedTypes.put("int16", (short)16);
        supportedTypes.put("int32", 32);
        supportedTypes.put("int64", 64L);
        supportedTypes.put("float32", Float.valueOf(32.0f));
        supportedTypes.put("float64", 64.0);
        supportedTypes.put("boolean", true);
        supportedTypes.put("string", "stringy");
        supportedTypes.put("bytes", "bytes".getBytes());
        Map oneLevelNestedMap = Collections.singletonMap("B", supportedTypes);
        Map twoLevelNestedMap = Collections.singletonMap("A", oneLevelNestedMap);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, twoLevelNestedMap));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertTrue((boolean)(transformed.value() instanceof Map));
        Map transformedMap = (Map)transformed.value();
        Assert.assertEquals((long)9L, (long)transformedMap.size());
        Assert.assertEquals((Object)8, transformedMap.get("A#B#int8"));
        Assert.assertEquals((Object)16, transformedMap.get("A#B#int16"));
        Assert.assertEquals((Object)32, transformedMap.get("A#B#int32"));
        Assert.assertEquals((Object)64L, transformedMap.get("A#B#int64"));
        Assert.assertEquals((float)32.0f, (float)((Float)transformedMap.get("A#B#float32")).floatValue(), (float)0.0f);
        Assert.assertEquals((double)64.0, (double)((Double)transformedMap.get("A#B#float64")), (double)0.0);
        Assert.assertEquals((Object)true, transformedMap.get("A#B#boolean"));
        Assert.assertEquals((Object)"stringy", transformedMap.get("A#B#string"));
        Assert.assertArrayEquals((byte[])"bytes".getBytes(), (byte[])((byte[])transformedMap.get("A#B#bytes")));
    }

    @Test
    public void testOptionalFieldStruct() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.field("opt_int32", Schema.OPTIONAL_INT32_SCHEMA);
        Schema supportedTypesSchema = builder.build();
        builder = SchemaBuilder.struct();
        builder.field("B", supportedTypesSchema);
        Schema oneLevelNestedSchema = builder.build();
        Struct supportedTypes = new Struct(supportedTypesSchema);
        supportedTypes.put("opt_int32", null);
        Struct oneLevelNestedStruct = new Struct(oneLevelNestedSchema);
        oneLevelNestedStruct.put("B", (Object)supportedTypes);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), oneLevelNestedSchema, (Object)oneLevelNestedStruct));
        Assert.assertEquals((Object)Schema.Type.STRUCT, (Object)transformed.valueSchema().type());
        Struct transformedStruct = (Struct)transformed.value();
        Assert.assertNull((Object)transformedStruct.get("B.opt_int32"));
    }

    @Test
    public void testOptionalStruct() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct().optional();
        builder.field("opt_int32", Schema.OPTIONAL_INT32_SCHEMA);
        Schema schema = builder.build();
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), schema, null));
        Assert.assertEquals((Object)Schema.Type.STRUCT, (Object)transformed.valueSchema().type());
        Assert.assertNull((Object)transformed.value());
    }

    @Test
    public void testOptionalNestedStruct() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct().optional();
        builder.field("opt_int32", Schema.OPTIONAL_INT32_SCHEMA);
        Schema supportedTypesSchema = builder.build();
        builder = SchemaBuilder.struct();
        builder.field("B", supportedTypesSchema);
        Schema oneLevelNestedSchema = builder.build();
        Struct oneLevelNestedStruct = new Struct(oneLevelNestedSchema);
        oneLevelNestedStruct.put("B", null);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), oneLevelNestedSchema, (Object)oneLevelNestedStruct));
        Assert.assertEquals((Object)Schema.Type.STRUCT, (Object)transformed.valueSchema().type());
        Struct transformedStruct = (Struct)transformed.value();
        Assert.assertNull((Object)transformedStruct.get("B.opt_int32"));
    }

    @Test
    public void testOptionalFieldMap() {
        this.xformValue.configure(Collections.emptyMap());
        HashMap<String, Object> supportedTypes = new HashMap<String, Object>();
        supportedTypes.put("opt_int32", null);
        Map oneLevelNestedMap = Collections.singletonMap("B", supportedTypes);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, oneLevelNestedMap));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertTrue((boolean)(transformed.value() instanceof Map));
        Map transformedMap = (Map)transformed.value();
        Assert.assertNull(transformedMap.get("B.opt_int32"));
    }

    @Test
    public void testKey() {
        this.xformKey.configure(Collections.emptyMap());
        Map<String, Map<String, Integer>> key = Collections.singletonMap("A", Collections.singletonMap("B", 12));
        SourceRecord src = new SourceRecord(null, null, "topic", null, key, null, null);
        SourceRecord transformed = (SourceRecord)this.xformKey.apply((ConnectRecord)src);
        Assert.assertNull((Object)transformed.keySchema());
        Assert.assertTrue((boolean)(transformed.key() instanceof Map));
        Map transformedMap = (Map)transformed.key();
        Assert.assertEquals((Object)12, transformedMap.get("A.B"));
    }

    @Test(expected=DataException.class)
    public void testUnsupportedTypeInMap() {
        this.xformValue.configure(Collections.emptyMap());
        Map<String, List<String>> value = Collections.singletonMap("foo", Arrays.asList("bar", "baz"));
        this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, value));
    }

    @Test
    public void testOptionalAndDefaultValuesNested() {
        this.xformValue.configure(Collections.emptyMap());
        SchemaBuilder builder = SchemaBuilder.struct().optional();
        builder.field("req_field", Schema.STRING_SCHEMA);
        builder.field("opt_field", SchemaBuilder.string().optional().defaultValue((Object)"child_default").build());
        Struct childDefaultValue = new Struct((Schema)builder);
        childDefaultValue.put("req_field", (Object)"req_default");
        builder.defaultValue((Object)childDefaultValue);
        Schema schema = builder.build();
        Struct value = new Struct(schema);
        SourceRecord transformed = (SourceRecord)this.xformValue.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), schema, (Object)value));
        Assert.assertNotNull((Object)transformed);
        Schema transformedSchema = transformed.valueSchema();
        Assert.assertEquals((Object)Schema.Type.STRUCT, (Object)transformedSchema.type());
        Assert.assertEquals((long)2L, (long)transformedSchema.fields().size());
        Schema transformedReqFieldSchema = SchemaBuilder.string().optional().defaultValue((Object)"req_default").build();
        Assert.assertEquals((Object)transformedReqFieldSchema, (Object)transformedSchema.field("req_field").schema());
        Schema transformedOptFieldSchema = SchemaBuilder.string().optional().defaultValue((Object)"child_default").build();
        Assert.assertEquals((Object)transformedOptFieldSchema, (Object)transformedSchema.field("opt_field").schema());
    }

    @Test
    public void tombstoneEventWithoutSchemaShouldPassThrough() {
        this.xformValue.configure(Collections.emptyMap());
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), null, null);
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assert.assertEquals(null, (Object)transformedRecord.value());
        Assert.assertEquals(null, (Object)transformedRecord.valueSchema());
    }

    @Test
    public void tombstoneEventWithSchemaShouldPassThrough() {
        this.xformValue.configure(Collections.emptyMap());
        Schema simpleStructSchema = SchemaBuilder.struct().name("name").version(Integer.valueOf(1)).doc("doc").field("magic", Schema.OPTIONAL_INT64_SCHEMA).build();
        SourceRecord record = new SourceRecord(null, null, "test", Integer.valueOf(0), simpleStructSchema, null);
        SourceRecord transformedRecord = (SourceRecord)this.xformValue.apply((ConnectRecord)record);
        Assert.assertEquals(null, (Object)transformedRecord.value());
        Assert.assertEquals((Object)simpleStructSchema, (Object)transformedRecord.valueSchema());
    }
}

