/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.ReplaceField;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ReplaceFieldTest {
    private ReplaceField<SinkRecord> xform = new ReplaceField.Value();

    @After
    public void teardown() {
        this.xform.close();
    }

    @Test
    public void tombstoneSchemaless() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("whitelist", "abc,foo");
        props.put("renames", "abc:xyz,foo:bar");
        this.xform.configure(props);
        SinkRecord record = new SinkRecord("test", 0, null, null, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assert.assertNull((Object)transformedRecord.value());
        Assert.assertNull((Object)transformedRecord.valueSchema());
    }

    @Test
    public void tombstoneWithSchema() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("whitelist", "abc,foo");
        props.put("renames", "abc:xyz,foo:bar");
        this.xform.configure(props);
        Schema schema = SchemaBuilder.struct().field("dont", Schema.STRING_SCHEMA).field("abc", Schema.INT32_SCHEMA).field("foo", Schema.BOOLEAN_SCHEMA).field("etc", Schema.STRING_SCHEMA).build();
        SinkRecord record = new SinkRecord("test", 0, null, null, schema, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assert.assertNull((Object)transformedRecord.value());
        Assert.assertEquals((Object)schema, (Object)transformedRecord.valueSchema());
    }

    @Test
    public void schemaless() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("blacklist", "dont");
        props.put("renames", "abc:xyz,foo:bar");
        this.xform.configure(props);
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("dont", "whatever");
        value.put("abc", 42);
        value.put("foo", true);
        value.put("etc", "etc");
        SinkRecord record = new SinkRecord("test", 0, null, null, null, value, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Map updatedValue = (Map)transformedRecord.value();
        Assert.assertEquals((long)3L, (long)updatedValue.size());
        Assert.assertEquals((Object)42, updatedValue.get("xyz"));
        Assert.assertEquals((Object)true, updatedValue.get("bar"));
        Assert.assertEquals((Object)"etc", updatedValue.get("etc"));
    }

    @Test
    public void withSchema() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("whitelist", "abc,foo");
        props.put("renames", "abc:xyz,foo:bar");
        this.xform.configure(props);
        Schema schema = SchemaBuilder.struct().field("dont", Schema.STRING_SCHEMA).field("abc", Schema.INT32_SCHEMA).field("foo", Schema.BOOLEAN_SCHEMA).field("etc", Schema.STRING_SCHEMA).build();
        Struct value = new Struct(schema);
        value.put("dont", (Object)"whatever");
        value.put("abc", (Object)42);
        value.put("foo", (Object)true);
        value.put("etc", (Object)"etc");
        SinkRecord record = new SinkRecord("test", 0, null, null, schema, (Object)value, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Struct updatedValue = (Struct)transformedRecord.value();
        Assert.assertEquals((long)2L, (long)updatedValue.schema().fields().size());
        Assert.assertEquals((Object)new Integer(42), (Object)updatedValue.getInt32("xyz"));
        Assert.assertEquals((Object)true, (Object)updatedValue.getBoolean("bar"));
    }
}

