/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.MaskField;
import org.junit.Assert;
import org.junit.Test;

public class MaskFieldTest {
    private static MaskField<SinkRecord> transform(List<String> fields) {
        MaskField.Value xform = new MaskField.Value();
        xform.configure(Collections.singletonMap("fields", fields));
        return xform;
    }

    private static SinkRecord record(Schema schema, Object value) {
        return new SinkRecord("", 0, null, null, schema, value, 0L);
    }

    @Test
    public void schemaless() {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("magic", 42);
        value.put("bool", true);
        value.put("byte", (byte)42);
        value.put("short", (short)42);
        value.put("int", 42);
        value.put("long", 42L);
        value.put("float", Float.valueOf(42.0f));
        value.put("double", 42.0);
        value.put("string", "blabla");
        value.put("date", new Date());
        value.put("bigint", new BigInteger("42"));
        value.put("bigdec", new BigDecimal("42.0"));
        value.put("list", Collections.singletonList(42));
        value.put("map", Collections.singletonMap("key", "value"));
        ArrayList<String> maskFields = new ArrayList<String>(value.keySet());
        maskFields.remove("magic");
        Map updatedValue = (Map)((SinkRecord)MaskFieldTest.transform(maskFields).apply((ConnectRecord)MaskFieldTest.record(null, value))).value();
        Assert.assertEquals((Object)42, updatedValue.get("magic"));
        Assert.assertEquals((Object)false, updatedValue.get("bool"));
        Assert.assertEquals((Object)0, updatedValue.get("byte"));
        Assert.assertEquals((Object)0, updatedValue.get("short"));
        Assert.assertEquals((Object)0, updatedValue.get("int"));
        Assert.assertEquals((Object)0L, updatedValue.get("long"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), updatedValue.get("float"));
        Assert.assertEquals((Object)0.0, updatedValue.get("double"));
        Assert.assertEquals((Object)"", updatedValue.get("string"));
        Assert.assertEquals((Object)new Date(0L), updatedValue.get("date"));
        Assert.assertEquals((Object)BigInteger.ZERO, updatedValue.get("bigint"));
        Assert.assertEquals((Object)BigDecimal.ZERO, updatedValue.get("bigdec"));
        Assert.assertEquals(Collections.emptyList(), updatedValue.get("list"));
        Assert.assertEquals(Collections.emptyMap(), updatedValue.get("map"));
    }

    @Test
    public void withSchema() {
        Schema schema = SchemaBuilder.struct().field("magic", Schema.INT32_SCHEMA).field("bool", Schema.BOOLEAN_SCHEMA).field("byte", Schema.INT8_SCHEMA).field("short", Schema.INT16_SCHEMA).field("int", Schema.INT32_SCHEMA).field("long", Schema.INT64_SCHEMA).field("float", Schema.FLOAT32_SCHEMA).field("double", Schema.FLOAT64_SCHEMA).field("string", Schema.STRING_SCHEMA).field("date", org.apache.kafka.connect.data.Date.SCHEMA).field("time", Time.SCHEMA).field("timestamp", Timestamp.SCHEMA).field("decimal", Decimal.schema((int)0)).field("array", (Schema)SchemaBuilder.array((Schema)Schema.INT32_SCHEMA)).field("map", (Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA)).build();
        Struct value = new Struct(schema);
        value.put("magic", (Object)42);
        value.put("bool", (Object)true);
        value.put("byte", (Object)42);
        value.put("short", (Object)42);
        value.put("int", (Object)42);
        value.put("long", (Object)42L);
        value.put("float", (Object)Float.valueOf(42.0f));
        value.put("double", (Object)42.0);
        value.put("string", (Object)"hmm");
        value.put("date", (Object)new Date());
        value.put("time", (Object)new Date());
        value.put("timestamp", (Object)new Date());
        value.put("decimal", (Object)new BigDecimal(42));
        value.put("array", Arrays.asList(1, 2, 3));
        value.put("map", Collections.singletonMap("what", "what"));
        ArrayList<String> maskFields = new ArrayList<String>(schema.fields().size());
        for (Field field : schema.fields()) {
            if (field.name().equals("magic")) continue;
            maskFields.add(field.name());
        }
        Struct updatedValue = (Struct)((SinkRecord)MaskFieldTest.transform(maskFields).apply((ConnectRecord)MaskFieldTest.record(schema, value))).value();
        Assert.assertEquals((Object)42, (Object)updatedValue.get("magic"));
        Assert.assertEquals((Object)false, (Object)updatedValue.get("bool"));
        Assert.assertEquals((Object)0, (Object)updatedValue.get("byte"));
        Assert.assertEquals((Object)0, (Object)updatedValue.get("short"));
        Assert.assertEquals((Object)0, (Object)updatedValue.get("int"));
        Assert.assertEquals((Object)0L, (Object)updatedValue.get("long"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)updatedValue.get("float"));
        Assert.assertEquals((Object)0.0, (Object)updatedValue.get("double"));
        Assert.assertEquals((Object)"", (Object)updatedValue.get("string"));
        Assert.assertEquals((Object)new Date(0L), (Object)updatedValue.get("date"));
        Assert.assertEquals((Object)new Date(0L), (Object)updatedValue.get("time"));
        Assert.assertEquals((Object)new Date(0L), (Object)updatedValue.get("timestamp"));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)updatedValue.get("decimal"));
        Assert.assertEquals(Collections.emptyList(), (Object)updatedValue.get("array"));
        Assert.assertEquals(Collections.emptyMap(), (Object)updatedValue.get("map"));
    }
}

