/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.HoistField;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class HoistFieldTest {
    private final HoistField<SinkRecord> xform = new HoistField.Key();

    @After
    public void teardown() {
        this.xform.close();
    }

    @Test
    public void schemaless() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        SinkRecord record = new SinkRecord("test", 0, null, (Object)42, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assert.assertNull((Object)transformedRecord.keySchema());
        Assert.assertEquals(Collections.singletonMap("magic", 42), (Object)transformedRecord.key());
    }

    @Test
    public void withSchema() {
        this.xform.configure(Collections.singletonMap("field", "magic"));
        SinkRecord record = new SinkRecord("test", 0, Schema.INT32_SCHEMA, (Object)42, null, null, 0L);
        SinkRecord transformedRecord = (SinkRecord)this.xform.apply((ConnectRecord)record);
        Assert.assertEquals((Object)Schema.Type.STRUCT, (Object)transformedRecord.keySchema().type());
        Assert.assertEquals((Object)record.keySchema(), (Object)transformedRecord.keySchema().field("magic").schema());
        Assert.assertEquals((Object)42, (Object)((Struct)transformedRecord.key()).get("magic"));
    }
}

