/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.ValueToKey;
import org.junit.Assert;
import org.junit.Test;

public class ValueToKeyTest {
    @Test
    public void schemaless() {
        ValueToKey xform = new ValueToKey();
        xform.configure(Collections.singletonMap("fields", "a,b"));
        HashMap<String, Integer> value = new HashMap<String, Integer>();
        value.put("a", 1);
        value.put("b", 2);
        value.put("c", 3);
        SinkRecord record = new SinkRecord("", 0, null, null, null, value, 0L);
        SinkRecord transformedRecord = (SinkRecord)xform.apply((ConnectRecord)record);
        HashMap<String, Integer> expectedKey = new HashMap<String, Integer>();
        expectedKey.put("a", 1);
        expectedKey.put("b", 2);
        Assert.assertNull((Object)transformedRecord.keySchema());
        Assert.assertEquals(expectedKey, (Object)transformedRecord.key());
    }

    @Test
    public void withSchema() {
        ValueToKey xform = new ValueToKey();
        xform.configure(Collections.singletonMap("fields", "a,b"));
        Schema valueSchema = SchemaBuilder.struct().field("a", Schema.INT32_SCHEMA).field("b", Schema.INT32_SCHEMA).field("c", Schema.INT32_SCHEMA).build();
        Struct value = new Struct(valueSchema);
        value.put("a", (Object)1);
        value.put("b", (Object)2);
        value.put("c", (Object)3);
        SinkRecord record = new SinkRecord("", 0, null, null, valueSchema, (Object)value, 0L);
        SinkRecord transformedRecord = (SinkRecord)xform.apply((ConnectRecord)record);
        Schema expectedKeySchema = SchemaBuilder.struct().field("a", Schema.INT32_SCHEMA).field("b", Schema.INT32_SCHEMA).build();
        Struct expectedKey = new Struct(expectedKeySchema).put("a", (Object)1).put("b", (Object)2);
        Assert.assertEquals((Object)expectedKeySchema, (Object)transformedRecord.keySchema());
        Assert.assertEquals((Object)expectedKey, (Object)transformedRecord.key());
    }
}

