/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.TimestampConverter;
import org.junit.Assert;
import org.junit.Test;

public class TimestampConverterTest {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Calendar EPOCH = GregorianCalendar.getInstance(UTC);
    private static final Calendar TIME;
    private static final Calendar DATE;
    private static final Calendar DATE_PLUS_TIME;
    private static final long DATE_PLUS_TIME_UNIX;
    private static final String STRING_DATE_FMT = "yyyy MM dd HH mm ss SSS z";
    private static final String DATE_PLUS_TIME_STRING;

    @Test(expected=ConfigException.class)
    public void testConfigNoTargetType() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.emptyMap());
    }

    @Test(expected=ConfigException.class)
    public void testConfigInvalidTargetType() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "invalid"));
    }

    @Test(expected=ConfigException.class)
    public void testConfigMissingFormat() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "string"));
    }

    @Test(expected=ConfigException.class)
    public void testConfigInvalidFormat() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "string");
        config.put("format", "bad-format");
        xform.configure(config);
    }

    @Test
    public void testSchemalessIdentity() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimestampToDate() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Date"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimestampToTime() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Time"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimestampToUnix() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "unix"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME_UNIX, (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimestampToString() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "string");
        config.put("format", STRING_DATE_FMT);
        xform.configure(config);
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME_STRING, (Object)transformed.value());
    }

    @Test
    public void testSchemalessDateToTimestamp() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE.getTime()));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessTimeToTimestamp() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)TIME.getTime()));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessUnixToTimestamp() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME_UNIX));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessStringToTimestamp() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("format", STRING_DATE_FMT);
        xform.configure(config);
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME_STRING));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaIdentity() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Timestamp.SCHEMA, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimestampToDate() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Date"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Timestamp.SCHEMA, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertEquals((Object)org.apache.kafka.connect.data.Date.SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimestampToTime() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Time"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Timestamp.SCHEMA, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertEquals((Object)Time.SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimestampToUnix() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "unix"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Timestamp.SCHEMA, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertEquals((Object)Schema.INT64_SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME_UNIX, (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimestampToString() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "string");
        config.put("format", STRING_DATE_FMT);
        xform.configure(config);
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Timestamp.SCHEMA, (Object)DATE_PLUS_TIME.getTime()));
        Assert.assertEquals((Object)Schema.STRING_SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME_STRING, (Object)transformed.value());
    }

    @Test
    public void testWithSchemaDateToTimestamp() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), org.apache.kafka.connect.data.Date.SCHEMA, (Object)DATE.getTime()));
        Assert.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaTimeToTimestamp() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Time.SCHEMA, (Object)TIME.getTime()));
        Assert.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaUnixToTimestamp() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT64_SCHEMA, (Object)DATE_PLUS_TIME_UNIX));
        Assert.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaStringToTimestamp() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("format", STRING_DATE_FMT);
        xform.configure(config);
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.STRING_SCHEMA, (Object)DATE_PLUS_TIME_STRING));
        Assert.assertEquals((Object)Timestamp.SCHEMA, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.value());
    }

    @Test
    public void testSchemalessFieldConversion() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Date");
        config.put("field", "ts");
        xform.configure(config);
        Map<String, Date> value = Collections.singletonMap("ts", DATE_PLUS_TIME.getTime());
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, value));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals(Collections.singletonMap("ts", DATE.getTime()), (Object)transformed.value());
    }

    @Test
    public void testWithSchemaFieldConversion() {
        TimestampConverter.Value xform = new TimestampConverter.Value();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("target.type", "Timestamp");
        config.put("field", "ts");
        xform.configure(config);
        Schema structWithTimestampFieldSchema = SchemaBuilder.struct().field("ts", Schema.INT64_SCHEMA).field("other", Schema.STRING_SCHEMA).build();
        Struct original = new Struct(structWithTimestampFieldSchema);
        original.put("ts", (Object)DATE_PLUS_TIME_UNIX);
        original.put("other", (Object)"test");
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), structWithTimestampFieldSchema, (Object)original));
        Schema expectedSchema = SchemaBuilder.struct().field("ts", Timestamp.SCHEMA).field("other", Schema.STRING_SCHEMA).build();
        Assert.assertEquals((Object)expectedSchema, (Object)transformed.valueSchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)((Struct)transformed.value()).get("ts"));
        Assert.assertEquals((Object)"test", (Object)((Struct)transformed.value()).get("other"));
    }

    @Test
    public void testKey() {
        TimestampConverter.Key xform = new TimestampConverter.Key();
        xform.configure(Collections.singletonMap("target.type", "Timestamp"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)DATE_PLUS_TIME.getTime(), null, null));
        Assert.assertNull((Object)transformed.keySchema());
        Assert.assertEquals((Object)DATE_PLUS_TIME.getTime(), (Object)transformed.key());
    }

    static {
        EPOCH.setTimeInMillis(0L);
        TIME = GregorianCalendar.getInstance(UTC);
        TIME.setTimeInMillis(0L);
        TIME.add(14, 1234);
        DATE = GregorianCalendar.getInstance(UTC);
        DATE.setTimeInMillis(0L);
        DATE.set(1970, 0, 1, 0, 0, 0);
        DATE.add(5, 1);
        DATE_PLUS_TIME = GregorianCalendar.getInstance(UTC);
        DATE_PLUS_TIME.setTimeInMillis(0L);
        DATE_PLUS_TIME.add(5, 1);
        DATE_PLUS_TIME.add(14, 1234);
        DATE_PLUS_TIME_UNIX = DATE_PLUS_TIME.getTime().getTime();
        DATE_PLUS_TIME_STRING = "1970 01 02 00 00 01 234 UTC";
    }
}

