/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.Cast;
import org.junit.Assert;
import org.junit.Test;

public class CastTest {
    @Test(expected=ConfigException.class)
    public void testConfigEmpty() {
        Cast.Key xform = new Cast.Key();
        xform.configure(Collections.singletonMap("spec", ""));
    }

    @Test(expected=ConfigException.class)
    public void testConfigInvalidSchemaType() {
        Cast.Key xform = new Cast.Key();
        xform.configure(Collections.singletonMap("spec", "foo:faketype"));
    }

    @Test(expected=ConfigException.class)
    public void testConfigInvalidTargetType() {
        Cast.Key xform = new Cast.Key();
        xform.configure(Collections.singletonMap("spec", "foo:array"));
    }

    @Test(expected=ConfigException.class)
    public void testConfigInvalidMap() {
        Cast.Key xform = new Cast.Key();
        xform.configure(Collections.singletonMap("spec", "foo:int8:extra"));
    }

    @Test(expected=ConfigException.class)
    public void testConfigMixWholeAndFieldTransformation() {
        Cast.Key xform = new Cast.Key();
        xform.configure(Collections.singletonMap("spec", "foo:int8,int32"));
    }

    @Test
    public void castWholeRecordKeyWithSchema() {
        Cast.Key xform = new Cast.Key();
        xform.configure(Collections.singletonMap("spec", "int8"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42, Schema.STRING_SCHEMA, (Object)"bogus"));
        Assert.assertEquals((Object)Schema.Type.INT8, (Object)transformed.keySchema().type());
        Assert.assertEquals((Object)42, (Object)transformed.key());
    }

    @Test
    public void castWholeRecordValueWithSchemaInt8() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int8"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assert.assertEquals((Object)Schema.Type.INT8, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaInt16() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int16"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assert.assertEquals((Object)Schema.Type.INT16, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaInt32() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int32"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assert.assertEquals((Object)Schema.Type.INT32, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaInt64() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int64"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assert.assertEquals((Object)Schema.Type.INT64, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)42L, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaFloat32() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "float32"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assert.assertEquals((Object)Schema.Type.FLOAT32, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaFloat64() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "float64"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assert.assertEquals((Object)Schema.Type.FLOAT64, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)42.0, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaBooleanTrue() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "boolean"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assert.assertEquals((Object)Schema.Type.BOOLEAN, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)true, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaBooleanFalse() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "boolean"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)0));
        Assert.assertEquals((Object)Schema.Type.BOOLEAN, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)false, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueWithSchemaString() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "string"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), Schema.INT32_SCHEMA, (Object)42));
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)"42", (Object)transformed.value());
    }

    @Test
    public void castWholeRecordDefaultValue() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int32"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), SchemaBuilder.float32().defaultValue((Object)Float.valueOf(-42.125f)).build(), (Object)Float.valueOf(42.125f)));
        Assert.assertEquals((Object)Schema.Type.INT32, (Object)transformed.valueSchema().type());
        Assert.assertEquals((Object)42, (Object)transformed.value());
        Assert.assertEquals((Object)-42, (Object)transformed.valueSchema().defaultValue());
    }

    @Test
    public void castWholeRecordKeySchemaless() {
        Cast.Key xform = new Cast.Key();
        xform.configure(Collections.singletonMap("spec", "int8"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42, Schema.STRING_SCHEMA, (Object)"bogus"));
        Assert.assertNull((Object)transformed.keySchema());
        Assert.assertEquals((Object)42, (Object)transformed.key());
    }

    @Test
    public void castWholeRecordValueSchemalessInt8() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int8"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessInt16() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int16"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessInt32() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int32"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)42, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessInt64() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int64"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)42L, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessFloat32() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "float32"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessFloat64() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "float64"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)42.0, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessBooleanTrue() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "boolean"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)true, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessBooleanFalse() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "boolean"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)0));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)false, (Object)transformed.value());
    }

    @Test
    public void castWholeRecordValueSchemalessString() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "string"));
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, (Object)42));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)"42", (Object)transformed.value());
    }

    @Test(expected=DataException.class)
    public void castWholeRecordValueSchemalessUnsupportedType() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int8"));
        xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, Collections.singletonList("foo")));
    }

    @Test
    public void castFieldsWithSchema() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int8:int16,int16:int32,int32:int64,int64:boolean,float32:float64,float64:boolean,boolean:int8,string:int32,optional:int32"));
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.field("int8", Schema.INT8_SCHEMA);
        builder.field("int16", Schema.OPTIONAL_INT16_SCHEMA);
        builder.field("int32", SchemaBuilder.int32().defaultValue((Object)2).build());
        builder.field("int64", Schema.INT64_SCHEMA);
        builder.field("float32", Schema.FLOAT32_SCHEMA);
        builder.field("float64", SchemaBuilder.float64().defaultValue((Object)-1.125).build());
        builder.field("boolean", Schema.BOOLEAN_SCHEMA);
        builder.field("string", Schema.STRING_SCHEMA);
        builder.field("optional", Schema.OPTIONAL_FLOAT32_SCHEMA);
        Schema supportedTypesSchema = builder.build();
        Struct recordValue = new Struct(supportedTypesSchema);
        recordValue.put("int8", (Object)8);
        recordValue.put("int16", (Object)16);
        recordValue.put("int32", (Object)32);
        recordValue.put("int64", (Object)64L);
        recordValue.put("float32", (Object)Float.valueOf(32.0f));
        recordValue.put("float64", (Object)-64.0);
        recordValue.put("boolean", (Object)true);
        recordValue.put("string", (Object)"42");
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), supportedTypesSchema, (Object)recordValue));
        Assert.assertEquals((Object)8, (Object)((Struct)transformed.value()).get("int8"));
        Assert.assertTrue((boolean)((Struct)transformed.value()).schema().field("int16").schema().isOptional());
        Assert.assertEquals((Object)16, (Object)((Struct)transformed.value()).get("int16"));
        Assert.assertEquals((Object)32L, (Object)((Struct)transformed.value()).get("int32"));
        Assert.assertEquals((Object)2L, (Object)((Struct)transformed.value()).schema().field("int32").schema().defaultValue());
        Assert.assertEquals((Object)true, (Object)((Struct)transformed.value()).get("int64"));
        Assert.assertEquals((Object)32.0, (Object)((Struct)transformed.value()).get("float32"));
        Assert.assertEquals((Object)true, (Object)((Struct)transformed.value()).get("float64"));
        Assert.assertEquals((Object)true, (Object)((Struct)transformed.value()).schema().field("float64").schema().defaultValue());
        Assert.assertEquals((Object)1, (Object)((Struct)transformed.value()).get("boolean"));
        Assert.assertEquals((Object)42, (Object)((Struct)transformed.value()).get("string"));
        Assert.assertNull((Object)((Struct)transformed.value()).get("optional"));
    }

    @Test
    public void castFieldsSchemaless() {
        Cast.Value xform = new Cast.Value();
        xform.configure(Collections.singletonMap("spec", "int8:int16,int16:int32,int32:int64,int64:boolean,float32:float64,float64:boolean,boolean:int8,string:int32"));
        HashMap<String, Object> recordValue = new HashMap<String, Object>();
        recordValue.put("int8", (byte)8);
        recordValue.put("int16", (short)16);
        recordValue.put("int32", 32);
        recordValue.put("int64", 64L);
        recordValue.put("float32", Float.valueOf(32.0f));
        recordValue.put("float64", -64.0);
        recordValue.put("boolean", true);
        recordValue.put("string", "42");
        SourceRecord transformed = (SourceRecord)xform.apply((ConnectRecord)new SourceRecord(null, null, "topic", Integer.valueOf(0), null, recordValue));
        Assert.assertNull((Object)transformed.valueSchema());
        Assert.assertEquals((Object)8, ((Map)transformed.value()).get("int8"));
        Assert.assertEquals((Object)16, ((Map)transformed.value()).get("int16"));
        Assert.assertEquals((Object)32L, ((Map)transformed.value()).get("int32"));
        Assert.assertEquals((Object)true, ((Map)transformed.value()).get("int64"));
        Assert.assertEquals((Object)32.0, ((Map)transformed.value()).get("float32"));
        Assert.assertEquals((Object)true, ((Map)transformed.value()).get("float64"));
        Assert.assertEquals((Object)1, ((Map)transformed.value()).get("boolean"));
        Assert.assertEquals((Object)42, ((Map)transformed.value()).get("string"));
    }
}

