/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.mirror.MirrorSourceConfig;
import org.apache.kafka.connect.mirror.MirrorSourceTaskConfig;
import org.apache.kafka.connect.mirror.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorSourceConfigTest {
    @Test
    public void testTaskConfigTopicPartitions() {
        List<TopicPartition> topicPartitions = Arrays.asList(new TopicPartition("topic-1", 2), new TopicPartition("topic-3", 4), new TopicPartition("topic-5", 6));
        MirrorSourceConfig config = new MirrorSourceConfig(TestUtils.makeProps(new String[0]));
        Map props = config.taskConfigForTopicPartitions(topicPartitions, 1);
        MirrorSourceTaskConfig taskConfig = new MirrorSourceTaskConfig(props);
        Assertions.assertEquals((Object)taskConfig.taskTopicPartitions(), new HashSet<TopicPartition>(topicPartitions), (String)"Setting topic property configuration failed");
    }

    @Test
    public void testTopicMatching() {
        MirrorSourceConfig config = new MirrorSourceConfig(TestUtils.makeProps("topics", "topic1"));
        Assertions.assertTrue((boolean)config.topicFilter().shouldReplicateTopic("topic1"), (String)"topic1 replication property configuration failed");
        Assertions.assertFalse((boolean)config.topicFilter().shouldReplicateTopic("topic2"), (String)"topic2 replication property configuration failed");
    }

    @Test
    public void testConfigPropertyMatching() {
        MirrorSourceConfig config = new MirrorSourceConfig(TestUtils.makeProps("config.properties.exclude", "prop2"));
        Assertions.assertTrue((boolean)config.configPropertyFilter().shouldReplicateConfigProperty("prop1"), (String)"config.properties.exclude incorrectly excluded prop1");
        Assertions.assertFalse((boolean)config.configPropertyFilter().shouldReplicateConfigProperty("prop2"), (String)"config.properties.exclude incorrectly included prop2");
    }

    @Test
    public void testConfigBackwardsCompatibility() {
        MirrorSourceConfig config = new MirrorSourceConfig(TestUtils.makeProps("config.properties.blacklist", "prop1", "topics.blacklist", "topic-1"));
        Assertions.assertFalse((boolean)config.configPropertyFilter().shouldReplicateConfigProperty("prop1"));
        Assertions.assertTrue((boolean)config.configPropertyFilter().shouldReplicateConfigProperty("prop2"));
        Assertions.assertFalse((boolean)config.topicFilter().shouldReplicateTopic("topic-1"));
        Assertions.assertTrue((boolean)config.topicFilter().shouldReplicateTopic("topic-2"));
    }

    @Test
    public void testNoTopics() {
        MirrorSourceConfig config = new MirrorSourceConfig(TestUtils.makeProps("topics", ""));
        Assertions.assertFalse((boolean)config.topicFilter().shouldReplicateTopic("topic1"), (String)"topic1 shouldn't exist");
        Assertions.assertFalse((boolean)config.topicFilter().shouldReplicateTopic("topic2"), (String)"topic2 shouldn't exist");
        Assertions.assertFalse((boolean)config.topicFilter().shouldReplicateTopic(""), (String)"Empty topic shouldn't exist");
    }

    @Test
    public void testAllTopics() {
        MirrorSourceConfig config = new MirrorSourceConfig(TestUtils.makeProps("topics", ".*"));
        Assertions.assertTrue((boolean)config.topicFilter().shouldReplicateTopic("topic1"), (String)"topic1 created from wildcard should exist");
        Assertions.assertTrue((boolean)config.topicFilter().shouldReplicateTopic("topic2"), (String)"topic2 created from wildcard should exist");
    }

    @Test
    public void testListOfTopics() {
        MirrorSourceConfig config = new MirrorSourceConfig(TestUtils.makeProps("topics", "topic1, topic2"));
        Assertions.assertTrue((boolean)config.topicFilter().shouldReplicateTopic("topic1"), (String)"topic1 created from list should exist");
        Assertions.assertTrue((boolean)config.topicFilter().shouldReplicateTopic("topic2"), (String)"topic2 created from list should exist");
        Assertions.assertFalse((boolean)config.topicFilter().shouldReplicateTopic("topic3"), (String)"topic3 created from list should exist");
    }

    @Test
    public void testNonMutationOfConfigDef() {
        ConfigDef taskConfigDef = MirrorSourceTaskConfig.TASK_CONFIG_DEF;
        Assertions.assertTrue((boolean)taskConfigDef.names().contains("task.assigned.partitions"), (String)"task.assigned.partitions should be defined for task ConfigDef");
        Assertions.assertFalse((boolean)MirrorSourceConfig.CONNECTOR_CONFIG_DEF.names().contains("task.assigned.partitions"), (String)"task.assigned.partitions should not be defined for connector ConfigDef");
    }

    @Test
    public void testOffsetSyncsTopic() {
        Map<String, String> connectorProps = TestUtils.makeProps("offset-syncs.topic.location", "something");
        Assertions.assertThrows(ConfigException.class, () -> new MirrorSourceConfig(connectorProps));
        connectorProps.put("offset-syncs.topic.location", "source");
        MirrorSourceConfig config = new MirrorSourceConfig(connectorProps);
        Assertions.assertEquals((Object)"mm2-offset-syncs.target2.internal", (Object)config.offsetSyncsTopic());
        connectorProps.put("offset-syncs.topic.location", "target");
        config = new MirrorSourceConfig(connectorProps);
        Assertions.assertEquals((Object)"mm2-offset-syncs.source1.internal", (Object)config.offsetSyncsTopic());
        connectorProps.remove("offset-syncs.topic.location");
        config = new MirrorSourceConfig(connectorProps);
        Assertions.assertEquals((Object)"mm2-offset-syncs.target2.internal", (Object)config.offsetSyncsTopic());
    }

    @Test
    public void testProducerConfigsForOffsetSyncsTopic() {
        Map<String, String> connectorProps = TestUtils.makeProps("source.producer.batch.size", "1", "target.producer.acks", "1", "producer.max.poll.interval.ms", "1", "fetch.min.bytes", "1");
        MirrorSourceConfig config = new MirrorSourceConfig(connectorProps);
        Map sourceProducerConfig = config.sourceProducerConfig("test");
        Map offsetSyncsTopicSourceProducerConfig = config.offsetSyncsTopicProducerConfig();
        TestUtils.assertEqualsExceptClientId(sourceProducerConfig, offsetSyncsTopicSourceProducerConfig);
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|test", sourceProducerConfig.get("client.id"));
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|offset-syncs-source-producer", offsetSyncsTopicSourceProducerConfig.get("client.id"));
        connectorProps.put("offset-syncs.topic.location", "target");
        config = new MirrorSourceConfig(connectorProps);
        Map targetProducerConfig = config.targetProducerConfig("test");
        Map offsetSyncsTopicTargetProducerConfig = config.offsetSyncsTopicProducerConfig();
        TestUtils.assertEqualsExceptClientId(targetProducerConfig, offsetSyncsTopicTargetProducerConfig);
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|test", targetProducerConfig.get("client.id"));
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|offset-syncs-target-producer", offsetSyncsTopicTargetProducerConfig.get("client.id"));
    }

    @Test
    public void testAdminConfigsForOffsetSyncsTopic() {
        Map<String, String> connectorProps = TestUtils.makeProps("source.admin.request.timeout.ms", "1", "target.admin.send.buffer.bytes", "1", "admin.reconnect.backoff.max.ms", "1", "retries", "123");
        MirrorSourceConfig config = new MirrorSourceConfig(connectorProps);
        Map sourceAdminConfig = config.sourceAdminConfig("test");
        Map offsetSyncsTopicSourceAdminConfig = config.offsetSyncsTopicAdminConfig();
        TestUtils.assertEqualsExceptClientId(sourceAdminConfig, offsetSyncsTopicSourceAdminConfig);
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|test", sourceAdminConfig.get("client.id"));
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|offset-syncs-source-admin", offsetSyncsTopicSourceAdminConfig.get("client.id"));
        connectorProps.put("offset-syncs.topic.location", "target");
        config = new MirrorSourceConfig(connectorProps);
        Map targetAdminConfig = config.targetAdminConfig("test");
        Map offsetSyncsTopicTargetAdminConfig = config.offsetSyncsTopicAdminConfig();
        TestUtils.assertEqualsExceptClientId(targetAdminConfig, offsetSyncsTopicTargetAdminConfig);
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|test", targetAdminConfig.get("client.id"));
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|offset-syncs-target-admin", offsetSyncsTopicTargetAdminConfig.get("client.id"));
    }
}

