/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.mirror.MirrorHeartbeatConfig;
import org.apache.kafka.connect.mirror.MirrorHeartbeatConnector;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorHeartBeatConnectorTest {
    private static final Map<String, ?> SOURCE_OFFSET = MirrorUtils.wrapOffset((long)0L);

    @Test
    public void testMirrorHeartbeatConnectorDisabled() {
        MirrorHeartbeatConfig config = new MirrorHeartbeatConfig(TestUtils.makeProps("emit.heartbeats.enabled", "false"));
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector(config);
        List output = connector.taskConfigs(1);
        Assertions.assertEquals((int)0, (int)output.size(), (String)"Expected task to not be created");
    }

    @Test
    public void testReplicationDisabled() {
        MirrorHeartbeatConfig config = new MirrorHeartbeatConfig(TestUtils.makeProps("enabled", "false"));
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector(config);
        List output = connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)output.size(), (String)"Task should have been created even with replication disabled");
    }

    @Test
    public void testAlterOffsetsIncorrectPartitionKey() {
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector();
        Assertions.assertThrows(ConnectException.class, () -> connector.alterOffsets(null, Collections.singletonMap(Collections.singletonMap("unused_partition_key", "unused_partition_value"), SOURCE_OFFSET)));
        Assertions.assertThrows(ConnectException.class, () -> connector.alterOffsets(null, Collections.singletonMap(null, SOURCE_OFFSET)));
    }

    @Test
    public void testAlterOffsetsMissingPartitionKey() {
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector();
        Function<Map, Boolean> alterOffsets = partition -> connector.alterOffsets(null, Collections.singletonMap(partition, SOURCE_OFFSET));
        Map<String, Object> validPartition = MirrorHeartBeatConnectorTest.sourcePartition("primary", "backup");
        Assertions.assertTrue((boolean)alterOffsets.apply(validPartition));
        for (String key : Arrays.asList("sourceClusterAlias", "targetClusterAlias")) {
            HashMap<String, Object> invalidPartition = new HashMap<String, Object>(validPartition);
            invalidPartition.remove(key);
            Assertions.assertThrows(ConnectException.class, () -> {
                Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply(invalidPartition);
            });
        }
    }

    @Test
    public void testAlterOffsetsMultiplePartitions() {
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector();
        Map<String, Object> partition1 = MirrorHeartBeatConnectorTest.sourcePartition("primary", "backup");
        Map<String, Object> partition2 = MirrorHeartBeatConnectorTest.sourcePartition("backup", "primary");
        HashMap offsets = new HashMap();
        offsets.put(partition1, SOURCE_OFFSET);
        offsets.put(partition2, SOURCE_OFFSET);
        Assertions.assertTrue((boolean)connector.alterOffsets(null, offsets));
    }

    @Test
    public void testAlterOffsetsIncorrectOffsetKey() {
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector();
        Map<Map<String, Object>, Map<String, Integer>> offsets = Collections.singletonMap(MirrorHeartBeatConnectorTest.sourcePartition("primary", "backup"), Collections.singletonMap("unused_offset_key", 0));
        Assertions.assertThrows(ConnectException.class, () -> connector.alterOffsets(null, offsets));
    }

    @Test
    public void testAlterOffsetsOffsetValues() {
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector();
        Function<Object, Boolean> alterOffsets = offset -> connector.alterOffsets(null, Collections.singletonMap(MirrorHeartBeatConnectorTest.sourcePartition("primary", "backup"), Collections.singletonMap("offset", offset)));
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply("nan");
        });
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply(null);
        });
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply(new Object());
        });
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply(3.14);
        });
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply(-420);
        });
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply("-420");
        });
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply("10");
        });
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply(10);
        });
        Assertions.assertThrows(ConnectException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)alterOffsets.apply(0x80000000L);
        });
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(0));
    }

    @Test
    public void testSuccessfulAlterOffsets() {
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector();
        Map<Map<String, Object>, Map<String, ?>> offsets = Collections.singletonMap(MirrorHeartBeatConnectorTest.sourcePartition("primary", "backup"), SOURCE_OFFSET);
        Assertions.assertTrue((boolean)connector.alterOffsets(null, offsets));
        Assertions.assertTrue((boolean)connector.alterOffsets(null, Collections.emptyMap()));
    }

    @Test
    public void testAlterOffsetsTombstones() {
        MirrorHeartbeatConnector connector = new MirrorHeartbeatConnector();
        Function<Map, Boolean> alterOffsets = partition -> connector.alterOffsets(null, Collections.singletonMap(partition, null));
        Map<String, Object> partition2 = MirrorHeartBeatConnectorTest.sourcePartition("src", "bak");
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(partition2));
        partition2.put("sourceClusterAlias", 618);
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(partition2));
        partition2.remove("sourceClusterAlias");
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(partition2));
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(null));
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(Collections.emptyMap()));
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(Collections.singletonMap("unused_partition_key", "unused_partition_value")));
    }

    private static Map<String, Object> sourcePartition(String sourceClusterAlias, String targetClusterAlias) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sourceClusterAlias", sourceClusterAlias);
        result.put("targetClusterAlias", targetClusterAlias);
        return result;
    }
}

