/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror.integration;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.connect.mirror.integration.MirrorConnectorsIntegrationBaseTest;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;

@Tag(value="integration")
public class MirrorConnectorsIntegrationSSLTest
extends MirrorConnectorsIntegrationBaseTest {
    @Override
    @BeforeEach
    public void startClusters() throws Exception {
        Map sslConfig = TestSslUtils.createSslConfig((boolean)false, (boolean)true, (ConnectionMode)ConnectionMode.SERVER, (File)TestUtils.tempFile(), (String)"testCert");
        this.backupBrokerProps.put("listener.security.protocol.map", "EXTERNAL:SSL,CONTROLLER:SSL");
        this.backupBrokerProps.putAll((Map<?, ?>)sslConfig);
        Properties sslProps = new Properties();
        sslProps.put("ssl.truststore.location", sslConfig.get("ssl.truststore.location"));
        sslProps.put("ssl.truststore.password", ((Password)sslConfig.get("ssl.truststore.password")).value());
        sslProps.put("security.protocol", "SSL");
        this.backupWorkerProps.putAll(sslProps.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()))));
        this.mm2Props.putAll(sslProps.entrySet().stream().collect(Collectors.toMap(e -> "backup." + String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()))));
        this.mm2Props.putAll(sslProps.entrySet().stream().collect(Collectors.toMap(e -> "backup.producer." + String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()))));
        super.startClusters();
    }
}

