/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.acl.AclBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeLocalMetadataStore {
    private static final Logger log = LoggerFactory.getLogger(FakeLocalMetadataStore.class);
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, String>> ALL_TOPICS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Vector<AclBinding>> ALL_ACLS = new ConcurrentHashMap();

    public static void addTopicToLocalMetadataStore(NewTopic newTopic) {
        ConcurrentHashMap<String, String> configs = new ConcurrentHashMap<String, String>(newTopic.configs());
        configs.putIfAbsent("partitions", String.valueOf(newTopic.numPartitions()));
        ALL_TOPICS.putIfAbsent(newTopic.name(), configs);
    }

    public static void updatePartitionCount(String topic, int newPartitionCount) {
        ConcurrentHashMap<String, String> configs = ALL_TOPICS.getOrDefault(topic, new ConcurrentHashMap());
        configs.compute("partitions", (key, value) -> String.valueOf(newPartitionCount));
        ALL_TOPICS.putIfAbsent(topic, configs);
    }

    public static void updateTopicConfig(String topic, Config newConfig) {
        ConcurrentHashMap topicConfigs = ALL_TOPICS.getOrDefault(topic, new ConcurrentHashMap());
        newConfig.entries().forEach(configEntry -> {
            if (configEntry.name() != null) {
                if (configEntry.value() != null) {
                    log.debug("Topic '{}' update config '{}' to '{}'", new Object[]{topic, configEntry.name(), configEntry.value()});
                    topicConfigs.compute(configEntry.name(), (key, value) -> configEntry.value());
                } else {
                    log.warn("Topic '{}' has config '{}' set to null", (Object)topic, (Object)configEntry.name());
                }
            }
        });
        ALL_TOPICS.putIfAbsent(topic, topicConfigs);
    }

    public static Boolean containsTopic(String topic) {
        return ALL_TOPICS.containsKey(topic);
    }

    public static Map<String, String> topicConfig(String topic) {
        return ALL_TOPICS.getOrDefault(topic, new ConcurrentHashMap());
    }

    public static List<AclBinding> aclBindings(String aclPrinciple) {
        return ALL_ACLS.getOrDefault("User:" + aclPrinciple, new Vector());
    }

    public static void addACLs(String principal, AclBinding aclBinding) {
        Vector<AclBinding> aclBindings = ALL_ACLS.getOrDefault(principal, new Vector());
        aclBindings.add(aclBinding);
        ALL_ACLS.putIfAbsent(principal, aclBindings);
    }

    public static void clear() {
        ALL_TOPICS.clear();
        ALL_ACLS.clear();
    }
}

