/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror.clients.admin;

import java.util.Collection;
import java.util.Map;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ForwardingAdmin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.connect.mirror.clients.admin.FakeLocalMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeForwardingAdminWithLocalMetadata
extends ForwardingAdmin {
    private static final Logger log = LoggerFactory.getLogger(FakeForwardingAdminWithLocalMetadata.class);

    public FakeForwardingAdminWithLocalMetadata(Map<String, Object> configs) {
        super(configs);
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
        CreateTopicsResult createTopicsResult = super.createTopics(newTopics, options);
        newTopics.forEach(newTopic -> ((KafkaFuture)createTopicsResult.values().get(newTopic.name())).whenComplete((ignored, error) -> {
            if (error == null) {
                FakeLocalMetadataStore.addTopicToLocalMetadataStore(newTopic);
            } else if (error.getCause() instanceof TopicExistsException) {
                log.warn("Topic '{}' already exists. Update the local metadata store if absent", (Object)newTopic.name());
                FakeLocalMetadataStore.addTopicToLocalMetadataStore(newTopic);
            } else {
                log.error("Unable to intercept admin client operation", error);
            }
        }));
        return createTopicsResult;
    }

    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions, CreatePartitionsOptions options) {
        CreatePartitionsResult createPartitionsResult = super.createPartitions(newPartitions, options);
        newPartitions.forEach((topic, newPartition) -> ((KafkaFuture)createPartitionsResult.values().get(topic)).whenComplete((ignored, error) -> {
            if (error == null) {
                FakeLocalMetadataStore.updatePartitionCount(topic, newPartition.totalCount());
            } else {
                log.error("Unable to intercept admin client operation", error);
            }
        }));
        return createPartitionsResult;
    }

    public CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        CreateAclsResult aclsResult = super.createAcls(acls, options);
        aclsResult.values().forEach((aclBinding, future) -> future.whenComplete((ignored, error) -> {
            if (error == null) {
                FakeLocalMetadataStore.addACLs(aclBinding.entry().principal(), aclBinding);
            } else {
                log.error("Unable to intercept admin client operation", error);
            }
        }));
        return aclsResult;
    }
}

