/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.connect.mirror.MirrorSourceConnector;
import org.apache.kafka.connect.mirror.MirrorSourceMetrics;
import org.apache.kafka.connect.mirror.MirrorSourceTaskConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MirrorSourceMetricsTest {
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final TopicPartition TP = new TopicPartition("topic", 0);
    private static final TopicPartition SOURCE_TP = new TopicPartition("source." + TP.topic(), TP.partition());
    private final Map<String, String> configs = new HashMap<String, String>();
    private TestReporter reporter;

    @BeforeEach
    public void setUp() {
        this.configs.put("name", "name");
        this.configs.put("connector.class", MirrorSourceConnector.class.getName());
        this.configs.put("source.cluster.alias", SOURCE);
        this.configs.put("target.cluster.alias", TARGET);
        this.configs.put("task.index", "0");
        this.configs.put("task.assigned.partitions", TP.toString());
        this.reporter = new TestReporter();
    }

    @Test
    public void testTags() {
        MirrorSourceTaskConfig taskConfig = new MirrorSourceTaskConfig(this.configs);
        MirrorSourceMetrics metrics = new MirrorSourceMetrics(taskConfig);
        metrics.addReporter((MetricsReporter)this.reporter);
        metrics.countRecord(SOURCE_TP);
        Assertions.assertEquals((int)13, (int)this.reporter.metrics.size());
        Map tags = this.reporter.metrics.get(0).metricName().tags();
        Assertions.assertEquals((Object)SOURCE, tags.get(SOURCE));
        Assertions.assertEquals((Object)TARGET, tags.get(TARGET));
        Assertions.assertEquals((Object)SOURCE_TP.topic(), tags.get("topic"));
        Assertions.assertEquals((Object)String.valueOf(SOURCE_TP.partition()), tags.get("partition"));
    }

    static class TestReporter
    implements MetricsReporter {
        List<KafkaMetric> metrics = new ArrayList<KafkaMetric>();

        TestReporter() {
        }

        public void init(List<KafkaMetric> metrics) {
            for (KafkaMetric metric : metrics) {
                this.metricChange(metric);
            }
        }

        public void metricChange(KafkaMetric metric) {
            this.metrics.add(metric);
        }

        public void metricRemoval(KafkaMetric metric) {
        }

        public void close() {
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

