/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.FakeForwardingAdmin;
import org.apache.kafka.clients.admin.ForwardingAdmin;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.FakeMetricsReporter;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.connect.mirror.DefaultTopicFilter;
import org.apache.kafka.connect.mirror.MirrorCheckpointConfig;
import org.apache.kafka.connect.mirror.MirrorClientConfig;
import org.apache.kafka.connect.mirror.MirrorMakerConfig;
import org.apache.kafka.connect.mirror.MirrorSourceConfig;
import org.apache.kafka.connect.mirror.MirrorSourceConnector;
import org.apache.kafka.connect.mirror.SourceAndTarget;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorMakerConfigTest {
    private Map<String, String> makeProps(String ... keyValues) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            props.put(keyValues[i], keyValues[i + 1]);
        }
        return props;
    }

    @Test
    public void testClusterConfigProperties() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b", "a.bootstrap.servers", "servers-one", "b.bootstrap.servers", "servers-two", "security.protocol", "SSL", "replication.factor", "4"));
        Map connectorProps = mirrorConfig.connectorBaseConfig(new SourceAndTarget("a", "b"), MirrorSourceConnector.class);
        Assertions.assertEquals((Object)"servers-one", connectorProps.get("source.cluster.bootstrap.servers"), (String)"source.cluster.bootstrap.servers is set");
        Assertions.assertEquals((Object)"servers-two", connectorProps.get("target.cluster.bootstrap.servers"), (String)"target.cluster.bootstrap.servers is set");
        Assertions.assertEquals((Object)"SSL", connectorProps.get("security.protocol"), (String)"top-level security.protocol is passed through to connector config");
    }

    @Test
    public void testReplicationConfigProperties() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b", "a->b.tasks.max", "123"));
        Map connectorProps = mirrorConfig.connectorBaseConfig(new SourceAndTarget("a", "b"), MirrorSourceConnector.class);
        Assertions.assertEquals((Object)"123", connectorProps.get("tasks.max"), (String)"connector props should include tasks.max");
    }

    @Test
    public void testClientConfigProperties() {
        String clusterABootstrap = "127.0.0.1:9092, 127.0.0.2:9092";
        String clusterBBootstrap = "127.0.0.3:9092, 127.0.0.4:9092";
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b", "config.providers", "fake", "config.providers.fake.class", FakeConfigProvider.class.getName(), "replication.policy.separator", "__", "ssl.key.password", "${fake:secret:password}", "security.protocol", "SSL", "a.security.protocol", "PLAINTEXT", "a.producer.security.protocol", "SSL", "a.bootstrap.servers", clusterABootstrap, "b.bootstrap.servers", clusterBBootstrap, "metrics.reporter", FakeMetricsReporter.class.getName(), "a.metrics.reporter", FakeMetricsReporter.class.getName(), "b->a.metrics.reporter", FakeMetricsReporter.class.getName(), "b.forwarding.admin.class", FakeForwardingAdmin.class.getName(), "a.xxx", "yyy", "xxx", "zzz"));
        MirrorClientConfig aClientConfig = mirrorConfig.clientConfig("a");
        MirrorClientConfig bClientConfig = mirrorConfig.clientConfig("b");
        Assertions.assertEquals((Object)"__", (Object)aClientConfig.getString("replication.policy.separator"), (String)"replication.policy.separator is picked up in MirrorClientConfig");
        Assertions.assertEquals((Object)"b__topic1", (Object)aClientConfig.replicationPolicy().formatRemoteTopic("b", "topic1"), (String)"replication.policy.separator is honored");
        Assertions.assertEquals((Object)clusterABootstrap, aClientConfig.adminConfig().get("bootstrap.servers"), (String)"client configs include bootstrap.servers");
        try (ForwardingAdmin forwardingAdmin = aClientConfig.forwardingAdmin(aClientConfig.adminConfig());){
            Assertions.assertEquals((Object)ForwardingAdmin.class.getName(), (Object)forwardingAdmin.getClass().getName(), (String)"Cluster a uses the default ForwardingAdmin");
        }
        Assertions.assertEquals((Object)"PLAINTEXT", aClientConfig.adminConfig().get("security.protocol"), (String)"client configs include security.protocol");
        Assertions.assertEquals((Object)"SSL", aClientConfig.producerConfig().get("security.protocol"), (String)"producer configs include security.protocol");
        Assertions.assertFalse((boolean)aClientConfig.adminConfig().containsKey("xxx"), (String)"unknown properties aren't included in client configs");
        Assertions.assertFalse((boolean)aClientConfig.adminConfig().containsKey("metric.reporters"), (String)"top-level metrics reporters aren't included in client configs");
        Assertions.assertEquals((Object)"secret2", (Object)aClientConfig.getPassword("ssl.key.password").value(), (String)"security properties are translated from external sources");
        Assertions.assertEquals((Object)"secret2", (Object)((Password)aClientConfig.adminConfig().get("ssl.key.password")).value(), (String)"client configs are translated from external sources");
        Assertions.assertFalse((boolean)aClientConfig.producerConfig().containsKey("metrics.reporter"), (String)"client configs should not include metrics reporter");
        Assertions.assertFalse((boolean)bClientConfig.adminConfig().containsKey("metrics.reporter"), (String)"client configs should not include metrics reporter");
        forwardingAdmin = bClientConfig.forwardingAdmin(bClientConfig.adminConfig());
        try {
            Assertions.assertEquals((Object)FakeForwardingAdmin.class.getName(), (Object)forwardingAdmin.getClass().getName(), (String)"Cluster b should use the FakeForwardingAdmin");
        }
        finally {
            if (forwardingAdmin != null) {
                forwardingAdmin.close();
            }
        }
    }

    @Test
    public void testIncludesConnectorConfigProperties() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b", "tasks.max", "100", "topics", "topic-1", "groups", "group-2", "replication.policy.separator", "__", "config.properties.exclude", "property-3", "metric.reporters", "FakeMetricsReporter", "topic.filter.class", DefaultTopicFilter.class.getName(), "xxx", "yyy"));
        SourceAndTarget sourceAndTarget = new SourceAndTarget("source", "target");
        Map connectorProps = mirrorConfig.connectorBaseConfig(sourceAndTarget, MirrorSourceConnector.class);
        MirrorSourceConfig sourceConfig = new MirrorSourceConfig(connectorProps);
        Assertions.assertEquals((int)100, (int)sourceConfig.getInt("tasks.max"), (String)"Connector properties like tasks.max should be passed through to underlying Connectors.");
        Assertions.assertEquals(Collections.singletonList("topic-1"), (Object)sourceConfig.getList("topics"), (String)"Topics include should be passed through to underlying Connectors.");
        Assertions.assertEquals(Collections.singletonList("property-3"), (Object)sourceConfig.getList("config.properties.exclude"), (String)"Config properties exclude should be passed through to underlying Connectors.");
        Assertions.assertEquals(Collections.singletonList("FakeMetricsReporter"), (Object)sourceConfig.getList("metric.reporters"), (String)"Metrics reporters should be passed through to underlying Connectors.");
        Assertions.assertEquals((Object)"DefaultTopicFilter", (Object)sourceConfig.getClass("topic.filter.class").getSimpleName(), (String)"Filters should be passed through to underlying Connectors.");
        Assertions.assertEquals((Object)"__", (Object)sourceConfig.getString("replication.policy.separator"), (String)"replication policy separator should be passed through to underlying Connectors.");
        Assertions.assertFalse((boolean)sourceConfig.originals().containsKey("xxx"), (String)"Unknown properties should not be passed through to Connectors.");
        MirrorCheckpointConfig checkpointConfig = new MirrorCheckpointConfig(connectorProps);
        Assertions.assertEquals(Collections.singletonList("group-2"), (Object)checkpointConfig.getList("groups"), (String)"Groups include should be passed through to underlying Connectors.");
    }

    @Test
    public void testIncludesTopicFilterProperties() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b", "source->target.topics", "topic1, topic2", "source->target.topics.exclude", "topic3"));
        SourceAndTarget sourceAndTarget = new SourceAndTarget("source", "target");
        Map connectorProps = mirrorConfig.connectorBaseConfig(sourceAndTarget, MirrorSourceConnector.class);
        DefaultTopicFilter.TopicFilterConfig filterConfig = new DefaultTopicFilter.TopicFilterConfig(connectorProps);
        Assertions.assertEquals(Arrays.asList("topic1", "topic2"), (Object)filterConfig.getList("topics"), (String)"source->target.topics should be passed through to TopicFilters.");
        Assertions.assertEquals(Collections.singletonList("topic3"), (Object)filterConfig.getList("topics.exclude"), (String)"source->target.topics.exclude should be passed through to TopicFilters.");
    }

    @Test
    public void testWorkerConfigs() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b", "config.providers", "fake", "config.providers.fake.class", FakeConfigProvider.class.getName(), "replication.policy.separator", "__", "offset.storage.replication.factor", "123", "b.status.storage.replication.factor", "456", "b.producer.client.id", "client-one", "b.security.protocol", "PLAINTEXT", "b.producer.security.protocol", "SASL", "ssl.truststore.password", "secret1", "ssl.key.password", "${fake:secret:password}", "b.xxx", "yyy"));
        SourceAndTarget a = new SourceAndTarget("b", "a");
        SourceAndTarget b = new SourceAndTarget("a", "b");
        Map aProps = mirrorConfig.workerConfig(a);
        Assertions.assertEquals((Object)"b->a", aProps.get("client.id"));
        Assertions.assertEquals((Object)"123", aProps.get("offset.storage.replication.factor"));
        Assertions.assertEquals((Object)"__", aProps.get("replication.policy.separator"));
        Assertions.assertEquals((Object)"fake", aProps.get("config.providers"));
        Map bProps = mirrorConfig.workerConfig(b);
        Assertions.assertEquals((Object)"a->b", bProps.get("client.id"));
        Assertions.assertEquals((Object)"456", bProps.get("status.storage.replication.factor"));
        Assertions.assertEquals((Object)"client-one", bProps.get("producer.client.id"), (String)("producer props should be passed through to worker producer config: " + String.valueOf(bProps)));
        Assertions.assertEquals((Object)"SASL", bProps.get("producer.security.protocol"), (String)"replication-level security props should be passed through to worker producer config");
        Assertions.assertEquals((Object)"SASL", bProps.get("producer.security.protocol"), (String)"replication-level security props should be passed through to worker producer config");
        Assertions.assertEquals((Object)"PLAINTEXT", bProps.get("consumer.security.protocol"), (String)"replication-level security props should be passed through to worker consumer config");
        Assertions.assertEquals((Object)"secret1", bProps.get("ssl.truststore.password"), (String)("security properties should be passed through to worker config: " + String.valueOf(bProps)));
        Assertions.assertEquals((Object)"secret1", bProps.get("producer.ssl.truststore.password"), (String)("security properties should be passed through to worker producer config: " + String.valueOf(bProps)));
        Assertions.assertEquals((Object)"secret2", bProps.get("ssl.key.password"), (String)"security properties should be transformed in worker config");
        Assertions.assertEquals((Object)"secret2", bProps.get("producer.ssl.key.password"), (String)"security properties should be transformed in worker producer config");
        Assertions.assertEquals((Object)"__", bProps.get("replication.policy.separator"));
    }

    @Test
    public void testClusterPairsWithDefaultSettings() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b, c"));
        List clusterPairs = mirrorConfig.clusterPairs();
        Assertions.assertEquals((int)6, (int)clusterPairs.size(), (String)"clusterPairs count should match all combinations count");
    }

    @Test
    public void testEmptyClusterPairsWithGloballyDisabledHeartbeats() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b, c", "emit.heartbeats.enabled", "false"));
        Assertions.assertEquals((int)0, (int)mirrorConfig.clusterPairs().size(), (String)"clusterPairs count should be 0");
    }

    @Test
    public void testClusterPairsWithTwoDisabledHeartbeats() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b, c", "a->b.emit.heartbeats.enabled", "false", "a->c.emit.heartbeats.enabled", "false"));
        List clusterPairs = mirrorConfig.clusterPairs();
        Assertions.assertEquals((int)4, (int)clusterPairs.size(), (String)"clusterPairs count should match all combinations count except x->y.emit.heartbeats.enabled=false");
    }

    @Test
    public void testClusterPairsWithGloballyDisabledHeartbeats() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b, c, d, e, f", "emit.heartbeats.enabled", "false", "a->b.enabled", "true", "a->c.enabled", "true", "a->d.enabled", "true", "a->e.enabled", "false", "a->f.enabled", "false"));
        List clusterPairs = mirrorConfig.clusterPairs();
        Assertions.assertEquals((int)3, (int)clusterPairs.size(), (String)"clusterPairs count should match (x->y.enabled=true or x->y.emit.heartbeats.enabled=true) count");
        SourceAndTarget sourceAndTarget = new SourceAndTarget("b", "a");
        Assertions.assertFalse((boolean)clusterPairs.contains(sourceAndTarget), (String)"disabled/unset link x->y should not be in clusterPairs");
    }

    @Test
    public void testClusterPairsWithGloballyDisabledHeartbeatsCentralLocal() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "central, local_one, local_two, beats_emitter", "emit.heartbeats.enabled", "false", "central->local_one.enabled", "true", "central->local_two.enabled", "true", "beats_emitter->central.emit.heartbeats.enabled", "true"));
        Assertions.assertEquals((int)3, (int)mirrorConfig.clusterPairs().size(), (String)"clusterPairs count should match (x->y.enabled=true or x->y.emit.heartbeats.enabled=true) count");
    }

    @Test
    public void testInvalidSecurityProtocol() {
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new MirrorMakerConfig(this.makeProps("clusters", "a, b, c", "a->b.emit.heartbeats.enabled", "false", "a->c.emit.heartbeats.enabled", "false", "security.protocol", "abc")));
        Assertions.assertTrue((boolean)ce.getMessage().contains("security.protocol"));
    }

    @Test
    public void testClientInvalidSecurityProtocol() {
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new MirrorClientConfig(this.makeProps("security.protocol", "abc")));
        Assertions.assertTrue((boolean)ce.getMessage().contains("security.protocol"));
    }

    @Test
    public void testCaseInsensitiveSecurityProtocol() {
        String saslSslLowerCase = SecurityProtocol.SASL_SSL.name.toLowerCase(Locale.ROOT);
        MirrorClientConfig config = new MirrorClientConfig(this.makeProps("security.protocol", saslSslLowerCase));
        Assertions.assertEquals((Object)saslSslLowerCase, config.originalsStrings().get("security.protocol"));
    }

    @Test
    public void testAllConfigNames() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b"));
        Set allNames = mirrorConfig.allConfigNames();
        Assertions.assertTrue((boolean)allNames.contains("topics"));
        Assertions.assertTrue((boolean)allNames.contains("groups"));
        Assertions.assertTrue((boolean)allNames.contains("emit.heartbeats.enabled"));
    }

    @Test
    public void testLazyConfigResolution() {
        MirrorMakerConfig mirrorConfig = new MirrorMakerConfig(this.makeProps("clusters", "a, b", "config.providers", "fake", "config.providers.fake.class", FakeConfigProvider.class.getName(), "replication.policy.separator", "__", "offset.storage.replication.factor", "123", "b.status.storage.replication.factor", "456", "b.producer.client.id", "client-one", "b.security.protocol", "PLAINTEXT", "b.producer.security.protocol", "SASL", "ssl.truststore.password", "secret1", "ssl.key.password", "${fake:secret:password}", "b.xxx", "yyy", "b->a.topics", "${fake:secret:password}"));
        SourceAndTarget a = new SourceAndTarget("b", "a");
        Map props = mirrorConfig.connectorBaseConfig(a, MirrorSourceConnector.class);
        Assertions.assertEquals((Object)"${fake:secret:password}", props.get("ssl.key.password"), (String)"connector properties should not be transformed");
        Assertions.assertEquals((Object)"${fake:secret:password}", props.get("topics"), (String)"connector properties should not be transformed");
    }

    public static class FakeConfigProvider
    implements ConfigProvider {
        Map<String, String> secrets = Collections.singletonMap("password", "secret2");

        public void configure(Map<String, ?> props) {
        }

        public void close() {
        }

        public ConfigData get(String path) {
            return new ConfigData(this.secrets);
        }

        public ConfigData get(String path, Set<String> keys) {
            return this.get(path);
        }
    }
}

