/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.mirror.MirrorCheckpointConfig;
import org.apache.kafka.connect.mirror.MirrorCheckpointConnector;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MirrorCheckpointConnectorTest {
    private static final String CONSUMER_GROUP = "consumer-group-1";
    private static final Map<String, ?> SOURCE_OFFSET = MirrorUtils.wrapOffset((long)0L);

    @Test
    public void testMirrorCheckpointConnectorDisabled() {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps("emit.checkpoints.enabled", "false"));
        HashSet<String> knownConsumerGroups = new HashSet<String>();
        knownConsumerGroups.add(CONSUMER_GROUP);
        List output = new MirrorCheckpointConnector(knownConsumerGroups, config).taskConfigs(1);
        Assertions.assertEquals((int)0, (int)output.size(), (String)"MirrorCheckpointConnector not disabled");
    }

    @Test
    public void testMirrorCheckpointConnectorEnabled() {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps("emit.checkpoints.enabled", "true"));
        HashSet<String> knownConsumerGroups = new HashSet<String>();
        knownConsumerGroups.add(CONSUMER_GROUP);
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector(knownConsumerGroups, config);
        List output = connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)output.size(), (String)"MirrorCheckpointConnectorEnabled for consumer-group-1 has incorrect size");
        Assertions.assertEquals((Object)CONSUMER_GROUP, ((Map)output.get(0)).get("task.assigned.groups"), (String)"MirrorCheckpointConnectorEnabled for consumer-group-1 failed");
    }

    @Test
    public void testNoConsumerGroup() {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps(new String[0]));
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector(new HashSet(), config);
        List output = connector.taskConfigs(1);
        Assertions.assertEquals((int)0, (int)output.size(), (String)"ConsumerGroup shouldn't exist");
    }

    @Test
    public void testConsumerGroupInitializeTimeout() {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps(new String[0]));
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector(null, config);
        Assertions.assertThrows(RetriableException.class, () -> connector.taskConfigs(1), (String)"taskConfigs should throw exception when initial loading ConsumerGroup timeout");
    }

    @Test
    public void testReplicationDisabled() {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps("enabled", "false"));
        HashSet<String> knownConsumerGroups = new HashSet<String>();
        knownConsumerGroups.add(CONSUMER_GROUP);
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector(knownConsumerGroups, config);
        List output = connector.taskConfigs(1);
        Assertions.assertEquals((int)0, (int)output.size(), (String)"Replication isn't disabled");
    }

    @Test
    public void testReplicationEnabled() {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps("enabled", "true"));
        HashSet<String> knownConsumerGroups = new HashSet<String>();
        knownConsumerGroups.add(CONSUMER_GROUP);
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector(knownConsumerGroups, config);
        List output = connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)output.size(), (String)"Replication for consumer-group-1 has incorrect size");
        Assertions.assertEquals((Object)CONSUMER_GROUP, ((Map)output.get(0)).get("task.assigned.groups"), (String)"Replication for consumer-group-1 failed");
    }

    @Test
    public void testFindConsumerGroups() throws Exception {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps(new String[0]));
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector(Collections.emptySet(), config);
        connector = (MirrorCheckpointConnector)Mockito.spy((Object)connector);
        List<GroupListing> groups = Arrays.asList(new GroupListing("g1", Optional.of(GroupType.CLASSIC), "", Optional.empty()), new GroupListing("g2", Optional.of(GroupType.CLASSIC), "consumer", Optional.empty()));
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(new TopicPartition("t1", 0), new OffsetAndMetadata(0L));
        ((MirrorCheckpointConnector)Mockito.doReturn(groups).when((Object)connector)).listConsumerGroups();
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)true).when((Object)connector)).shouldReplicateByTopicFilter(ArgumentMatchers.anyString());
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)true).when((Object)connector)).shouldReplicateByGroupFilter(ArgumentMatchers.anyString());
        HashMap<String, HashMap<TopicPartition, OffsetAndMetadata>> groupToOffsets = new HashMap<String, HashMap<TopicPartition, OffsetAndMetadata>>();
        groupToOffsets.put("g1", offsets);
        groupToOffsets.put("g2", offsets);
        ((MirrorCheckpointConnector)Mockito.doReturn(groupToOffsets).when((Object)connector)).listConsumerGroupOffsets(ArgumentMatchers.anyList());
        Set groupFound = connector.findConsumerGroups();
        Set expectedGroups = groups.stream().map(GroupListing::groupId).collect(Collectors.toSet());
        Assertions.assertEquals(expectedGroups, (Object)groupFound, (String)"Expected groups are not the same as findConsumerGroups");
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)false).when((Object)connector)).shouldReplicateByTopicFilter(ArgumentMatchers.anyString());
        Set topicFilterGroupFound = connector.findConsumerGroups();
        Assertions.assertEquals(Collections.emptySet(), (Object)topicFilterGroupFound);
    }

    @Test
    public void testFindConsumerGroupsInCommonScenarios() throws Exception {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps(new String[0]));
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector(Collections.emptySet(), config);
        connector = (MirrorCheckpointConnector)Mockito.spy((Object)connector);
        List<GroupListing> groups = Arrays.asList(new GroupListing("g1", Optional.of(GroupType.CLASSIC), "", Optional.empty()), new GroupListing("g2", Optional.of(GroupType.CLASSIC), "consumer", Optional.empty()), new GroupListing("g3", Optional.of(GroupType.CLASSIC), "consumer", Optional.empty()), new GroupListing("g4", Optional.of(GroupType.CLASSIC), "consumer", Optional.empty()));
        HashMap<TopicPartition, OffsetAndMetadata> offsetsForGroup1 = new HashMap<TopicPartition, OffsetAndMetadata>();
        HashMap<TopicPartition, OffsetAndMetadata> offsetsForGroup2 = new HashMap<TopicPartition, OffsetAndMetadata>();
        HashMap<TopicPartition, OffsetAndMetadata> offsetsForGroup3 = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsetsForGroup1.put(new TopicPartition("t1", 0), new OffsetAndMetadata(0L));
        offsetsForGroup1.put(new TopicPartition("t2", 0), new OffsetAndMetadata(0L));
        offsetsForGroup2.put(new TopicPartition("t2", 0), new OffsetAndMetadata(0L));
        offsetsForGroup2.put(new TopicPartition("t3", 0), new OffsetAndMetadata(0L));
        offsetsForGroup3.put(new TopicPartition("t3", 0), new OffsetAndMetadata(0L));
        ((MirrorCheckpointConnector)Mockito.doReturn(groups).when((Object)connector)).listConsumerGroups();
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)false).when((Object)connector)).shouldReplicateByTopicFilter("t1");
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)true).when((Object)connector)).shouldReplicateByTopicFilter("t2");
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)false).when((Object)connector)).shouldReplicateByTopicFilter("t3");
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)true).when((Object)connector)).shouldReplicateByGroupFilter("g1");
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)true).when((Object)connector)).shouldReplicateByGroupFilter("g2");
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)true).when((Object)connector)).shouldReplicateByGroupFilter("g3");
        ((MirrorCheckpointConnector)Mockito.doReturn((Object)false).when((Object)connector)).shouldReplicateByGroupFilter("g4");
        HashMap<String, HashMap<TopicPartition, OffsetAndMetadata>> groupToOffsets = new HashMap<String, HashMap<TopicPartition, OffsetAndMetadata>>();
        groupToOffsets.put("g1", offsetsForGroup1);
        groupToOffsets.put("g2", offsetsForGroup2);
        groupToOffsets.put("g3", offsetsForGroup3);
        ((MirrorCheckpointConnector)Mockito.doReturn(groupToOffsets).when((Object)connector)).listConsumerGroupOffsets(Arrays.asList("g1", "g2", "g3"));
        Set groupFound = connector.findConsumerGroups();
        HashSet<String> verifiedSet = new HashSet<String>();
        verifiedSet.add("g1");
        verifiedSet.add("g2");
        Assertions.assertEquals(verifiedSet, (Object)groupFound);
    }

    @Test
    public void testAlterOffsetsIncorrectPartitionKey() {
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector();
        Assertions.assertThrows(ConnectException.class, () -> connector.alterOffsets(null, Collections.singletonMap(Collections.singletonMap("unused_partition_key", "unused_partition_value"), SOURCE_OFFSET)));
        Assertions.assertThrows(ConnectException.class, () -> connector.alterOffsets(null, Collections.singletonMap(null, SOURCE_OFFSET)));
    }

    @Test
    public void testAlterOffsetsMissingPartitionKey() {
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector();
        Function<Map, Boolean> alterOffsets = partition -> connector.alterOffsets(null, Collections.singletonMap(partition, SOURCE_OFFSET));
        Map<String, Object> validPartition = MirrorCheckpointConnectorTest.sourcePartition("consumer-app-1", "t", 3);
        Assertions.assertTrue((boolean)alterOffsets.apply(validPartition));
        for (String key : Arrays.asList("group", "topic", "partition")) {
            HashMap<String, Object> invalidPartition = new HashMap<String, Object>(validPartition);
            invalidPartition.remove(key);
            Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(invalidPartition));
        }
    }

    @Test
    public void testAlterOffsetsInvalidPartitionPartition() {
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector();
        Map<String, Object> partition = MirrorCheckpointConnectorTest.sourcePartition("consumer-app-2", "t", 3);
        partition.put("partition", "a string");
        Assertions.assertThrows(ConnectException.class, () -> connector.alterOffsets(null, Collections.singletonMap(partition, SOURCE_OFFSET)));
    }

    @Test
    public void testAlterOffsetsMultiplePartitions() {
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector();
        Map<String, Object> partition1 = MirrorCheckpointConnectorTest.sourcePartition("consumer-app-3", "t1", 0);
        Map<String, Object> partition2 = MirrorCheckpointConnectorTest.sourcePartition("consumer-app-4", "t1", 1);
        HashMap offsets = new HashMap();
        offsets.put(partition1, SOURCE_OFFSET);
        offsets.put(partition2, SOURCE_OFFSET);
        Assertions.assertTrue((boolean)connector.alterOffsets(null, offsets));
    }

    @Test
    public void testAlterOffsetsIncorrectOffsetKey() {
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector();
        Map<Map<String, Object>, Map<String, Integer>> offsets = Collections.singletonMap(MirrorCheckpointConnectorTest.sourcePartition("consumer-app-5", "t1", 2), Collections.singletonMap("unused_offset_key", 0));
        Assertions.assertThrows(ConnectException.class, () -> connector.alterOffsets(null, offsets));
    }

    @Test
    public void testAlterOffsetsOffsetValues() {
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector();
        Function<Object, Boolean> alterOffsets = offset -> connector.alterOffsets(null, Collections.singletonMap(MirrorCheckpointConnectorTest.sourcePartition("consumer-app-6", "t", 5), Collections.singletonMap("offset", offset)));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply("nan"));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(null));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(new Object()));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(3.14));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(-420));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply("-420"));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply("10"));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(10));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(0x80000000L));
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(0));
    }

    @Test
    public void testSuccessfulAlterOffsets() {
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector();
        Map<Map<String, Object>, Map<String, ?>> offsets = Collections.singletonMap(MirrorCheckpointConnectorTest.sourcePartition("consumer-app-7", "t2", 0), SOURCE_OFFSET);
        Assertions.assertTrue((boolean)connector.alterOffsets(null, offsets));
        Assertions.assertTrue((boolean)connector.alterOffsets(null, Collections.emptyMap()));
    }

    @Test
    public void testAlterOffsetsTombstones() {
        MirrorCheckpointConnector connector = new MirrorCheckpointConnector();
        Function<Map, Boolean> alterOffsets = partition -> connector.alterOffsets(null, Collections.singletonMap(partition, null));
        Map<String, Object> partition2 = MirrorCheckpointConnectorTest.sourcePartition("consumer-app-2", "t", 3);
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(partition2));
        partition2.put("partition", "a string");
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(partition2));
        partition2.remove("partition");
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(partition2));
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(null));
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(Collections.emptyMap()));
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(Collections.singletonMap("unused_partition_key", "unused_partition_value")));
    }

    private static Map<String, Object> sourcePartition(String consumerGroupId, String topic, int partition) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("group", consumerGroupId);
        result.put("topic", topic);
        result.put("partition", partition);
        return result;
    }
}

