/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.connect.mirror.Checkpoint;
import org.apache.kafka.connect.mirror.CheckpointStore;
import org.apache.kafka.connect.mirror.MirrorCheckpointTaskConfig;
import org.apache.kafka.connect.util.Callback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CheckpointStoreTest {
    @Test
    public void testReadCheckpointsTopic() {
        HashSet<String> consumerGroups = new HashSet<String>();
        consumerGroups.add("group1");
        MirrorCheckpointTaskConfig config = (MirrorCheckpointTaskConfig)Mockito.mock(MirrorCheckpointTaskConfig.class);
        Mockito.when((Object)config.checkpointsTopic()).thenReturn((Object)"checkpoint.topic");
        try (CheckpointStore store = new CheckpointStore(config, consumerGroups){

            void readCheckpointsImpl(MirrorCheckpointTaskConfig config, Callback<ConsumerRecord<byte[], byte[]>> consumedCallback) {
                consumedCallback.onCompletion(null, CheckpointStoreTest.this.newCheckpointRecord("group1", "t1", 0, 0L, 0L));
                consumedCallback.onCompletion(null, CheckpointStoreTest.this.newCheckpointRecord("group2", "t1", 0, 0L, 0L));
                consumedCallback.onCompletion(null, (Object)new ConsumerRecord("checkpoint.topic", 0, 0L, (Object)new byte[0], (Object)new byte[0]));
                consumedCallback.onCompletion(null, CheckpointStoreTest.this.newCheckpointRecord("group1", "t1", 0, 1L, 1L));
            }
        };){
            Assertions.assertFalse((boolean)store.isInitialized());
            Assertions.assertTrue((boolean)store.start(), (String)"expected start to return success");
            Assertions.assertTrue((boolean)store.isInitialized());
            HashMap<String, Map<TopicPartition, Checkpoint>> expected = new HashMap<String, Map<TopicPartition, Checkpoint>>();
            expected.put("group1", Collections.singletonMap(new TopicPartition("t1", 0), new Checkpoint("group1", new TopicPartition("t1", 0), 1L, 1L, "")));
            Assertions.assertEquals(expected, (Object)store.checkpointsPerConsumerGroup);
        }
    }

    @Test
    public void testReadCheckpointsTopicError() {
        HashSet<String> consumerGroups = new HashSet<String>();
        consumerGroups.add("group1");
        MirrorCheckpointTaskConfig config = (MirrorCheckpointTaskConfig)Mockito.mock(MirrorCheckpointTaskConfig.class);
        Mockito.when((Object)config.checkpointsTopic()).thenReturn((Object)"checkpoint.topic");
        try (CheckpointStore store = new CheckpointStore(config, consumerGroups){

            void readCheckpointsImpl(MirrorCheckpointTaskConfig config, Callback<ConsumerRecord<byte[], byte[]>> consumedCallback) {
                consumedCallback.onCompletion(null, CheckpointStoreTest.this.newCheckpointRecord("group1", "topic", 1, 0L, 0L));
                consumedCallback.onCompletion((Throwable)new TopicAuthorizationException("test"), null);
            }
        };){
            Assertions.assertFalse((boolean)store.start(), (String)"expected start to return failure");
            Assertions.assertTrue((boolean)store.isInitialized());
            Assertions.assertTrue((boolean)store.checkpointsPerConsumerGroup.isEmpty());
        }
    }

    ConsumerRecord<byte[], byte[]> newCheckpointRecord(String gid, String topic, int partition, long upo, long dwo) {
        Checkpoint cp = new Checkpoint(gid, new TopicPartition(topic, partition), upo, dwo, "");
        return new ConsumerRecord("checkpoint.topic", 0, 0L, (Object)cp.recordKey(), (Object)cp.recordValue());
    }
}

