/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.file.FileStreamSourceConnector;
import org.apache.kafka.connect.file.FileStreamSourceTask;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileStreamSourceConnectorTest
extends EasyMockSupport {
    private static final String SINGLE_TOPIC = "test";
    private static final String MULTIPLE_TOPICS = "test1,test2";
    private static final String FILENAME = "/somefilename";
    private FileStreamSourceConnector connector;
    private ConnectorContext ctx;
    private Map<String, String> sourceProperties;

    @BeforeEach
    public void setup() {
        this.connector = new FileStreamSourceConnector();
        this.ctx = (ConnectorContext)this.createMock(ConnectorContext.class);
        this.connector.initialize(this.ctx);
        this.sourceProperties = new HashMap<String, String>();
        this.sourceProperties.put("topic", SINGLE_TOPIC);
        this.sourceProperties.put("file", FILENAME);
    }

    @Test
    public void testConnectorConfigValidation() {
        this.replayAll();
        List configValues = this.connector.config().validate(this.sourceProperties);
        for (ConfigValue val : configValues) {
            Assertions.assertEquals((int)0, (int)val.errorMessages().size(), (String)("Config property errors: " + val.errorMessages()));
        }
        this.verifyAll();
    }

    @Test
    public void testSourceTasks() {
        this.replayAll();
        this.connector.start(this.sourceProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        Assertions.assertEquals((Object)SINGLE_TOPIC, ((Map)taskConfigs.get(0)).get("topic"));
        taskConfigs = this.connector.taskConfigs(2);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        Assertions.assertEquals((Object)SINGLE_TOPIC, ((Map)taskConfigs.get(0)).get("topic"));
        this.verifyAll();
    }

    @Test
    public void testSourceTasksStdin() {
        EasyMock.replay((Object[])new Object[]{this.ctx});
        this.sourceProperties.remove("file");
        this.connector.start(this.sourceProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertNull(((Map)taskConfigs.get(0)).get("file"));
        EasyMock.verify((Object[])new Object[]{this.ctx});
    }

    @Test
    public void testMultipleSourcesInvalid() {
        this.sourceProperties.put("topic", MULTIPLE_TOPICS);
        Assertions.assertThrows(ConfigException.class, () -> this.connector.start(this.sourceProperties));
    }

    @Test
    public void testTaskClass() {
        EasyMock.replay((Object[])new Object[]{this.ctx});
        this.connector.start(this.sourceProperties);
        Assertions.assertEquals(FileStreamSourceTask.class, (Object)this.connector.taskClass());
        EasyMock.verify((Object[])new Object[]{this.ctx});
    }

    @Test
    public void testMissingTopic() {
        this.sourceProperties.remove("topic");
        Assertions.assertThrows(ConfigException.class, () -> this.connector.start(this.sourceProperties));
    }

    @Test
    public void testBlankTopic() {
        this.sourceProperties.put("topic", "     ");
        Assertions.assertThrows(ConfigException.class, () -> this.connector.start(this.sourceProperties));
    }

    @Test
    public void testInvalidBatchSize() {
        this.sourceProperties.put("batch.size", "abcd");
        Assertions.assertThrows(ConfigException.class, () -> this.connector.start(this.sourceProperties));
    }
}

