/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.file.FileStreamSinkConnector;
import org.apache.kafka.connect.file.FileStreamSinkTask;
import org.easymock.EasyMockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileStreamSinkConnectorTest
extends EasyMockSupport {
    private static final String MULTIPLE_TOPICS = "test1,test2";
    private static final String FILENAME = "/afilename";
    private FileStreamSinkConnector connector;
    private ConnectorContext ctx;
    private Map<String, String> sinkProperties;

    @BeforeEach
    public void setup() {
        this.connector = new FileStreamSinkConnector();
        this.ctx = (ConnectorContext)this.createMock(ConnectorContext.class);
        this.connector.initialize(this.ctx);
        this.sinkProperties = new HashMap<String, String>();
        this.sinkProperties.put("topics", MULTIPLE_TOPICS);
        this.sinkProperties.put("file", FILENAME);
    }

    @Test
    public void testConnectorConfigValidation() {
        this.replayAll();
        List configValues = this.connector.config().validate(this.sinkProperties);
        for (ConfigValue val : configValues) {
            Assertions.assertEquals((int)0, (int)val.errorMessages().size(), (String)("Config property errors: " + val.errorMessages()));
        }
        this.verifyAll();
    }

    @Test
    public void testSinkTasks() {
        this.replayAll();
        this.connector.start(this.sinkProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        taskConfigs = this.connector.taskConfigs(2);
        Assertions.assertEquals((int)2, (int)taskConfigs.size());
        for (int i = 0; i < 2; ++i) {
            Assertions.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        }
        this.verifyAll();
    }

    @Test
    public void testSinkTasksStdout() {
        this.replayAll();
        this.sinkProperties.remove("file");
        this.connector.start(this.sinkProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertNull(((Map)taskConfigs.get(0)).get("file"));
        this.verifyAll();
    }

    @Test
    public void testTaskClass() {
        this.replayAll();
        this.connector.start(this.sinkProperties);
        Assertions.assertEquals(FileStreamSinkTask.class, (Object)this.connector.taskClass());
        this.verifyAll();
    }
}

