/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.file.FileStreamSinkTask;
import org.apache.kafka.connect.sink.SinkRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileStreamSinkTaskTest {
    private FileStreamSinkTask task;
    private ByteArrayOutputStream os;
    private PrintStream printStream;
    @Rule
    public TemporaryFolder topDir = new TemporaryFolder();
    private String outputFile;

    @Before
    public void setup() throws Exception {
        this.os = new ByteArrayOutputStream();
        this.printStream = new PrintStream(this.os);
        this.task = new FileStreamSinkTask(this.printStream);
        File outputDir = this.topDir.newFolder("file-stream-sink-" + UUID.randomUUID().toString());
        this.outputFile = outputDir.getCanonicalPath() + "/connect.output";
    }

    @Test
    public void testPutFlush() {
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        String newLine = System.getProperty("line.separator");
        this.task.put(Arrays.asList(new SinkRecord("topic1", 0, null, null, Schema.STRING_SCHEMA, (Object)"line1", 1L)));
        offsets.put(new TopicPartition("topic1", 0), new OffsetAndMetadata(1L));
        this.task.flush(offsets);
        Assert.assertEquals((Object)("line1" + newLine), (Object)this.os.toString());
        this.task.put(Arrays.asList(new SinkRecord("topic1", 0, null, null, Schema.STRING_SCHEMA, (Object)"line2", 2L), new SinkRecord("topic2", 0, null, null, Schema.STRING_SCHEMA, (Object)"line3", 1L)));
        offsets.put(new TopicPartition("topic1", 0), new OffsetAndMetadata(2L));
        offsets.put(new TopicPartition("topic2", 0), new OffsetAndMetadata(1L));
        this.task.flush(offsets);
        Assert.assertEquals((Object)("line1" + newLine + "line2" + newLine + "line3" + newLine), (Object)this.os.toString());
    }

    @Test
    public void testStart() throws IOException {
        this.task = new FileStreamSinkTask();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("file", this.outputFile);
        this.task.start(props);
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.task.put(Arrays.asList(new SinkRecord("topic1", 0, null, null, Schema.STRING_SCHEMA, (Object)"line0", 1L)));
        offsets.put(new TopicPartition("topic1", 0), new OffsetAndMetadata(1L));
        this.task.flush(offsets);
        int numLines = 3;
        String[] lines = new String[numLines];
        int i = 0;
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.outputFile, new String[0]));){
            lines[i++] = reader.readLine();
            this.task.put(Arrays.asList(new SinkRecord("topic1", 0, null, null, Schema.STRING_SCHEMA, (Object)"line1", 2L), new SinkRecord("topic2", 0, null, null, Schema.STRING_SCHEMA, (Object)"line2", 1L)));
            offsets.put(new TopicPartition("topic1", 0), new OffsetAndMetadata(2L));
            offsets.put(new TopicPartition("topic2", 0), new OffsetAndMetadata(1L));
            this.task.flush(offsets);
            lines[i++] = reader.readLine();
            lines[i++] = reader.readLine();
        }
        while (--i >= 0) {
            Assert.assertEquals((Object)("line" + i), (Object)lines[i]);
        }
    }
}

