/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.file.FileStreamSourceConnector;
import org.apache.kafka.connect.file.FileStreamSourceTask;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileStreamSourceConnectorTest
extends EasyMockSupport {
    private static final String SINGLE_TOPIC = "test";
    private static final String MULTIPLE_TOPICS = "test1,test2";
    private static final String FILENAME = "/somefilename";
    private FileStreamSourceConnector connector;
    private ConnectorContext ctx;
    private Map<String, String> sourceProperties;

    @Before
    public void setup() {
        this.connector = new FileStreamSourceConnector();
        this.ctx = (ConnectorContext)this.createMock(ConnectorContext.class);
        this.connector.initialize(this.ctx);
        this.sourceProperties = new HashMap<String, String>();
        this.sourceProperties.put("topic", SINGLE_TOPIC);
        this.sourceProperties.put("file", FILENAME);
    }

    @Test
    public void testConnectorConfigValidation() {
        this.replayAll();
        List configValues = this.connector.config().validate(this.sourceProperties);
        for (ConfigValue val : configValues) {
            Assert.assertEquals((String)("Config property errors: " + val.errorMessages()), (long)0L, (long)val.errorMessages().size());
        }
        this.verifyAll();
    }

    @Test
    public void testSourceTasks() {
        this.replayAll();
        this.connector.start(this.sourceProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assert.assertEquals((long)1L, (long)taskConfigs.size());
        Assert.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        Assert.assertEquals((Object)SINGLE_TOPIC, ((Map)taskConfigs.get(0)).get("topic"));
        taskConfigs = this.connector.taskConfigs(2);
        Assert.assertEquals((long)1L, (long)taskConfigs.size());
        Assert.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        Assert.assertEquals((Object)SINGLE_TOPIC, ((Map)taskConfigs.get(0)).get("topic"));
        this.verifyAll();
    }

    @Test
    public void testSourceTasksStdin() {
        EasyMock.replay((Object[])new Object[]{this.ctx});
        this.sourceProperties.remove("file");
        this.connector.start(this.sourceProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assert.assertEquals((long)1L, (long)taskConfigs.size());
        Assert.assertNull(((Map)taskConfigs.get(0)).get("file"));
        EasyMock.verify((Object[])new Object[]{this.ctx});
    }

    @Test(expected=ConfigException.class)
    public void testMultipleSourcesInvalid() {
        this.sourceProperties.put("topic", MULTIPLE_TOPICS);
        this.connector.start(this.sourceProperties);
    }

    @Test
    public void testTaskClass() {
        EasyMock.replay((Object[])new Object[]{this.ctx});
        this.connector.start(this.sourceProperties);
        Assert.assertEquals(FileStreamSourceTask.class, (Object)this.connector.taskClass());
        EasyMock.verify((Object[])new Object[]{this.ctx});
    }

    @Test(expected=ConfigException.class)
    public void testMissingTopic() {
        this.sourceProperties.remove("topic");
        this.connector.start(this.sourceProperties);
    }

    @Test(expected=ConfigException.class)
    public void testBlankTopic() {
        this.sourceProperties.put("topic", "     ");
        this.connector.start(this.sourceProperties);
    }

    @Test(expected=ConfigException.class)
    public void testInvalidBatchSize() {
        this.sourceProperties.put("batch.size", "abcd");
        this.connector.start(this.sourceProperties);
    }
}

