/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.file.FileStreamSinkConnector;
import org.apache.kafka.connect.file.FileStreamSinkTask;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileStreamSinkConnectorTest
extends EasyMockSupport {
    private static final String MULTIPLE_TOPICS = "test1,test2";
    private static final String FILENAME = "/afilename";
    private FileStreamSinkConnector connector;
    private ConnectorContext ctx;
    private Map<String, String> sinkProperties;

    @Before
    public void setup() {
        this.connector = new FileStreamSinkConnector();
        this.ctx = (ConnectorContext)this.createMock(ConnectorContext.class);
        this.connector.initialize(this.ctx);
        this.sinkProperties = new HashMap<String, String>();
        this.sinkProperties.put("topics", MULTIPLE_TOPICS);
        this.sinkProperties.put("file", FILENAME);
    }

    @Test
    public void testSinkTasks() {
        this.replayAll();
        this.connector.start(this.sinkProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assert.assertEquals((long)1L, (long)taskConfigs.size());
        Assert.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        taskConfigs = this.connector.taskConfigs(2);
        Assert.assertEquals((long)2L, (long)taskConfigs.size());
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        }
        this.verifyAll();
    }

    @Test
    public void testSinkTasksStdout() {
        this.replayAll();
        this.sinkProperties.remove("file");
        this.connector.start(this.sinkProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assert.assertEquals((long)1L, (long)taskConfigs.size());
        Assert.assertNull(((Map)taskConfigs.get(0)).get("file"));
        this.verifyAll();
    }

    @Test
    public void testTaskClass() {
        this.replayAll();
        this.connector.start(this.sinkProperties);
        Assert.assertEquals(FileStreamSinkTask.class, (Object)this.connector.taskClass());
        this.verifyAll();
    }
}

