/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.file.FileStreamSinkTask;
import org.apache.kafka.connect.sink.SinkRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileStreamSinkTaskTest {
    private FileStreamSinkTask task;
    private ByteArrayOutputStream os;
    private PrintStream printStream;

    @Before
    public void setup() {
        this.os = new ByteArrayOutputStream();
        this.printStream = new PrintStream(this.os);
        this.task = new FileStreamSinkTask(this.printStream);
    }

    @Test
    public void testPutFlush() {
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.task.put(Arrays.asList(new SinkRecord("topic1", 0, null, null, Schema.STRING_SCHEMA, (Object)"line1", 1L)));
        offsets.put(new TopicPartition("topic1", 0), new OffsetAndMetadata(1L));
        this.task.flush(offsets);
        Assert.assertEquals((Object)"line1\n", (Object)this.os.toString());
        this.task.put(Arrays.asList(new SinkRecord("topic1", 0, null, null, Schema.STRING_SCHEMA, (Object)"line2", 2L), new SinkRecord("topic2", 0, null, null, Schema.STRING_SCHEMA, (Object)"line3", 1L)));
        offsets.put(new TopicPartition("topic1", 0), new OffsetAndMetadata(2L));
        offsets.put(new TopicPartition("topic2", 0), new OffsetAndMetadata(1L));
        this.task.flush(offsets);
        Assert.assertEquals((Object)"line1\nline2\nline3\n", (Object)this.os.toString());
    }
}

