/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.file.FileStreamSinkConnector;
import org.apache.kafka.connect.file.FileStreamSinkTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.powermock.api.easymock.PowerMock;

public class FileStreamSinkConnectorTest {
    private static final String MULTIPLE_TOPICS = "test1,test2";
    private static final String[] MULTIPLE_TOPICS_LIST = "test1,test2".split(",");
    private static final List<TopicPartition> MULTIPLE_TOPICS_PARTITIONS = Arrays.asList(new TopicPartition("test1", 1), new TopicPartition("test2", 2));
    private static final String FILENAME = "/afilename";
    private FileStreamSinkConnector connector;
    private ConnectorContext ctx;
    private Map<String, String> sinkProperties;

    @Before
    public void setup() {
        this.connector = new FileStreamSinkConnector();
        this.ctx = (ConnectorContext)PowerMock.createMock(ConnectorContext.class);
        this.connector.initialize(this.ctx);
        this.sinkProperties = new HashMap<String, String>();
        this.sinkProperties.put("topics", MULTIPLE_TOPICS);
        this.sinkProperties.put("file", FILENAME);
    }

    @Test
    public void testSinkTasks() {
        PowerMock.replayAll((Object[])new Object[0]);
        this.connector.start(this.sinkProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assert.assertEquals((long)1L, (long)taskConfigs.size());
        Assert.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        taskConfigs = this.connector.taskConfigs(2);
        Assert.assertEquals((long)2L, (long)taskConfigs.size());
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        }
        PowerMock.verifyAll();
    }

    @Test
    public void testTaskClass() {
        PowerMock.replayAll((Object[])new Object[0]);
        this.connector.start(this.sinkProperties);
        Assert.assertEquals(FileStreamSinkTask.class, (Object)this.connector.taskClass());
        PowerMock.verifyAll();
    }
}

