/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.login.Configuration;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.rest.basic.auth.extension.JaasBasicAuthFilter;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JaasBasicAuthFilterTest {
    private static final String LOGIN_MODULE = "org.apache.kafka.connect.rest.basic.auth.extension.PropertyFileLoginModule";

    @Test
    public void testSuccess() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password");
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getHeaderString("Authorization");
    }

    @Test
    public void testEmptyCredentialsFile() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(false);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password");
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getHeaderString("Authorization");
    }

    @Test
    public void testBadCredential() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user1", "password");
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).abortWith((Response)ArgumentMatchers.any(Response.class));
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getHeaderString("Authorization");
    }

    @Test
    public void testBadPassword() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password1");
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).abortWith((Response)ArgumentMatchers.any(Response.class));
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getHeaderString("Authorization");
    }

    @Test
    public void testUnknownBearer() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Unknown", "user", "password");
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).abortWith((Response)ArgumentMatchers.any(Response.class));
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getHeaderString("Authorization");
    }

    @Test
    public void testUnknownLoginModule() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect1", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password");
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).abortWith((Response)ArgumentMatchers.any(Response.class));
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getHeaderString("Authorization");
    }

    @Test
    public void testUnknownCredentialsFile() throws IOException {
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", "/tmp/testcrednetial");
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password");
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).abortWith((Response)ArgumentMatchers.any(Response.class));
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getHeaderString("Authorization");
    }

    @Test
    public void testNoFileOption() throws IOException {
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", null);
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password");
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).abortWith((Response)ArgumentMatchers.any(Response.class));
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getHeaderString("Authorization");
    }

    @Test
    public void testInternalTaskConfigEndpointSkipped() throws IOException {
        this.testInternalEndpointSkipped("POST", "connectors/connName/tasks");
    }

    @Test
    public void testInternalZombieFencingEndpointSkipped() throws IOException {
        this.testInternalEndpointSkipped("PUT", "connectors/connName/fence");
    }

    private void testInternalEndpointSkipped(String method, String endpoint) throws IOException {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getPath()).thenReturn((Object)endpoint);
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)uriInfo);
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect1", credentialFile.getPath());
        jaasBasicAuthFilter.filter(requestContext);
        ((UriInfo)Mockito.verify((Object)uriInfo)).getPath();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.atLeastOnce())).getMethod();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getUriInfo();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestContext});
    }

    @Test
    public void testPostNotChangingConnectorTask() throws IOException {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getPath()).thenReturn((Object)"local:randomport/connectors/connName");
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)uriInfo);
        String authHeader = "Basic" + Base64.getEncoder().encodeToString("user:password".getBytes());
        Mockito.when((Object)requestContext.getHeaderString("Authorization")).thenReturn((Object)authHeader);
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        jaasBasicAuthFilter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).abortWith((Response)ArgumentMatchers.any(Response.class));
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getUriInfo();
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).getUriInfo();
    }

    @Test
    public void testUnsupportedCallback() {
        JaasBasicAuthFilter.BasicAuthCallBackHandler callbackHandler = new JaasBasicAuthFilter.BasicAuthCallBackHandler(new JaasBasicAuthFilter.BasicAuthCredentials(this.authHeader("basic", "user", "pwd")));
        ChoiceCallback unsupportedCallback = new ChoiceCallback("You take the blue pill... the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill... you stay in Wonderland, and I show you how deep the rabbit hole goes.", new String[]{"blue pill", "red pill"}, 1, true);
        Assertions.assertThrows(ConnectException.class, () -> JaasBasicAuthFilterTest.lambda$testUnsupportedCallback$0((CallbackHandler)callbackHandler, unsupportedCallback));
    }

    @Test
    public void testSecurityContextSet() throws IOException, URISyntaxException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user1", "password1");
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn(Mockito.mock(UriInfo.class));
        Mockito.when((Object)requestContext.getUriInfo().getRequestUri()).thenReturn((Object)new URI("https://foo.bar"));
        jaasBasicAuthFilter.filter(requestContext);
        ArgumentCaptor capturedContext = ArgumentCaptor.forClass(SecurityContext.class);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext)).setSecurityContext((SecurityContext)capturedContext.capture());
        Assertions.assertEquals((Object)"user1", (Object)((SecurityContext)capturedContext.getValue()).getUserPrincipal().getName());
        Assertions.assertTrue((boolean)((SecurityContext)capturedContext.getValue()).isSecure());
    }

    private String authHeader(String authorization, String username, String password) {
        return authorization + " " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    private ContainerRequestContext setMock(String authorization, String username, String password) {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)requestContext.getHeaderString("Authorization")).thenReturn((Object)this.authHeader(authorization, username, password));
        return requestContext;
    }

    private File setupPropertyLoginFile(boolean includeUsers) throws IOException {
        File credentialFile = TestUtils.tempFile((String)"credential", (String)".properties");
        if (includeUsers) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("user=password");
            lines.add("user1=password1");
            Files.write(credentialFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        return credentialFile;
    }

    private JaasBasicAuthFilter setupJaasFilter(String name, String credentialFilePath) {
        TestJaasConfig configuration = new TestJaasConfig();
        Map moduleOptions = credentialFilePath != null ? Collections.singletonMap("file", credentialFilePath) : Collections.emptyMap();
        configuration.addEntry(name, LOGIN_MODULE, moduleOptions);
        return new JaasBasicAuthFilter((Configuration)configuration);
    }

    private static /* synthetic */ void lambda$testUnsupportedCallback$0(CallbackHandler callbackHandler, Callback unsupportedCallback) throws Throwable {
        callbackHandler.handle(new Callback[]{unsupportedCallback});
    }
}

