/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.rest.basic.auth.extension.BasicAuthSecurityRestExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasBasicAuthFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JaasBasicAuthFilter.class);
    private static final Set<RequestMatcher> INTERNAL_REQUEST_MATCHERS = new HashSet<RequestMatcher>(Arrays.asList(new RequestMatcher("POST", "/?connectors/([^/]+)/tasks/?"), new RequestMatcher("PUT", "/?connectors/[^/]+/fence/?")));
    private static final String CONNECT_LOGIN_MODULE = "KafkaConnect";
    static final String AUTHORIZATION = "Authorization";
    final Configuration configuration;

    public JaasBasicAuthFilter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.isInternalRequest(requestContext)) {
            log.trace("Skipping authentication for internal request");
            return;
        }
        try {
            log.debug("Authenticating request");
            LoginContext loginContext = new LoginContext(CONNECT_LOGIN_MODULE, null, new BasicAuthCallBackHandler(requestContext.getHeaderString(AUTHORIZATION)), this.configuration);
            loginContext.login();
        }
        catch (LoginException | ConfigException e) {
            log.debug("Request failed authentication", e);
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User cannot access the resource.").build());
        }
    }

    private boolean isInternalRequest(ContainerRequestContext requestContext) {
        return INTERNAL_REQUEST_MATCHERS.stream().anyMatch(m -> m.test(requestContext));
    }

    public static class BasicAuthCallBackHandler
    implements CallbackHandler {
        private static final String BASIC = "basic";
        private static final char COLON = ':';
        private static final char SPACE = ' ';
        private String username;
        private String password;

        public BasicAuthCallBackHandler(String credentials) {
            if (credentials == null) {
                log.trace("No credentials were provided with the request");
                return;
            }
            int space = credentials.indexOf(32);
            if (space <= 0) {
                log.trace("Request credentials were malformed; no space present in value for authorization header");
                return;
            }
            String method = credentials.substring(0, space);
            if (!BASIC.equalsIgnoreCase(method)) {
                log.trace("Request credentials used {} authentication, but only {} supported; ignoring", (Object)method, (Object)BASIC);
                return;
            }
            credentials = credentials.substring(space + 1);
            credentials = new String(Base64.getDecoder().decode(credentials), StandardCharsets.UTF_8);
            int i = credentials.indexOf(58);
            if (i <= 0) {
                log.trace("Request credentials were malformed; no colon present between username and password");
                return;
            }
            this.username = credentials.substring(0, i);
            this.password = credentials.substring(i + 1);
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            ArrayList<Callback> unsupportedCallbacks = new ArrayList<Callback>();
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password != null ? this.password.toCharArray() : null);
                    continue;
                }
                unsupportedCallbacks.add(callback);
            }
            if (!unsupportedCallbacks.isEmpty()) {
                throw new ConnectException(String.format("Unsupported callbacks %s; request authentication will fail. This indicates the Connect worker was configured with a JAAS LoginModule that is incompatible with the %s, and will need to be corrected and restarted.", unsupportedCallbacks, BasicAuthSecurityRestExtension.class.getSimpleName()));
            }
        }
    }

    private static class RequestMatcher
    implements Predicate<ContainerRequestContext> {
        private final String method;
        private final Pattern path;

        public RequestMatcher(String method, String path) {
            this.method = method;
            this.path = Pattern.compile(path);
        }

        @Override
        public boolean test(ContainerRequestContext requestContext) {
            return requestContext.getMethod().equals(this.method) && this.path.matcher(requestContext.getUriInfo().getPath()).matches();
        }
    }
}

