/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.login.Configuration;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.rest.basic.auth.extension.JaasBasicAuthFilter;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"javax.*"})
public class JaasBasicAuthFilterTest {
    private static final String LOGIN_MODULE = "org.apache.kafka.connect.rest.basic.auth.extension.PropertyFileLoginModule";

    @Test
    public void testSuccess() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password", false);
        jaasBasicAuthFilter.filter(requestContext);
    }

    @Test
    public void testEmptyCredentialsFile() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(false);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password", false);
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test
    public void testBadCredential() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user1", "password", true);
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test
    public void testBadPassword() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password1", true);
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test
    public void testUnknownBearer() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Unknown", "user", "password", true);
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test
    public void testUnknownLoginModule() throws IOException {
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect1", credentialFile.getPath());
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password", true);
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test
    public void testUnknownCredentialsFile() throws IOException {
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", "/tmp/testcrednetial");
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password", true);
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test
    public void testNoFileOption() throws IOException {
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", null);
        ContainerRequestContext requestContext = this.setMock("Basic", "user", "password", true);
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test
    public void testPostWithoutAppropriateCredential() throws IOException {
        UriInfo uriInfo = (UriInfo)EasyMock.strictMock(UriInfo.class);
        EasyMock.expect((Object)uriInfo.getPath()).andReturn((Object)"connectors/connName/tasks");
        ContainerRequestContext requestContext = (ContainerRequestContext)EasyMock.strictMock(ContainerRequestContext.class);
        EasyMock.expect((Object)requestContext.getMethod()).andReturn((Object)"POST");
        EasyMock.expect((Object)requestContext.getUriInfo()).andReturn((Object)uriInfo);
        EasyMock.replay((Object[])new Object[]{uriInfo, requestContext});
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect1", credentialFile.getPath());
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test
    public void testPostNotChangingConnectorTask() throws IOException {
        UriInfo uriInfo = (UriInfo)EasyMock.strictMock(UriInfo.class);
        EasyMock.expect((Object)uriInfo.getPath()).andReturn((Object)"local:randomport/connectors/connName");
        ContainerRequestContext requestContext = (ContainerRequestContext)EasyMock.strictMock(ContainerRequestContext.class);
        EasyMock.expect((Object)requestContext.getMethod()).andReturn((Object)"POST");
        EasyMock.expect((Object)requestContext.getUriInfo()).andReturn((Object)uriInfo);
        String authHeader = "Basic" + Base64.getEncoder().encodeToString("user:password".getBytes());
        EasyMock.expect((Object)requestContext.getHeaderString("Authorization")).andReturn((Object)authHeader);
        requestContext.abortWith((Response)EasyMock.anyObject(Response.class));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{uriInfo, requestContext});
        File credentialFile = this.setupPropertyLoginFile(true);
        JaasBasicAuthFilter jaasBasicAuthFilter = this.setupJaasFilter("KafkaConnect", credentialFile.getPath());
        jaasBasicAuthFilter.filter(requestContext);
        EasyMock.verify((Object[])new Object[]{requestContext});
    }

    @Test(expected=ConnectException.class)
    public void testUnsupportedCallback() throws Exception {
        String authHeader = this.authHeader("basic", "user", "pwd");
        JaasBasicAuthFilter.BasicAuthCallBackHandler callbackHandler = new JaasBasicAuthFilter.BasicAuthCallBackHandler(authHeader);
        ChoiceCallback unsupportedCallback = new ChoiceCallback("You take the blue pill... the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill... you stay in Wonderland, and I show you how deep the rabbit hole goes.", new String[]{"blue pill", "red pill"}, 1, true);
        callbackHandler.handle(new Callback[]{unsupportedCallback});
    }

    private String authHeader(String authorization, String username, String password) {
        return authorization + " " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    private ContainerRequestContext setMock(String authorization, String username, String password, boolean exceptionCase) {
        ContainerRequestContext requestContext = (ContainerRequestContext)EasyMock.strictMock(ContainerRequestContext.class);
        EasyMock.expect((Object)requestContext.getMethod()).andReturn((Object)"GET");
        EasyMock.expect((Object)requestContext.getHeaderString("Authorization")).andReturn((Object)this.authHeader(authorization, username, password));
        if (exceptionCase) {
            requestContext.abortWith((Response)EasyMock.anyObject(Response.class));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{requestContext});
        return requestContext;
    }

    private File setupPropertyLoginFile(boolean includeUsers) throws IOException {
        File credentialFile = File.createTempFile("credential", ".properties");
        credentialFile.deleteOnExit();
        if (includeUsers) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("user=password");
            lines.add("user1=password1");
            Files.write(credentialFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        return credentialFile;
    }

    private JaasBasicAuthFilter setupJaasFilter(String name, String credentialFilePath) {
        TestJaasConfig configuration = new TestJaasConfig();
        Map moduleOptions = credentialFilePath != null ? Collections.singletonMap("file", credentialFilePath) : Collections.emptyMap();
        configuration.addEntry(name, LOGIN_MODULE, moduleOptions);
        return new JaasBasicAuthFilter((Configuration)configuration);
    }
}

