/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.security.auth.login.Configuration;
import javax.ws.rs.core.Configurable;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.rest.ConnectRestExtensionContext;
import org.apache.kafka.connect.rest.basic.auth.extension.BasicAuthSecurityRestExtension;
import org.apache.kafka.connect.rest.basic.auth.extension.JaasBasicAuthFilter;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicAuthSecurityRestExtensionTest {
    Configuration priorConfiguration;

    @Before
    public void setup() {
        this.priorConfiguration = Configuration.getConfiguration();
    }

    @After
    public void tearDown() {
        Configuration.setConfiguration(this.priorConfiguration);
    }

    @Test
    public void testJaasConfigurationNotOverwritten() {
        Capture jaasFilter = EasyMock.newCapture();
        Configurable configurable = (Configurable)EasyMock.mock(Configurable.class);
        EasyMock.expect((Object)configurable.register(EasyMock.capture((Capture)jaasFilter))).andReturn(null);
        ConnectRestExtensionContext context = (ConnectRestExtensionContext)EasyMock.mock(ConnectRestExtensionContext.class);
        EasyMock.expect((Object)context.configurable()).andReturn((Object)configurable);
        EasyMock.replay((Object[])new Object[]{configurable, context});
        BasicAuthSecurityRestExtension extension = new BasicAuthSecurityRestExtension();
        Configuration overwrittenConfiguration = (Configuration)EasyMock.mock(Configuration.class);
        Configuration.setConfiguration(overwrittenConfiguration);
        extension.register(context);
        Assert.assertNotEquals((String)"Overwritten JAAS configuration should not be used by basic auth REST extension", (Object)overwrittenConfiguration, (Object)((JaasBasicAuthFilter)jaasFilter.getValue()).configuration);
    }

    @Test
    public void testBadJaasConfigInitialization() {
        SecurityException jaasConfigurationException = new SecurityException(new IOException("Bad JAAS config is bad"));
        Supplier configuration = BasicAuthSecurityRestExtension.initializeConfiguration(() -> {
            throw jaasConfigurationException;
        });
        ConnectException thrownException = (ConnectException)Assert.assertThrows(ConnectException.class, ((Supplier)configuration)::get);
        Assert.assertEquals((Object)jaasConfigurationException, (Object)thrownException.getCause());
    }

    @Test
    public void testGoodJaasConfigInitialization() {
        AtomicBoolean configurationInitializerEvaluated = new AtomicBoolean(false);
        Configuration mockConfiguration = (Configuration)EasyMock.mock(Configuration.class);
        Supplier configuration = BasicAuthSecurityRestExtension.initializeConfiguration(() -> {
            configurationInitializerEvaluated.set(true);
            return mockConfiguration;
        });
        Assert.assertTrue((boolean)configurationInitializerEvaluated.get());
        Assert.assertEquals((Object)mockConfiguration, configuration.get());
    }

    @Test
    public void testBadJaasConfigExtensionSetup() {
        SecurityException jaasConfigurationException = new SecurityException(new IOException("Bad JAAS config is bad"));
        Supplier<Configuration> configuration = () -> {
            throw jaasConfigurationException;
        };
        BasicAuthSecurityRestExtension extension = new BasicAuthSecurityRestExtension(configuration);
        Exception thrownException = (Exception)Assert.assertThrows(Exception.class, () -> extension.configure(Collections.emptyMap()));
        Assert.assertEquals((Object)jaasConfigurationException, (Object)thrownException);
        thrownException = (Exception)Assert.assertThrows(Exception.class, () -> extension.register((ConnectRestExtensionContext)EasyMock.mock(ConnectRestExtensionContext.class)));
        Assert.assertEquals((Object)jaasConfigurationException, (Object)thrownException);
    }
}

