/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import javax.security.auth.login.Configuration;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.connect.rest.basic.auth.extension.JaasBasicAuthFilter;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.easymock.annotation.MockStrict;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"javax.*"})
public class JaasBasicAuthFilterTest {
    @MockStrict
    private ContainerRequestContext requestContext;
    private JaasBasicAuthFilter jaasBasicAuthFilter = new JaasBasicAuthFilter();
    private String previousJaasConfig;
    private Configuration previousConfiguration;
    @MockStrict
    private UriInfo uriInfo;

    @Before
    public void setup() {
        EasyMock.reset((Object[])new Object[]{this.requestContext});
    }

    @After
    public void tearDown() {
        if (this.previousJaasConfig != null) {
            System.setProperty("java.security.auth.login.config", this.previousJaasConfig);
        }
        Configuration.setConfiguration(this.previousConfiguration);
    }

    @Test
    public void testSuccess() throws IOException {
        File credentialFile = File.createTempFile("credential", ".properties");
        credentialFile.deleteOnExit();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("user=password");
        lines.add("user1=password1");
        Files.write(credentialFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        this.setupJaasConfig("KafkaConnect", credentialFile.getPath(), true);
        this.setMock("Basic", "user", "password", false);
        this.jaasBasicAuthFilter.filter(this.requestContext);
    }

    @Test
    public void testBadCredential() throws IOException {
        this.setMock("Basic", "user1", "password", true);
        this.jaasBasicAuthFilter.filter(this.requestContext);
    }

    @Test
    public void testBadPassword() throws IOException {
        this.setMock("Basic", "user", "password1", true);
        this.jaasBasicAuthFilter.filter(this.requestContext);
    }

    @Test
    public void testUnknownBearer() throws IOException {
        this.setMock("Unknown", "user", "password", true);
        this.jaasBasicAuthFilter.filter(this.requestContext);
    }

    @Test
    public void testUnknownLoginModule() throws IOException {
        this.setupJaasConfig("KafkaConnect1", "/tmp/testcrednetial", true);
        Configuration.setConfiguration(null);
        this.setMock("Basic", "user", "password", true);
        this.jaasBasicAuthFilter.filter(this.requestContext);
    }

    @Test
    public void testUnknownCredentialsFile() throws IOException {
        this.setupJaasConfig("KafkaConnect", "/tmp/testcrednetial", true);
        Configuration.setConfiguration(null);
        this.setMock("Basic", "user", "password", true);
        this.jaasBasicAuthFilter.filter(this.requestContext);
    }

    @Test
    public void testEmptyCredentialsFile() throws IOException {
        File jaasConfigFile = File.createTempFile("ks-jaas-", ".conf");
        jaasConfigFile.deleteOnExit();
        System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
        this.setupJaasConfig("KafkaConnect", "", true);
        Configuration.setConfiguration(null);
        this.setMock("Basic", "user", "password", true);
        this.jaasBasicAuthFilter.filter(this.requestContext);
    }

    @Test
    public void testNoFileOption() throws IOException {
        File jaasConfigFile = File.createTempFile("ks-jaas-", ".conf");
        jaasConfigFile.deleteOnExit();
        System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
        this.setupJaasConfig("KafkaConnect", "", false);
        Configuration.setConfiguration(null);
        this.setMock("Basic", "user", "password", true);
        this.jaasBasicAuthFilter.filter(this.requestContext);
    }

    @Test
    public void testPostWithoutAppropriateCredential() throws IOException {
        EasyMock.expect((Object)this.requestContext.getMethod()).andReturn((Object)"POST");
        EasyMock.expect((Object)this.requestContext.getUriInfo()).andReturn((Object)this.uriInfo);
        EasyMock.expect((Object)this.uriInfo.getPath()).andReturn((Object)"connectors/connName/tasks");
        PowerMock.replayAll((Object[])new Object[0]);
        this.jaasBasicAuthFilter.filter(this.requestContext);
        EasyMock.verify((Object[])new Object[]{this.requestContext});
    }

    @Test
    public void testPostNotChangingConnectorTask() throws IOException {
        EasyMock.expect((Object)this.requestContext.getMethod()).andReturn((Object)"POST");
        EasyMock.expect((Object)this.requestContext.getUriInfo()).andReturn((Object)this.uriInfo);
        EasyMock.expect((Object)this.uriInfo.getPath()).andReturn((Object)"local:randomport/connectors/connName");
        String authHeader = "Basic" + Base64.getEncoder().encodeToString("user:password".getBytes());
        EasyMock.expect((Object)this.requestContext.getHeaderString("Authorization")).andReturn((Object)authHeader);
        this.requestContext.abortWith((Response)EasyMock.anyObject(Response.class));
        EasyMock.expectLastCall();
        PowerMock.replayAll((Object[])new Object[0]);
        this.jaasBasicAuthFilter.filter(this.requestContext);
        EasyMock.verify((Object[])new Object[]{this.requestContext});
    }

    private void setMock(String authorization, String username, String password, boolean exceptionCase) {
        EasyMock.expect((Object)this.requestContext.getMethod()).andReturn((Object)"GET");
        String authHeader = authorization + " " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        EasyMock.expect((Object)this.requestContext.getHeaderString("Authorization")).andReturn((Object)authHeader);
        if (exceptionCase) {
            this.requestContext.abortWith((Response)EasyMock.anyObject(Response.class));
            EasyMock.expectLastCall();
        }
        PowerMock.replayAll((Object[])new Object[0]);
    }

    private void setupJaasConfig(String loginModule, String credentialFilePath, boolean includeFileOptions) throws IOException {
        File jaasConfigFile = File.createTempFile("ks-jaas-", ".conf");
        jaasConfigFile.deleteOnExit();
        this.previousJaasConfig = System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(loginModule + " { org.apache.kafka.connect.rest.basic.auth.extension.PropertyFileLoginModule required ");
        if (includeFileOptions) {
            lines.add("file=\"" + credentialFilePath + "\"");
        }
        lines.add(";};");
        Files.write(jaasConfigFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        this.previousConfiguration = Configuration.getConfiguration();
        Configuration.setConfiguration(null);
    }
}

